/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.CollectionUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptFilterParam;
import com.kingdee.eas.fm.be.client.AbstractEReceiptInterruptUI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMBillBaseListUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.erec.TransDetailMatchFilterParam;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EReceiptInterruptUI
extends AbstractEReceiptInterruptUI {
    private static final Logger logger = CoreUIObject.getLogger(EReceiptInterruptUI.class);
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.FmBeEReceiptRescource";
    Map result = new HashMap();
    public CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private static Map bankInterMap = new HashMap();
    public static Set orgCollIDSet;
    static String type;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (type.equals("1")) {
            this.setUITitle(this.resHelper.getString("this.title"));
        } else if (type.equals("2")) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1195_EReceiptInterruptUI"));
        } else if (type.equals("3")) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1196_EReceiptInterruptUI"));
        } else if (type.equals("4")) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1197_EReceiptInterruptUI"));
        }
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        this.setCompanyValue();
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        HashSet companySet = new HashSet();
        if (!EmptyUtil.isEmpty((Collection)orgCollIDSet)) {
            for (Object str : orgCollIDSet) {
                boolean isPass = iPermission.hasFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK((String)str), "eReceipt_06DownLoad");
                if (!isPass) continue;
                companySet.add(str);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", companySet, CompareType.INCLUDE));
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        this.dEeDataCompany.setData((Object)coll.toArray());
        this.initBankInterface();
    }

    protected void setCompanyValue() {
        NewOrgUnitFilterInfoProducer iProducer = null;
        String permissionItem = "eReceipt_06DownLoad";
        iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company);
        if (iProducer != null) {
            if (permissionItem != null) {
                iProducer.getModel().setPermissionItem(permissionItem);
            }
            this.dEeDataCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
            if (iProducer.getModel() != null) {
                this.dEeDataCompany.setSelector((KDPromptSelector)iProducer.getModel());
                this.dEeDataCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
                iProducer.getModel().setMultiSelect(true);
            }
        }
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.dEeDataBankInterface.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setSelector(this.getSelectors());
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (!FMClientHelper.isNotExistsMulBeService()) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
        }
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int k = 0;
        bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.dEeDataBankInterface.addItem((Object)bankAcct);
            bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("beginDateValue", this.dEeDataBeginDate.getSqlDate());
        filter.put("endDateValue", this.dEeDataEndDate.getSqlDate());
        if (this.dEeDataAccountBank.getValue() != null) {
            Object[] temp = this.dEeDataAccountBank.getData() instanceof Object[] ? (Object[])this.dEeDataAccountBank.getData() : new Object[]{this.dEeDataAccountBank.getData()};
            BOSUuid[] accountBank = new BOSUuid[temp.length];
            Object[] bankNumber = new String[temp.length];
            for (int index = 0; index < temp.length; ++index) {
                accountBank[index] = ((AccountBankInfo)temp[index]).getId();
                bankNumber[index] = ((AccountBankInfo)temp[index]).getBankAccountNumber();
            }
            filter.put("accountBank", accountBank);
            filter.put("bankNumber", bankNumber);
        } else {
            filter.put("accountBank", null);
            filter.put("bankNumber", null);
        }
        if (this.dEeDataCompany.getData() != null) {
            Object[] companys = this.dEeDataCompany.getData() instanceof Object[] ? (Object[])this.dEeDataCompany.getData() : new Object[]{this.dEeDataCompany.getData()};
            HashSet<String> companyIds = new HashSet<String>();
            for (Object o : companys) {
                if (EmptyUtil.isEmpty((Object)o)) continue;
                companyIds.add(((CompanyOrgUnitInfo)o).getId().toString());
            }
            if (companyIds.size() > 0) {
                String companyValue = ((Object)companyIds).toString();
                companyValue = companyValue.replaceAll("[\\[\\]\\s]", "");
                companyValue = companyValue.replace(",", "','");
                filter.put("companyValue", companyValue);
            } else {
                filter.put("companyValue", "");
            }
        }
        if (((BankInterface)this.dEeDataBankInterface.getSelectedItem()).toString().equals(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"723_EReceiptControllerBean"))) {
            filter.put("bankInterface", EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"723_EReceiptControllerBean"));
        } else {
            filter.put("bankInterface", ((BankInterface)this.dEeDataBankInterface.getSelectedItem()).getNumber());
        }
        if (EmptyUtil.isEmpty((String)type)) {
            this.result = EReceiptFactory.getRemoteInstance().downEReceiptByManual(filter);
        } else if (type.equals("1")) {
            this.result = EReceiptFactory.getRemoteInstance().downEReceiptByManual(filter);
        } else if (type.equals("2")) {
            this.result = EReceiptFactory.getRemoteInstance().joinTransDetailByManual(filter);
        } else if (type.equals("3")) {
            this.result = EReceiptFactory.getRemoteInstance().downPDFByManual(filter);
        } else if (type.equals("4")) {
            this.result = EReceiptFactory.getRemoteInstance().matchErecBillNumberAndTypeByManual(filter);
        }
        this.disposeUIWindow();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.disposeUIWindow();
    }

    public static Map showPreInterestLoanUI(CoreUI ui, String flag) {
        Map returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            FMBillBaseListUI fmui = (FMBillBaseListUI)ui;
            EReceiptFilterParam param = (EReceiptFilterParam)fmui.getFilterParam();
            orgCollIDSet = param.getMainOrgCollIDSet();
            type = flag;
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EReceiptInterruptUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((EReceiptInterruptUI)uiWindow.getUIObject()).getReturnValueWithMsg();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }

    public static Map showPreInterestLoanUI(UIContext uiContext, String flag) {
        Map returnValue = new HashMap();
        try {
            type = flag;
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EReceiptInterruptUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            EReceiptInterruptUI uui = (EReceiptInterruptUI)uiWindow.getUIObject();
            TransDetailMatchFilterParam param = (TransDetailMatchFilterParam)uiContext.get((Object)"filterParam");
            if (!EmptyUtil.isEmpty((Collection)param.getMainOrgCollIDSet())) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)param.getMainOrgCollIDSet(), CompareType.INCLUDE));
                try {
                    CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                    uui.dEeDataCompany.setValue((Object)coll.toArray());
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
            uui.dEeDataBeginDate.setValue((Object)new Date());
            uui.dEeDataEndDate.setValue((Object)new Date());
            if (EmptyUtil.isEmpty((String)param.getBankInterface())) {
                uui.dEeDataBankInterface.setSelectedItem(uui.dEeDataBankInterface.getItemAt(uui.dEeDataBankInterface.getItemCount() - 1));
            } else {
                int index = (Integer)bankInterMap.get(param.getBankInterface());
                UIUtil.setSelectObject((KDComboBox)uui.dEeDataBankInterface, (Object)uui.dEeDataBankInterface.getItemAt(index));
            }
            try {
                if (param.getBankAcctId() != null) {
                    String[] bankAcctId = param.getBankAcctId();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)CollectionUtil.asSet((String[])bankAcctId), CompareType.INCLUDE));
                    AccountBankCollection bankAcct = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                    uui.dEeDataAccountBank.setData((Object)bankAcct.toArray());
                } else {
                    uui.dEeDataAccountBank.setData(null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            uiWindow.show();
            returnValue = ((EReceiptInterruptUI)uiWindow.getUIObject()).getReturnValueWithMsg();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }

    private Map getReturnValueWithMsg() {
        return this.result;
    }

    public void verify() throws Exception {
        if (this.dEeDataBeginDate.getSqlDate() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBeginDate"));
            SysUtil.abort();
        }
        if (this.dEeDataEndDate.getSqlDate() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckEndDate"));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)this.dEeDataEndDate.getSqlDate()).before(DateTimeUtils.truncateDate((Date)this.dEeDataBeginDate.getSqlDate()))) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"ChecBeginAndEndkDate"));
            SysUtil.abort();
        }
        if (this.dEeDataCompany.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckCompany"));
            SysUtil.abort();
        }
        BigDecimal term = Constants.ZERO;
        BigDecimal time = BigDecimal.valueOf(31L);
        term = new BigDecimal(DateUtil.getDiffDays((Date)this.dEeDataBeginDate.getSqlDate(), (Date)this.dEeDataEndDate.getSqlDate()));
        if (term.compareTo(time) == 1) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"NotDownFromEReceipt"));
            SysUtil.abort();
        }
    }

    @Override
    protected void dEeDataBankInterface_actionPerformed(ActionEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void dEeDataCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    private void reSetF7BankAccountQuery() {
        BankInterface bankFace;
        this.dEeDataAccountBank.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        if (this.dEeDataCompany.getData() != null) {
            Object[] companys = this.dEeDataCompany.getData() instanceof Object[] ? (Object[])this.dEeDataCompany.getData() : new Object[]{this.dEeDataCompany.getData()};
            HashSet<String> companyIds = new HashSet<String>();
            for (Object o : companys) {
                if (EmptyUtil.isEmpty((Object)o)) continue;
                companyIds.add(((CompanyOrgUnitInfo)o).getId().toString());
            }
            if (companyIds.size() > 0) {
                companyFilter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
                agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", companyIds, CompareType.INCLUDE));
            }
        }
        if (this.dEeDataBankInterface.getSelectedItem() instanceof BankInterface && !EmptyUtil.isEmpty((String)(bankFace = (BankInterface)this.dEeDataBankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankFace.getNumber()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.dEeDataAccountBank.setSelectorCollection(selectors);
        this.dEeDataAccountBank.setEntityViewInfo(evi);
        this.dEeDataAccountBank.getQueryAgent().resetRuntimeEntityView();
        this.dEeDataAccountBank.setEnabledMultiSelection(true);
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        EReceiptInterruptUI.type = type;
    }

    static {
        type = "1";
    }
}

