/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptMatchingFilterParam;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.client.AbstractEReceiptMatchingUI;
import com.kingdee.eas.fm.be.client.EReceiptMatchingFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class EReceiptMatchingUI
extends AbstractEReceiptMatchingUI {
    private static final Logger logger = CoreUIObject.getLogger(EReceiptMatchingUI.class);
    private CommonQueryDialog _dialog = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private EReceiptMatchingFilterUI _filterUI = null;
    private Set companyIdSet = null;
    private java.util.Date beginDate = null;
    private java.util.Date endDate = null;
    private String bankAcctId = null;
    private String bankInterface = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.actionQuery_actionPerformed(null);
        this.actionQuery.setEnabled(true);
        this.actionRefresh.setEnabled(true);
        this.initUserConfig();
    }

    protected void initTable() {
        this.tblEReceipt.checkParsed();
        this.tblTransDetail.checkParsed();
        this.tblEReceipt.getSelectManager().setSelectMode(10);
        this.tblTransDetail.getSelectManager().setSelectMode(10);
        this.tblEReceipt.getStyleAttributes().setLocked(true);
        this.tblTransDetail.getStyleAttributes().setLocked(true);
        this.kDSplitPane1.setOrientation(0);
        this.kDSplitPane1.setDividerLocation((this.getHeight() - 60) / 2);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.actionQuery.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_filter"));
        this.actionRefresh.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog queryDialog = this.getQueryDialog();
        if (!queryDialog.show()) {
            SysUtil.abort();
        }
        EReceiptMatchingFilterParam param = (EReceiptMatchingFilterParam)this._filterUI.getParam();
        this.beginDate = param.getBeginDate();
        this.endDate = param.getEndDate();
        this.bankAcctId = param.getBankAcctId();
        this.bankInterface = param.getBankInterface();
        this.companyIdSet = param.getMainOrgCollIDSet();
        this.showDetails();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.showDetails();
    }

    private CommonQueryDialog getQueryDialog() throws Exception {
        MetaDataPK mockQuery = new MetaDataPK("com.kingdee.eas.fm.be", "EReceiptQuery");
        if (this._filterUI == null) {
            this._filterUI = new EReceiptMatchingFilterUI();
        }
        this._dialog = new CommonQueryDialog();
        this._dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this._dialog.setOwner((Component)this.getUIContext().get("Owner"));
        this._dialog.setShowFilter(false);
        this._dialog.setShowSorter(false);
        this._dialog.setEntityViewInfo(new EntityViewInfo());
        this._dialog.setQueryObjectPK((IMetaDataPK)mockQuery);
        this._dialog.addUserPanel((KDPanel)this._filterUI);
        this._dialog.setWidth(586);
        this._dialog.setHeight(260);
        return this._dialog;
    }

    private void showDetails() throws Exception {
        Date endDate1 = new Date(this.endDate.getTime());
        Date beginDate1 = new Date(this.beginDate.getTime());
        EReceiptCollection tblEReceiptCollection = this.getEReceiptCollection(endDate1, beginDate1);
        TransDetailCollection tblTransDetailCollection = this.getTransDetailCollection(endDate1, beginDate1);
        this.showTheDetails(this.tblEReceipt, (IObjectCollection)tblEReceiptCollection);
        this.showTheDetails(this.tblTransDetail, (IObjectCollection)tblTransDetailCollection);
        HashMap resultMap = this.getMatchingMsg(endDate1, beginDate1);
        this.txtEReceipt.setText(beginDate1 + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"578_ElStatementBillControllerBean") + endDate1 + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1216_EReceiptMatchingUI") + resultMap.get("eReceiptSum") + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"100_BankFacadeControllerBean") + "," + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1217_EReceiptMatchingUI") + resultMap.get("eReceiptMatchSum") + "," + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1218_EReceiptMatchingUI") + resultMap.get("eReceiptUnMatchSum") + "," + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1219_EReceiptMatchingUI"));
        this.txtEReceipt.setEditable(false);
        this.txtTransDetail.setText(beginDate1 + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"578_ElStatementBillControllerBean") + endDate1 + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1216_EReceiptMatchingUI") + resultMap.get("transDetailSum") + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"100_BankFacadeControllerBean") + "," + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1217_EReceiptMatchingUI") + resultMap.get("transDetailMatchSum") + "," + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1218_EReceiptMatchingUI") + resultMap.get("transDetailUnMatchSum") + "," + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1219_EReceiptMatchingUI"));
        this.txtTransDetail.setEditable(false);
    }

    private EReceiptCollection getEReceiptCollection(Date endDate1, Date beginDate1) throws Exception {
        EReceiptCollection ecol = null;
        EntityViewInfo view = this.getEReceiptEntityView(endDate1, beginDate1);
        ecol = EReceiptFactory.getRemoteInstance().getEReceiptCollection(view);
        return ecol;
    }

    private TransDetailCollection getTransDetailCollection(Date endDate1, Date beginDate1) throws Exception {
        TransDetailCollection ecol = null;
        EntityViewInfo view = this.getTransDetailEntityView(endDate1, beginDate1);
        ecol = TransDetailFactory.getRemoteInstance().getTransDetailCollection(view);
        return ecol;
    }

    private FilterInfo getEReceiptFilter(Date endDate1, Date beginDate1) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        Set companySet = this.companyIdSet;
        items.add(new FilterItemInfo("company.id", (Object)companySet, CompareType.INCLUDE));
        items.add(new FilterItemInfo("transDate", (Object)beginDate1, CompareType.GREATER_EQUALS));
        items.add(new FilterItemInfo("transDate", (Object)endDate1, CompareType.LESS_EQUALS));
        items.add(new FilterItemInfo("bankAccount.bankInterFaceId", (Object)this.bankInterface));
        items.add(new FilterItemInfo("bankAccount.id", (Object)this.bankAcctId));
        if (this.bankAcctId != null && this.bankInterface != null) {
            filter.setMaskString("#0 and #1 and #2 and #3 and #4");
        } else if (this.bankAcctId == null && this.bankInterface != null) {
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else if (this.bankAcctId != null && this.bankInterface == null) {
            filter.setMaskString("#0 and #1 and #2 and #4");
        } else {
            filter.setMaskString("#0 and #1 and #2");
        }
        return filter;
    }

    private EntityViewInfo getEReceiptEntityView(Date endDate1, Date beginDate1) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        String fil = this.getEReceiptFilter(endDate1, beginDate1).toSql();
        fil = fil + " and  isMatch  = '0'  and TransDetailId  is null";
        FilterInfo filter = new FilterInfo(fil);
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("company.name"));
        view.getSelector().add(new SelectorItemInfo("transDate"));
        view.getSelector().add(new SelectorItemInfo("bank.address"));
        view.getSelector().add(new SelectorItemInfo("bankAccount.number"));
        view.getSelector().add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        view.getSelector().add(new SelectorItemInfo("bankAccount.name"));
        view.getSelector().add(new SelectorItemInfo("currency.name"));
        view.getSelector().add(new SelectorItemInfo("fileName"));
        view.getSelector().add(new SelectorItemInfo("debitAmount"));
        view.getSelector().add(new SelectorItemInfo("creditAmount"));
        view.getSelector().add(new SelectorItemInfo("oppBankNumber"));
        view.getSelector().add(new SelectorItemInfo("oppBank"));
        return view;
    }

    private FilterInfo getTransDetailFilter(Date endDate1, Date beginDate1) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        Set companySet = this.companyIdSet;
        items.add(new FilterItemInfo("company.id", (Object)companySet, CompareType.INCLUDE));
        items.add(new FilterItemInfo("bizDate", (Object)beginDate1, CompareType.GREATER_EQUALS));
        items.add(new FilterItemInfo("bizDate", (Object)endDate1, CompareType.LESS_EQUALS));
        items.add(new FilterItemInfo("bankinterfaceid", (Object)this.bankInterface));
        items.add(new FilterItemInfo("bankAccount.id", (Object)this.bankAcctId));
        if (this.bankAcctId != null && this.bankInterface != null) {
            filter.setMaskString("#0 and #1 and #2 and #3 and #4");
        } else if (this.bankAcctId == null && this.bankInterface != null) {
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else if (this.bankAcctId != null && this.bankInterface == null) {
            filter.setMaskString("#0 and #1 and #2 and #4");
        } else {
            filter.setMaskString("#0 and #1 and #2");
        }
        return filter;
    }

    private EntityViewInfo getTransDetailEntityView(Date endDate1, Date beginDate1) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        String fil = this.getTransDetailFilter(endDate1, beginDate1).toSql();
        fil = fil + "and isMatchEReceipt = '0'";
        FilterInfo filter = new FilterInfo(fil);
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("company.name"));
        view.getSelector().add(new SelectorItemInfo("bizDate"));
        view.getSelector().add(new SelectorItemInfo("bankAccount.number"));
        view.getSelector().add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        view.getSelector().add(new SelectorItemInfo("bankAccount.name"));
        view.getSelector().add(new SelectorItemInfo("currency.name"));
        view.getSelector().add(new SelectorItemInfo("debitAmount"));
        view.getSelector().add(new SelectorItemInfo("creditAmount"));
        view.getSelector().add(new SelectorItemInfo("description"));
        view.getSelector().add(new SelectorItemInfo("oppUnit"));
        view.getSelector().add(new SelectorItemInfo("oppBankNumber"));
        view.getSelector().add(new SelectorItemInfo("oppBank"));
        view.getSelector().add(new SelectorItemInfo("isReced"));
        return view;
    }

    private void showTheDetails(KDTable table, IObjectCollection collection) throws Exception {
        table.removeRows();
        if (collection != null && collection.size() > 0) {
            table.setUserObject((Object)collection);
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                IObjectValue obj = collection.getObject(i);
                IRow row = table.addRow(i);
                this.setLineFields(table, row, obj);
            }
        }
    }

    private void setLineFields(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        Object val = null;
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getKey();
            if (table.equals(this.tblEReceipt) || table.equals(this.tblTransDetail)) {
                String numberFtm = "%r-[ ]{###,###,##0.00}15.2n";
                if (bindField.equals("debitAmount") && obj.get("debitAmount") != null || bindField.equals("creditAmount") && obj.get("creditAmount") != null) {
                    row.getCell(i).getStyleAttributes().setNumberFormat(numberFtm);
                    row.getCell(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                }
            }
            if (bindField.equals("creditAmount") && obj.get("creditAmount") == null && table.equals(this.tblTransDetail)) {
                row.getCell(i).setValue((Object)Constants.ZERO);
            }
            if (bindField.equals("debitAmount") && obj.get("debitAmount") == null && table.equals(this.tblTransDetail)) {
                row.getCell(i).setValue((Object)Constants.ZERO);
            }
            if (bindField.equals("creditAmount") && obj.get("creditAmount") == null && table.equals(this.tblTransDetail)) {
                row.getCell(i).setValue((Object)Constants.ZERO);
            }
            if (bindField.equals("bankAccount.number") && obj.get("bankAccount") != null) {
                row.getCell(i).setValue((Object)((AccountBankInfo)obj.get("bankAccount")).getNumber());
            }
            if (bindField.equals("bankAccount.bankAccountNumber") && obj.get("bankAccount") != null) {
                row.getCell(i).setValue((Object)((AccountBankInfo)obj.get("bankAccount")).getBankAccountNumber());
            }
            if (bindField.equals("bankAccount.name") && obj.get("bankAccount") != null) {
                row.getCell(i).setValue((Object)((AccountBankInfo)obj.get("bankAccount")).getName());
            }
            if (bindField.equals("currency.name") && obj.get("currency") != null) {
                row.getCell(i).setValue(obj.get("currency"));
            }
            if (bindField.equals("company.name") && obj.get("company") != null) {
                row.getCell(i).setValue(obj.get("company"));
            }
            if (bindField.equals("bank.address") && obj.get("bank") != null) {
                row.getCell(i).setValue(obj.get("bank"));
            }
            if (StringUtils.isEmpty((String)bindField) || obj.get(bindField) == null) continue;
            if (obj.get(bindField) instanceof Timestamp) {
                row.getCell(i).setValue((Object)obj.getDate(bindField));
                continue;
            }
            if (obj.get(bindField) instanceof BigDecimal) {
                BigDecimal amt = (BigDecimal)obj.get(bindField);
                logger.info((Object)(bindField + " " + amt));
                row.getCell(i).setValue((Object)amt);
                continue;
            }
            if (bindField.equals("isReced")) {
                if (obj.get("isreced").equals(0)) {
                    row.getCell(i).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1220_EReceiptMatchingUI"));
                    continue;
                }
                row.getCell(i).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1221_EReceiptMatchingUI"));
                continue;
            }
            val = obj.get(bindField);
            if (val == null || String.valueOf(val) == null) continue;
            row.getCell(i).setValue(val);
        }
    }

    public HashMap getMatchingMsg(Date endDate1, Date beginDate1) throws EASBizException, BOSException {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("eReceiptSum", this.getEReceiptMatch(endDate1, beginDate1));
        resultMap.put("eReceiptMatchSum", this.getEReceiptMatch(endDate1, beginDate1) - this.getEReceiptUnMatch(endDate1, beginDate1));
        resultMap.put("eReceiptUnMatchSum", this.getEReceiptUnMatch(endDate1, beginDate1));
        resultMap.put("transDetailSum", this.getTransDetailMatch(endDate1, beginDate1));
        resultMap.put("transDetailMatchSum", this.getTransDetailMatch(endDate1, beginDate1) - this.getTransDetailUnMatch(endDate1, beginDate1));
        resultMap.put("transDetailUnMatchSum", this.getTransDetailUnMatch(endDate1, beginDate1));
        return resultMap;
    }

    public int getEReceiptMatch(Date endDate1, Date beginDate1) {
        IMetaDataPK iMetaDataPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.be.app.EReceiptBillSumQuery");
        IRowSet iRowSet = null;
        int num = 0;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)iMetaDataPK);
            EntityViewInfo ev = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billCount"));
            ev.setSelector(sic);
            String fil = this.getEReceiptFilter(endDate1, beginDate1).toSql();
            FilterInfo filter = new FilterInfo(fil);
            ev.setFilter(filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                num = iRowSet.getInt("billCount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return num;
    }

    public int getEReceiptUnMatch(Date endDate1, Date beginDate1) {
        IMetaDataPK iMetaDataPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.be.app.EReceiptBillSumQuery");
        IRowSet iRowSet = null;
        int num = 0;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)iMetaDataPK);
            exec.option().isAutoTranslateEnum = true;
            EntityViewInfo ev = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billCount"));
            ev.setSelector(sic);
            String fil = this.getEReceiptFilter(endDate1, beginDate1).toSql();
            fil = fil + " and  isMatch  = '0'  and TransDetailId  is null";
            FilterInfo filter = new FilterInfo(fil);
            ev.setFilter(filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                num = iRowSet.getInt("billCount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return num;
    }

    public int getTransDetailMatch(Date endDate1, Date beginDate1) {
        IMetaDataPK iMetaDataPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.be.app.EreceiptDetailBillSumQuery");
        IRowSet iRowSet = null;
        int num = 0;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)iMetaDataPK);
            EntityViewInfo ev = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billCount"));
            ev.setSelector(sic);
            String fil = this.getTransDetailFilter(endDate1, beginDate1).toSql();
            FilterInfo filter = new FilterInfo(fil);
            ev.setFilter(filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                num = iRowSet.getInt("billCount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return num;
    }

    public int getTransDetailUnMatch(Date endDate1, Date beginDate1) {
        IMetaDataPK iMetaDataPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.be.app.EreceiptDetailBillSumQuery");
        IRowSet iRowSet = null;
        int num = 0;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)iMetaDataPK);
            EntityViewInfo ev = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billCount"));
            ev.setSelector(sic);
            String fil = this.getTransDetailFilter(endDate1, beginDate1).toSql();
            fil = fil + "and isMatchEReceipt = '0'";
            FilterInfo filter = new FilterInfo(fil);
            ev.setFilter(filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                num = iRowSet.getInt("billCount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return num;
    }
}

