/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptReprintFactory;
import com.kingdee.eas.fm.be.EReceiptReprintInfo;
import com.kingdee.eas.fm.be.EReceiptWebFacadeFactory;
import com.kingdee.eas.fm.be.IEReceiptWebFacade;
import com.kingdee.eas.fm.be.client.AbstractEReceiptPrintRecordEditUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class EReceiptPrintRecordEditUI
extends AbstractEReceiptPrintRecordEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EReceiptPrintRecordEditUI.class);
    private CompanyOrgUnitInfo curCompany = null;
    EReceiptCollection colInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setNumber(this.txtNumber.getText());
        this.editData.setReasons(this.txtReasons.getText());
        this.editData.setCompany(this.curCompany);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EReceiptReprintFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.kdtEntrys.checkParsed();
        this.colInfo = (EReceiptCollection)((Object)this.getUIContext().get("EReceiptCollection"));
        this.curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        super.onLoad();
        this.kdtEntrys.getStyleAttributes().setLocked(true);
        this.loadObjData(this.colInfo);
    }

    private void loadObjData(EReceiptCollection colInfo) throws Exception {
        if (colInfo != null) {
            this.showTheDetails(this.kdtEntrys, colInfo);
        }
    }

    @Override
    public void loadFields() {
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        super.loadFields();
    }

    protected IObjectValue createNewData() {
        EReceiptReprintInfo info = new EReceiptReprintInfo();
        info.setCompany(this.curCompany);
        return info;
    }

    private void showTheDetails(KDTable table, EReceiptCollection collection) throws Exception {
        table.removeRows();
        if (collection != null && collection.size() > 0) {
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                IRow row = this.kdtEntrys.addRow();
                this.setEReceiptData(collection.get(i), row);
            }
        }
    }

    private void setEReceiptData(EReceiptInfo info, IRow row) {
        row.getCell("ereceiptId").setValue((Object)info.getId());
        row.getCell("transDate").setValue((Object)info.getTransDate());
        row.getCell("companyName").setValue((Object)info.getCompany());
        row.getCell("bankAddress").setValue((Object)info.getBank());
        row.getCell("bankAccountNumber").setValue((Object)info.getBankAccount().getNumber());
        row.getCell("accountNumber").setValue((Object)info.getBankAccount().getBankAccountNumber());
        row.getCell("bankAccountName").setValue((Object)info.getBankAccount().getName());
        row.getCell("currencyName").setValue((Object)info.getCurrency());
        row.getCell("fileName").setValue((Object)info.getFileName());
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        IEReceiptWebFacade eReceiptWebFacade = EReceiptWebFacadeFactory.getRemoteInstance();
        EReceiptReprintInfo eInfo = this.editData;
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtReasons);
        String pk = eReceiptWebFacade.reprintsubmit((IObjectValue)eInfo);
        if (pk != null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.be.FmBeEReceiptRescource", (String)"EReceiptReprint_SubminSuccess"));
            this.initOldData((IObjectValue)this.editData);
            this.getUIWindow().close();
        }
    }
}

