/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.be.EReceiptPrintEnum;
import com.kingdee.eas.fm.be.EReceiptPrintRecordFilterParam;
import com.kingdee.eas.fm.be.client.AbstractEReceiptPrintRecordFilterUI;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class EReceiptPrintRecordFilterUI
extends AbstractEReceiptPrintRecordFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EReceiptPrintRecordFilterUI.class);
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.FmBeEReceiptRescource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.beginDate.setValue((Object)DateUtil.getDayBegin());
        this.endDate.setValue((Object)DateUtil.getDayBegin());
        this.initState();
        this.setCompany();
        this.btnCompanySelect.setVisible(false);
    }

    protected void initState() {
        this.status.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1223_EReceiptPrintRecordFilterUI"));
        this.status.addItem((Object)CheckedStatusEnum.AUDITED);
        this.status.addItem((Object)EReceiptPrintEnum.Printed);
        this.status.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.status.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.company.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                if (null == arrays[i]) continue;
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    public void setCompany() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.company.setValue((Object)currentCompany);
    }

    protected Class getParamClass() {
        return EReceiptPrintRecordFilterParam.class;
    }

    public Object getParam() {
        EReceiptPrintRecordFilterParam param = new EReceiptPrintRecordFilterParam();
        param.setBeginDate(this.beginDate.getSqlDate());
        param.setEndDate(this.endDate.getSqlDate());
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            param.setMainOrgCollIDSet(idSet);
        }
        if (this.status.getSelectedItem() instanceof EReceiptPrintEnum) {
            param.setPStatus((EReceiptPrintEnum)((Object)this.status.getSelectedItem()));
        } else if (this.status.getSelectedItem().equals(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1223_EReceiptPrintRecordFilterUI"))) {
            param.setFStatus(EffectedStatusEnum.EFFECTED);
        } else if (this.status.getSelectedItem() instanceof CheckedStatusEnum) {
            param.setCStatus((CheckedStatusEnum)this.status.getSelectedItem());
        }
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof EReceiptPrintRecordFilterParam)) {
            return;
        }
        EReceiptPrintRecordFilterParam para = (EReceiptPrintRecordFilterParam)param;
        if (!EmptyUtil.isEmpty((Collection)para.getMainOrgCollIDSet())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)para.getMainOrgCollIDSet(), CompareType.INCLUDE));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.company.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.company.setValue(null);
        }
        this.beginDate.setValue((Object)para.getBeginDate());
        this.endDate.setValue((Object)para.getEndDate());
        if (para.getFStatus() != null) {
            this.status.setSelectedItem((Object)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1223_EReceiptPrintRecordFilterUI"));
        }
        if (para.getCStatus() != null) {
            this.status.setSelectedItem((Object)para.getCStatus());
        }
        if (para.getPStatus() != null) {
            this.status.setSelectedItem((Object)para.getPStatus());
        }
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.beginDate.setValue((Object)DateUtil.getDayBegin());
        this.endDate.setValue((Object)DateUtil.getDayBegin());
        this.status.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.setCompany();
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public String getPermissionItem() {
        return "fm_be_eReceiptReprint_01View";
    }

    public KDBizPromptBox getMainOrg() {
        return this.company;
    }

    public boolean verify() {
        if (this.beginDate.getSqlDate() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBeginDate"));
            SysUtil.abort();
        }
        if (this.endDate.getSqlDate() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckEndDate"));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)this.endDate.getSqlDate()).before(DateTimeUtils.truncateDate((Date)this.beginDate.getSqlDate()))) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"ChecBeginAndEndkDate"));
            SysUtil.abort();
        }
        if (this.company.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckCompany"));
            SysUtil.abort();
        }
        return super.verify();
    }
}

