/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.be.ElStatementBillFactory;
import com.kingdee.eas.fm.be.ElStatementBillInfo;
import com.kingdee.eas.fm.be.client.AbstractElStatementBillEditUI;
import com.kingdee.eas.fm.be.client.ElStatementClientHelper;
import com.kingdee.eas.fm.common.client.FMKDTableHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ElStatementBillEditUI
extends AbstractElStatementBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ElStatementBillEditUI.class);

    protected ICoreBase getBizInterface() throws Exception {
        return ElStatementBillFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1177_ElStatementBillEditUI"));
        super.onLoad();
        this.initElStatementEntryTable();
        this.setElStatementEntrySum();
    }

    @Override
    public void loadFields() {
        this.kdtEntry.checkParsed();
        super.loadFields();
        SimpleDateFormat FORMAT_SHORT = new SimpleDateFormat(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1178_ElStatementBillEditUI"));
        this.txtTransDate.setText(FORMAT_SHORT.format(this.editData.getTransDate()));
        int n = this.kdtEntry.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntry.getRow(i);
            String numberFtm = "%r-[ ]{###,###,##0.00}15.2n";
            row.getCell("debitAmount").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("creditAmount").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("acctBalance").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("acctBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        ElStatementBillInfo info = (ElStatementBillInfo)dataObject;
        if (info.getCreditAmount() == null) {
            info.setCreditAmount(BigDecimal.ZERO);
        }
        if (info.getDebitAmount() == null) {
            info.setDebitAmount(BigDecimal.ZERO);
        }
        if (info.getEndBalance() == null) {
            info.setEndBalance(BigDecimal.ZERO);
        }
        if (info.getEndRetainedAmt() == null) {
            info.setEndRetainedAmt(BigDecimal.ZERO);
        }
        if (info.getEndFrezonAmt() == null) {
            info.setEndFrezonAmt(BigDecimal.ZERO);
        }
        if (info.getEndAvailableAmt() == null) {
            info.setEndAvailableAmt(BigDecimal.ZERO);
        }
        if (info.getEndOverdraftAmt() == null) {
            info.setEndOverdraftAmt(BigDecimal.ZERO);
        }
    }

    public void initDataStatus() {
        super.initDataStatus();
        this.prmtCompany.setEnabled(false);
        this.prmtBank.setEnabled(false);
        this.txtTransDate.setEnabled(false);
        this.prmtBankAccount.setEnabled(false);
        this.txtBankAcctName.setEnabled(false);
        this.prmtCurrency.setEnabled(false);
        this.fmtDebitAmount.setEnabled(false);
        this.fmtCreditAmount.setEnabled(false);
        this.txtPrintCount.setEnabled(false);
        this.txtDebitCounts.setEnabled(false);
        this.txtCreditCounts.setEnabled(false);
        this.pkPrintDate.setEnabled(false);
        this.prmtBankAccount.setDisplayFormat("$bankAccountNumber$");
        this.fmtEndBalance.setEnabled(false);
        this.fmtEndRetainedAmt.setEnabled(false);
        this.fmtEndFrezonAmt.setEnabled(false);
        this.fmtEndOverdraftAmt.setEnabled(false);
        this.fmtEndAvailableAmt.setEnabled(false);
        this.kdtEntry.setEnabled(false);
        int precision = 2;
        this.fmtDebitAmount.setHorizontalAlignment(4);
        this.fmtCreditAmount.setHorizontalAlignment(2);
        this.txtPrintCount.setHorizontalAlignment(4);
        this.txtDebitCounts.setHorizontalAlignment(4);
        this.txtCreditCounts.setHorizontalAlignment(4);
        this.fmtEndBalance.setHorizontalAlignment(4);
        this.fmtEndRetainedAmt.setHorizontalAlignment(4);
        this.fmtEndFrezonAmt.setHorizontalAlignment(4);
        this.fmtEndOverdraftAmt.setHorizontalAlignment(4);
        this.fmtEndAvailableAmt.setHorizontalAlignment(4);
        this.fmtDebitAmount.setPrecision(precision);
        this.fmtCreditAmount.setPrecision(precision);
        this.fmtEndBalance.setPrecision(precision);
        this.fmtEndRetainedAmt.setPrecision(precision);
        this.fmtEndFrezonAmt.setPrecision(precision);
        this.fmtEndOverdraftAmt.setPrecision(precision);
        this.fmtEndAvailableAmt.setPrecision(precision);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewElState.setEnabled(true);
        this.actionPrintElState.setEnabled(true);
        this.actionPrintElState.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionViewElState.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        ElStatementBillInfo info = null;
        try {
            info = (ElStatementBillInfo)super.createNewData();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return info;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnAuditResult.setVisible(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("transDate"));
        return sic;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String msg = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1179_ElStatementBillEditUI");
        if (MsgBox.showConfirm2((Component)((Object)this), (String)msg) == 2) {
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionViewElState_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        ElStatementClientHelper.viewElStatementByIdList(idList, (Component)((Object)this));
    }

    @Override
    public void actionPrintElState_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        ElStatementClientHelper.printElStatementByIdList(idList, (Component)((Object)this));
    }

    private void setElStatementEntrySum() {
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdtEntry.getColumn("debitAmount"), (int)2);
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdtEntry.getColumn("creditAmount"), (int)2);
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdtEntry.getColumn("acctBalance"), (int)2);
        this.appendFootRow(this.kdtEntry);
        KDTFootManager footManager = this.kdtEntry.getFootManager();
        if (footManager != null && footManager.getFootRow(0) != null) {
            FMKDTableHelper.initDecimalCell((ICell)footManager.getFootRow(0).getCell("debitAmount"), (int)2);
            FMKDTableHelper.initDecimalCell((ICell)footManager.getFootRow(0).getCell("creditAmount"), (int)2);
            FMKDTableHelper.initDecimalCell((ICell)footManager.getFootRow(0).getCell("acctBalance"), (int)2);
        }
    }

    private void initElStatementEntryTable() {
        this.setTableToSumField(this.kdtEntry, new String[]{"debitAmount@##,###,###,###,###,##0.00", "creditAmount@##,###,###,###,###,##0.00", "acctBalance@##,###,###,###,###,##0.00"});
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdtEntry.getColumn("debitAmount"), (int)2);
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdtEntry.getColumn("creditAmount"), (int)2);
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdtEntry.getColumn("acctBalance"), (int)2);
    }
}

