/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.client.f7.F7ContextInitializationHelper;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.ElStatementBillFactory;
import com.kingdee.eas.fm.be.ElStatementBillInfo;
import com.kingdee.eas.fm.be.client.AbstractElStatementBillImportUI;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElStatementBillImportUI
extends AbstractElStatementBillImportUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ElStatementBillImportUI.class);
    private static boolean isSuccess = false;
    private ElStatementBillInfo elStatementBillInfo = new ElStatementBillInfo();
    public CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private Date transDate = new Date();
    private Calendar cal = Calendar.getInstance();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        NewCompanyF7 selector = F7ContextInitializationHelper.getSelectCompany((IUIObject)this, null, null, (boolean)false);
        this.prmtCompany.setSelector((KDPromptSelector)selector);
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.prmtCompany.setRequired(true);
        this.prmtBankAccount.setRequired(true);
        this.initAccountBankEvi();
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spnYear, (KDSpinner)new KDSpinner(), (KDSpinner)this.spnMonth, (KDSpinner)new KDSpinner());
        FMClientHelper.initSpinFromTO((KDSpinner)this.spnYear, (KDSpinner)this.spnMonth, (KDSpinner)new KDSpinner(), (KDSpinner)new KDSpinner());
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtBankAccount.setData(null);
        this.initAccountBankEvi();
    }

    @Override
    protected void prmtBankAccount_willShow(SelectorEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    private void initAccountBankEvi() {
        String companyId;
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        if (this.prmtCompany.getData() != null && !EmptyUtil.isEmpty((String)(companyId = ((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()))) {
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", (Object)companyId, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.prmtBankAccount.setSelectorCollection(selectors);
        this.prmtBankAccount.setEntityViewInfo(evi);
        this.prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
        this.prmtBankAccount.setEnabledMultiSelection(false);
    }

    @Override
    protected void prmtBankAccount_dataChanged(DataChangeEvent e) throws Exception {
        if (EmptyUtil.isEmpty((Object)this.prmtCompany.getData()) && !EmptyUtil.isEmpty((Object)this.prmtBankAccount.getData())) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(((AccountBankInfo)this.prmtBankAccount.getData()).getCompany().getId()));
            this.prmtCompany.setDataNoNotify((Object)company);
        }
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        String filePath = this.getFilePath();
        this.setFile(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFilePath() throws IOException {
        String filePath = null;
        KDFileChooser choose = new KDFileChooser();
        boolean isFileValid = false;
        boolean fileSupport = false;
        while (!isFileValid) {
            int rVal = choose.showOpenDialog((Component)((Object)this));
            if (rVal == 0) {
                filePath = choose.getSelectedFile().getPath();
                String fileExtension = null;
                if (filePath != null) {
                    String filename = filePath;
                    int i = filename.lastIndexOf(46);
                    int j = filename.lastIndexOf(File.separator);
                    if (i > 0 && i < filename.length() - 1 && j < i) {
                        fileExtension = filePath.substring(i + 1).toLowerCase();
                    }
                }
                if (fileExtension == null) {
                    fileSupport = false;
                }
                if ("pdf".equalsIgnoreCase(fileExtension)) {
                    fileSupport = true;
                }
                if ("ofd".equalsIgnoreCase(fileExtension)) {
                    fileSupport = true;
                }
                if (!fileSupport) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1180_ElStatementBillImportUI"));
                    isFileValid = false;
                    filePath = "";
                    continue;
                }
                isFileValid = true;
                FileInputStream fis = new FileInputStream(filePath);
                try {
                    byte[] buffer = new byte[8];
                    int bytesRead = ((InputStream)fis).read(buffer);
                    StringBuilder header = new StringBuilder();
                    for (int j = 0; j < bytesRead; ++j) {
                        header.append(String.format("%02X", buffer[j]));
                    }
                    System.out.println("File Header: " + header);
                    if (header != null && header.indexOf("504B030414000000") <= -1 && header.indexOf("FFD8FF") <= -1 && header.indexOf("255044462D312E") <= -1) {
                        filePath = "";
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.erec.ERECAutoGenerateResource", (String)"1_ImportEReceipt"));
                        SysUtil.abort();
                        break;
                    }
                    byte[] bty = this.toByteArray(fis);
                    if (bty == null || bty.length <= 0xA00000) continue;
                    filePath = "";
                    MsgBox.showInfo((String)"\u60a8\u63d0\u4ea4\u7684\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u4e8610M\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
                    SysUtil.abort();
                    break;
                }
                catch (Exception e) {
                    filePath = "";
                    MsgBox.showInfo((String)"\u60a8\u63d0\u4ea4\u7684\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u4e8610M\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
                    SysUtil.abort();
                    continue;
                }
                catch (Error e1) {
                    filePath = "";
                    MsgBox.showInfo((String)"\u60a8\u63d0\u4ea4\u7684\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u4e8610M\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
                    SysUtil.abort();
                    continue;
                }
                finally {
                    if (fis != null) {
                        try {
                            ((InputStream)fis).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    fis = null;
                    continue;
                }
            }
            isFileValid = true;
            filePath = "";
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(String filePath) {
        InputStream fis = null;
        try {
            this.elStatementBillInfo.setFileValue(null);
            this.elStatementBillInfo.setFileName(null);
            logger.error((Object)("import file's filePath:" + filePath));
            fis = new FileInputStream(filePath);
            byte[] bty = this.toByteArray(fis);
            int i = filePath.lastIndexOf(File.separator);
            String filename = filePath.substring(i + 1).toLowerCase();
            logger.error((Object)("import file's size:" + bty.length));
            this.elStatementBillInfo.setFileValue(bty);
            this.elStatementBillInfo.setFileName(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            fis = null;
        }
    }

    private byte[] toByteArray(InputStream fis) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = fis.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        GregorianCalendar begincal = new GregorianCalendar(AccessHelper.getSpiValue((KDSpinner)this.spnYear), AccessHelper.getSpiValue((KDSpinner)this.spnMonth) - 1, 1);
        this.transDate = begincal.getTime();
        this.verify();
        this.elStatementBillInfo.setCompany((CompanyOrgUnitInfo)this.prmtCompany.getData());
        this.elStatementBillInfo.setBankAccount((AccountBankInfo)this.prmtBankAccount.getData());
        this.elStatementBillInfo.setTransDate(this.transDate);
        this.elStatementBillInfo.setBankAcctName(((AccountBankInfo)this.prmtBankAccount.getData()).getName());
        this.elStatementBillInfo.setCurrency(((AccountBankInfo)this.prmtBankAccount.getData()).getCurrency());
        this.elStatementBillInfo.setBank(((AccountBankInfo)this.prmtBankAccount.getData()).getBank());
        isSuccess = ElStatementBillFactory.getRemoteInstance().importElStatementBill(this.elStatementBillInfo);
        this.disposeUIWindow();
    }

    public void verify() throws Exception {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        if (this.prmtCompany.getValue() != null) {
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString()), "elstatement_06import");
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBankAccount);
        if (EmptyUtil.isEmpty((Object)this.elStatementBillInfo.getFileValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1181_ElStatementBillImportUI"));
            SysUtil.abort();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        isSuccess = false;
        super.disposeUIWindow();
    }

    public static boolean showPreInterestLoanUI(CoreUI ui) {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ElStatementBillImportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return isSuccess;
    }
}

