/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.ElStatementBillFactory;
import com.kingdee.eas.fm.be.ElStatementFilterParam;
import com.kingdee.eas.fm.be.client.AbstractElStatementBillInterruptUI;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMBillBaseListUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElStatementBillInterruptUI
extends AbstractElStatementBillInterruptUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ElStatementBillInterruptUI.class);
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.FmBeEReceiptRescource";
    Map result = new HashMap();
    private Date startDate = new Date();
    private Date endDate = new Date();
    public CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private static Map bankInterMap = new HashMap();
    static String type = "1";
    public static String[] orgCollIDStr;

    public void onLoad() throws Exception {
        if (type.equals("1")) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1182_ElStatementBillInterruptUI"));
        } else if (type.equals("2")) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1183_ElStatementBillInterruptUI"));
        }
        super.onLoad();
        this.prmtCompany.setRequired(true);
        this.prmtAccountBank.setRequired(true);
        this.init();
        this.setPoridDate();
    }

    private void init() throws Exception {
        this.setCompanyValue();
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        HashSet<String> companySet = new HashSet<String>();
        for (int i = 0; i < orgCollIDStr.length; ++i) {
            boolean isPass = iPermission.hasFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(orgCollIDStr[i]), "elstatement_05down");
            if (!isPass) continue;
            companySet.add(orgCollIDStr[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", companySet, CompareType.INCLUDE));
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        this.prmtCompany.setValue((Object)coll.toArray());
        this.initBankInterface();
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spnStartYear, (KDSpinner)this.spnEndYear, (KDSpinner)this.spnStartMonth, (KDSpinner)this.spnEndMonth);
        FMClientHelper.initSpinFromTO((KDSpinner)this.spnStartYear, (KDSpinner)this.spnStartMonth, (KDSpinner)this.spnEndYear, (KDSpinner)this.spnEndMonth);
    }

    protected void setCompanyValue() {
        NewOrgUnitFilterInfoProducer iProducer = null;
        String permissionItem = "elstatement_05down";
        iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company);
        if (iProducer != null) {
            if (permissionItem != null) {
                iProducer.getModel().setPermissionItem(permissionItem);
            }
            this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
            if (iProducer.getModel() != null) {
                this.prmtCompany.setSelector((KDPromptSelector)iProducer.getModel());
                this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
                iProducer.getModel().setMultiSelect(true);
            }
        }
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.comboBankInterface.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setSelector(this.getSelectors());
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (!FMClientHelper.isNotExistsMulBeService()) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
        }
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int k = 0;
        bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.comboBankInterface.addItem((Object)bankAcct);
            bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.comboBankInterface.addItem((Object)bankAcct);
            bankInterMap.put(null, new Integer(bankInterMap.size() + 1));
        }
    }

    private void setPoridDate() {
        GregorianCalendar begincal = new GregorianCalendar(AccessHelper.getSpiValue((KDSpinner)this.spnStartYear), AccessHelper.getSpiValue((KDSpinner)this.spnStartMonth) - 1, 1);
        this.startDate = begincal.getTime();
        GregorianCalendar endcal = new GregorianCalendar(AccessHelper.getSpiValue((KDSpinner)this.spnEndYear), AccessHelper.getSpiValue((KDSpinner)this.spnEndMonth), 0);
        this.endDate = endcal.getTime();
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.setPoridDate();
        this.verify();
        HashSet<String> bankAcctIds = new HashSet<String>();
        if (this.prmtAccountBank.getValue() != null) {
            Object[] accountArry = this.prmtAccountBank.getData() instanceof Object[] ? (Object[])this.prmtAccountBank.getData() : new Object[]{this.prmtAccountBank.getData()};
            BOSUuid[] accountBank = new BOSUuid[accountArry.length];
            String[] bankNumber = new String[accountArry.length];
            for (int index = 0; index < accountArry.length; ++index) {
                bankAcctIds.add(((AccountBankInfo)accountArry[index]).getId().toString());
            }
        }
        if (EmptyUtil.isEmpty((String)type)) {
            this.result = ElStatementBillFactory.getRemoteInstance().downloadStructFormatByManual(bankAcctIds, this.startDate, this.endDate);
        } else if (type.equals("1")) {
            this.result = ElStatementBillFactory.getRemoteInstance().downloadStructFormatByManual(bankAcctIds, this.startDate, this.endDate);
        } else if (type.equals("2")) {
            this.result = ElStatementBillFactory.getRemoteInstance().downloadFileByManual(bankAcctIds, this.startDate, this.endDate);
        }
        this.disposeUIWindow();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.disposeUIWindow();
    }

    public static Map showPreInterestLoanUI(CoreUI ui, String flag) {
        Map returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            FMBillBaseListUI fmui = (FMBillBaseListUI)ui;
            ElStatementFilterParam param = (ElStatementFilterParam)fmui.getFilterParam();
            orgCollIDStr = param.getCompanyId();
            type = flag;
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ElStatementBillInterruptUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((ElStatementBillInterruptUI)uiWindow.getUIObject()).getReturnValueWithMsg();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }

    private Map getReturnValueWithMsg() {
        return this.result;
    }

    public void verify() throws Exception {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckCompany"));
            SysUtil.abort();
        }
        if (this.prmtAccountBank.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1166_BankDynamicNoticeFilterUI"));
            SysUtil.abort();
        }
        Date endDateMothOfFirstDay = DateUtil.getFirstDayOfMonth((Date)this.endDate);
        Date curMonthOfFirstDay = DateUtil.getFirstDayOfCurMonth();
        if (!curMonthOfFirstDay.after(endDateMothOfFirstDay)) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"NotDownFromElStateFuture"));
            SysUtil.abort();
        }
        Date startDateMothOfFirstDay = DateUtil.getFirstDayOfMonth((Date)this.startDate);
        if (DateTimeUtils.truncateDate((Date)endDateMothOfFirstDay).before(DateTimeUtils.truncateDate((Date)startDateMothOfFirstDay))) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"ChecBeginAndEndkDate"));
            SysUtil.abort();
        }
        BigDecimal term = Constants.ZERO;
        BigDecimal time = BigDecimal.valueOf(366L);
        term = new BigDecimal(DateUtil.getDiffDays((Date)this.startDate, (Date)this.endDate));
        if (term.compareTo(time) == 1) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"NotElStatePeriodOver"));
            SysUtil.abort();
        }
    }

    @Override
    protected void comboBankInterface_actionPerformed(ActionEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    private void reSetF7BankAccountQuery() {
        BankInterface bankFace;
        this.prmtAccountBank.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        if (this.prmtCompany.getData() != null) {
            Object[] companys = this.prmtCompany.getData() instanceof Object[] ? (Object[])this.prmtCompany.getData() : new Object[]{this.prmtCompany.getData()};
            HashSet<String> companyIds = new HashSet<String>();
            for (Object o : companys) {
                if (EmptyUtil.isEmpty((Object)o)) continue;
                companyIds.add(((CompanyOrgUnitInfo)o).getId().toString());
            }
            if (companyIds.size() > 0) {
                companyFilter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
                agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", companyIds, CompareType.INCLUDE));
            }
        }
        if (this.comboBankInterface.getSelectedItem() instanceof BankInterface && !EmptyUtil.isEmpty((String)(bankFace = (BankInterface)this.comboBankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankFace.getNumber()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.prmtAccountBank.setSelectorCollection(selectors);
        this.prmtAccountBank.setEntityViewInfo(evi);
        this.prmtAccountBank.getQueryAgent().resetRuntimeEntityView();
        this.prmtAccountBank.setEnabledMultiSelection(true);
    }
}

