/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.fm.be.ElStatementBillFactory;
import com.kingdee.eas.fm.be.ElStatementFilterParam;
import com.kingdee.eas.fm.be.client.AbstractElStatementBillListUI;
import com.kingdee.eas.fm.be.client.ElStatementBillEditUI;
import com.kingdee.eas.fm.be.client.ElStatementBillFilterUI;
import com.kingdee.eas.fm.be.client.ElStatementBillImportUI;
import com.kingdee.eas.fm.be.client.ElStatementBillInterruptUI;
import com.kingdee.eas.fm.be.client.ElStatementClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.service.FMActionProxy;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.ITableSelectionHelper;
import com.kingdee.eas.framework.batchaction.service.BatchActionManager;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElStatementBillListUI
extends AbstractElStatementBillListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ElStatementBillListUI.class);
    FMFilterBaseUI filterUI = null;
    private Map result = null;

    protected String getEditUIName() {
        return ElStatementBillEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1177_ElStatementBillListUI"));
        super.onLoad();
        this.tblMain.checkParsed();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnPrintPreview.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
    }

    protected void execQuery() {
        try {
            super.execQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblMain.getRow(i);
            String numberFtm = "%r-[ ]{###,###,##0.00}15.2n";
            row.getCell("debitAmount").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("creditAmount").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("endBalance").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("endRetainedAmt").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("endFrezonAmt").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("endOverdraftAmt").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("endAvailableAmt").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("endBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("endRetainedAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("endFrezonAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("endOverdraftAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("endAvailableAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionDownloadStructFormat.setEnabled(true);
        this.actionDownloadFile.setEnabled(true);
        this.actionImport.setEnabled(true);
        this.actionViewElState.setEnabled(true);
        this.actionPrintElState.setEnabled(true);
        this.actionPrintElState.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionViewElState.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionImport.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        this.actionDownloadStructFormat.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_downbill"));
        this.actionDownloadFile.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_downbill"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ElStatementBillFilterUI();
        }
        return this.filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ElStatementBillFactory.getRemoteInstance();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BatchActionManager actionManager = new BatchActionManager((CoreUIObject)this, ContextTypeEnum.INQUERYING);
        actionManager.setTableSelectionHelper((ITableSelectionHelper)this.getTableSelectionHelper());
        actionManager.setServiceContext(this.getServiceContext());
        actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, ElStatementBillFactory.class);
        FMActionProxy actionProxy = new FMActionProxy((ItemAction)this.actionRemove, "delete", BatchActionEnum.DELETE, actionManager);
        actionProxy.actionPerformed(e);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, ElStatementBillFactory.class);
        this.getTableSelectionHelper().setTableProperty((ListUI)this, this.mainQueryPK, this.tblMain, "id", null, "fileName", null, "company.id");
        Object actionProxy = null;
    }

    @Override
    public void actionDownloadStructFormat_actionPerformed(ActionEvent e) throws Exception {
        this.downLoadElStatementBill("1");
        this.refreshList();
    }

    @Override
    public void actionDownloadFile_actionPerformed(ActionEvent e) throws Exception {
        this.downLoadElStatementBill("2");
        this.refreshList();
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        boolean isSuccess = ElStatementBillImportUI.showPreInterestLoanUI((CoreUI)this);
        if (isSuccess) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1184_ElStatementBillListUI"));
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1185_ElStatementBillListUI"));
            this.refreshList();
        }
    }

    @Override
    public void actionViewElState_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ElStatementClientHelper.viewElStatementByIdList(this.getSelectedIdValues(), (Component)((Object)this));
    }

    @Override
    public void actionPrintElState_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ElStatementClientHelper.printElStatementByIdList(this.getSelectedIdValues(), (Component)((Object)this));
    }

    protected void downLoadElStatementBill(String type) throws Exception {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        ElStatementFilterParam param = (ElStatementFilterParam)this.getFilterParam();
        boolean isPass = false;
        if (!EmptyUtil.isEmpty((Object[])param.getCompanyId())) {
            String[] companyIdStr = param.getCompanyId();
            for (int i = 0; i < companyIdStr.length && !(isPass = iPermission.hasFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(companyIdStr[i]), "elstatement_05down")); ++i) {
            }
        }
        if (!isPass) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1186_ElStatementBillListUI"));
            SysUtil.abort();
        }
        this.result = ElStatementBillInterruptUI.showPreInterestLoanUI((CoreUI)this, type);
        if (this.result.get("count") != null && type.equals("1")) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1187_ElStatementBillListUI") + this.result.get("count") + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1003_LetterOfCreditEBGServiceUtil")));
        } else if (this.result.get("count") != null && type.equals("2")) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1188_ElStatementBillListUI") + this.result.get("count") + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1003_LetterOfCreditEBGServiceUtil")));
        }
    }
}

