/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.ElStatementServiceHelper;
import com.kingdee.eas.fm.erec.SortItem;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ElStatementViewDataProvider
extends DefaultNoteDataProvider
implements IPrintActionListener {
    private List<String> idList;

    public ElStatementViewDataProvider(List idList) {
        this.idList = idList;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        if (dataSource.getId().equals("ElStatementViewDataProvider")) {
            return this.getElStatementData(dataSource);
        }
        return super.getData(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRowSet getElStatementData(R1PrintDataSource dataSource) throws BOSException, EASBizException, SQLException {
        int j;
        HashMap<String, SortItem[]> sortIemMap = new HashMap<String, SortItem[]>();
        R1PrintDataSortItem[] dataSourceSortIems = dataSource.getSortFields();
        SortItem[] sortItems = new SortItem[dataSourceSortIems.length];
        for (int i = 0; i < dataSourceSortIems.length; ++i) {
            SortItem sortItem = new SortItem();
            String sortFiled = dataSourceSortIems[i].getSortField();
            if (!"id".equals(sortFiled) && !"bizDate".equals(sortFiled) && !"transDate".equals(sortFiled) && !"amount".equals(sortFiled) && !"explanation".equals(sortFiled) && !"bizType".equals(sortFiled) && !"billNumber".equals(sortFiled) && !"company.name".equals(sortFiled) && !"currency.name".equals(sortFiled) && !"bankAccount.bankAccountNumber".equals(sortFiled)) continue;
            sortItem.setFiled(dataSourceSortIems[i].getSortField());
            if (0 == dataSourceSortIems[i].getSortType()) {
                sortItem.setSortType(SortType.ASCEND);
            } else {
                sortItem.setSortType(SortType.DESCEND);
            }
            sortItems[i] = sortItem;
        }
        sortIemMap.put("sortItems", sortItems);
        List<byte[]> pdfList = ElStatementServiceHelper.getSortedFilesByElStateIdList(null, this.idList, sortIemMap, true);
        ArrayList<byte[]> toPdfList = new ArrayList<byte[]>();
        File file = null;
        try {
            for (int i = 0; i < pdfList.size(); ++i) {
                PdfReader pdfReader = new PdfReader(pdfList.get(i));
                if (pdfReader.getNumberOfPages() > 1) {
                } else {
                    toPdfList.add(pdfList.get(i));
                    continue;
                }
                for (j = 1; j <= pdfReader.getNumberOfPages(); ++j) {
                    Document document = new Document();
                    PdfCopy pdfCopy = null;
                    String path = "ereciptpdfa" + j + ".pdf";
                    FileOutputStream fileOoutputStream = new FileOutputStream(path);
                    try {
                        pdfCopy = new PdfCopy(document, (OutputStream)fileOoutputStream);
                        document.open();
                        document.newPage();
                        PdfImportedPage page = pdfCopy.getImportedPage(pdfReader, j);
                        pdfCopy.addPage(page);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (document != null) {
                            document.close();
                        }
                        if (pdfCopy != null) {
                            pdfCopy.close();
                        }
                        if (fileOoutputStream != null) {
                            fileOoutputStream.close();
                        }
                    }
                    ByteArrayOutputStream bos = null;
                    FileInputStream in = null;
                    try {
                        bos = new ByteArrayOutputStream();
                        file = new File(path);
                        in = new FileInputStream(file);
                        bos = new ByteArrayOutputStream(1024);
                        byte[] buffer = new byte[1024];
                        int len = 0;
                        while (-1 != (len = in.read(buffer))) {
                            bos.write(buffer, 0, len);
                        }
                        toPdfList.add(bos.toByteArray());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    finally {
                        if (bos != null) {
                            bos.close();
                        }
                        if (file != null) {
                            file.delete();
                        }
                        if (fileOoutputStream != null) {
                            fileOoutputStream.close();
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        in = null;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String ATTACTMENT_FIELD = "id";
        DynamicRowSet drs = new DynamicRowSet(1);
        for (int i = 0; i < 1; ++i) {
            ColInfo ci = new ColInfo();
            ci.colType = -2;
            ci.columnName = "id";
            ci.nullable = 1;
            drs.setColInfo(i + 1, ci);
        }
        drs.beforeFirst();
        j = 0;
        while (true) {
            if (j >= toPdfList.size()) {
                drs.beforeFirst();
                return drs;
            }
            drs.moveToInsertRow();
            drs.updateBytes(ATTACTMENT_FIELD, (byte[])toPdfList.get(j));
            drs.insertRow();
            ++j;
        }
    }

    public void beforePrintOrPreview() {
    }

    public void beforePreview() {
    }

    public void beforePrint() {
    }

    public void closePreview() {
    }
}

