/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.client.AbstractFixedMutualFilterUI;
import com.kingdee.eas.fm.be.client.BEClientHelper;
import com.kingdee.eas.fm.be.client.FixedMutualFilterParam;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FixedMutualFilterUI
extends AbstractFixedMutualFilterUI {
    private CompanyOrgUnitInfo company = null;
    private static final int ALL_STATUS = 100;
    private static final int OTHER_STATUS = 99;
    private static final Logger logger = CoreUIObject.getLogger(FixedMutualFilterUI.class);
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";

    public Object getParam() {
        FixedMutualFilterParam para = new FixedMutualFilterParam();
        if (this.cboCurrency.getSelectedItem() == null || !this.cboCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cboCurrency));
        }
        para.setBankAcctId(AccessHelper.getF7Ids((KDBizPromptBox)this.f7BankAccount));
        para.setBeginDate(this.dtpBegin.getSqlDate());
        para.setEndDate(this.dtpEndo.getSqlDate());
        String[] status = new String[this.countNum()];
        int i = 0;
        if (this.rdbPrepSubmit.isSelected()) {
            status[i] = String.valueOf(1);
            ++i;
        }
        if (this.rdbSubmitFail.isSelected()) {
            status[i] = String.valueOf(3);
            ++i;
        }
        if (this.rdbSubmitSuccess.isSelected()) {
            status[i] = String.valueOf(2);
            ++i;
        }
        if (this.rdbSucceed.isSelected()) {
            status[i] = String.valueOf(6);
            ++i;
        }
        if (this.rdbFailure.isSelected()) {
            status[i] = String.valueOf(5);
            ++i;
        }
        if (this.rdbOther.isSelected()) {
            status[i] = String.valueOf(4);
            ++i;
        }
        if (!(this.rdbPrepSubmit.isSelected() || this.rdbSubmitFail.isSelected() || this.rdbSubmitSuccess.isSelected() || this.rdbSucceed.isSelected() || this.rdbFailure.isSelected() || this.rdbOther.isSelected())) {
            status[i] = String.valueOf(1);
            status[++i] = String.valueOf(3);
            status[++i] = String.valueOf(2);
            status[++i] = String.valueOf(6);
            status[++i] = String.valueOf(5);
            status[++i] = String.valueOf(4);
        }
        para.setStatusIds(status);
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIds(companyIds);
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof FixedMutualFilterParam)) {
            return;
        }
        FixedMutualFilterParam para = (FixedMutualFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currencyInfo);
            } else {
                this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.dtpBegin.setValue((Object)para.getBeginDate());
        this.dtpEndo.setValue((Object)para.getEndDate());
        if (para.getStatusIds() == null) {
            this.rdbPrepSubmit.setSelected(true);
            this.rdbSubmitFail.setSelected(true);
            this.rdbSubmitSuccess.setSelected(true);
            this.rdbSucceed.setSelected(true);
            this.rdbFailure.setSelected(true);
            this.rdbOther.setSelected(true);
            this.rdbAll.setSelected(true);
        } else {
            int len = para.getStatusIds().length;
            for (int i = 0; i < len - 1; ++i) {
                if (String.valueOf(2).equals(para.getStatusIds()[i])) {
                    this.rdbSubmitSuccess.setSelected(true);
                    continue;
                }
                if (String.valueOf(3).equals(para.getStatusIds()[i])) {
                    this.rdbSubmitFail.setSelected(true);
                    continue;
                }
                if (String.valueOf(1).equals(para.getStatusIds()[i])) {
                    this.rdbPrepSubmit.setSelected(true);
                    continue;
                }
                if (String.valueOf(6).equals(para.getStatusIds()[i])) {
                    this.rdbSucceed.setSelected(true);
                    continue;
                }
                if (String.valueOf(5).equals(para.getStatusIds()[i])) {
                    this.rdbFailure.setSelected(true);
                    continue;
                }
                if (!String.valueOf(4).equals(para.getStatusIds()[i])) continue;
                this.rdbOther.setSelected(true);
            }
        }
        boolean val = ContextHelperFactory.getRemoteInstance().getBooleanParam("BE003", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        String[] companyIds = para.getCompanyIds();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        if (!val && !GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            try {
                if (para.getBankAcctId() != null) {
                    AccountBankCollection coll = null;
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                    ev.setFilter(filter);
                    IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                    coll = bankAcct.getAccountBankCollection(ev);
                    this.f7BankAccount.setData((Object)coll.toArray());
                }
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        } else {
            try {
                if (para.getBankAcctId() != null) {
                    Set set = FMHelper.asSet((String[])para.getBankAcctId());
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                    ev.setFilter(filter);
                    AccountBankCollection coll = null;
                    IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                    coll = bankAcct.getAccountBankCollection(ev);
                    this.f7BankAccount.setData((Object)coll.toArray());
                }
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        }
    }

    protected void init() throws Exception {
        if (this.company == null) {
            this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        super.init();
        this.initF7BankAccount();
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initF7BankAccount() {
        this.f7BankAccount.setData(null);
        boolean val = ContextHelperFactory.getRemoteInstance().getBooleanParam("BE003", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        FilterInfo filterInfo = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!FMHelper.isEmpty((Object[])companyId) && (val || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany))) {
            HashSet<Object> list = new HashSet<Object>(companyId.length);
            for (int i = 0; i < companyId.length; ++i) {
                list.add(companyId[i]);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setDisplayFormat("$number$ $name$");
        this.f7BankAccount.setCommitFormat("$number$");
        this.f7BankAccount.setEditFormat("$number$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.f7BankAccount.setEntityViewInfo(evi);
    }

    public boolean verify() {
        return BEClientHelper.verifyDate((Component)((Object)this), this.dtpBegin, this.dtpEndo);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
        this.initF7BankAccount();
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"NoCompany"));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.company.getBaseCurrency());
        this.f7BankAccount.setData(null);
        Date date = new Date();
        this.dtpBegin.setValue((Object)date);
        this.dtpEndo.setValue((Object)date);
        this.rdbPrepSubmit.setSelected(false);
        this.rdbSubmitSuccess.setSelected(false);
        this.rdbSubmitFail.setSelected(false);
        this.rdbSucceed.setSelected(false);
        this.rdbFailure.setSelected(false);
        this.rdbOther.setSelected(false);
        this.rdbAll.setSelected(true);
    }

    @Override
    protected void rdbPrepSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.resetRbdAllSelected();
    }

    @Override
    protected void rdbSubmitSuccess_actionPerformed(ActionEvent e) throws Exception {
        this.resetRbdAllSelected();
    }

    @Override
    protected void rdbSubmitFail_actionPerformed(ActionEvent e) throws Exception {
        this.resetRbdAllSelected();
    }

    @Override
    protected void rdbAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.rdbAll.isSelected()) {
            this.rdbPrepSubmit.setSelected(true);
            this.rdbSubmitSuccess.setSelected(true);
            this.rdbSubmitFail.setSelected(true);
            this.rdbSucceed.setSelected(true);
            this.rdbFailure.setSelected(true);
            this.rdbOther.setSelected(true);
        } else {
            this.rdbPrepSubmit.setSelected(false);
            this.rdbSubmitSuccess.setSelected(false);
            this.rdbSubmitFail.setSelected(false);
            this.rdbSucceed.setSelected(false);
            this.rdbFailure.setSelected(false);
            this.rdbOther.setSelected(false);
        }
    }

    private void resetRbdAllSelected() {
        if (this.rdbPrepSubmit.isSelected() && this.rdbSubmitSuccess.isSelected() && this.rdbSubmitFail.isSelected() && this.rdbSucceed.isSelected() && this.rdbFailure.isSelected() && this.rdbOther.isSelected()) {
            this.rdbAll.setSelected(true);
        } else {
            this.rdbAll.setSelected(false);
        }
    }

    private int countNum() {
        int i = 0;
        if (this.rdbPrepSubmit.isSelected()) {
            ++i;
        }
        if (this.rdbSubmitFail.isSelected()) {
            ++i;
        }
        if (this.rdbSubmitSuccess.isSelected()) {
            ++i;
        }
        if (this.rdbSucceed.isSelected()) {
            ++i;
        }
        if (this.rdbFailure.isSelected()) {
            ++i;
        }
        if (this.rdbOther.isSelected()) {
            ++i;
        }
        if (i == 0) {
            i = 6;
        }
        return i;
    }

    protected Class getParamClass() {
        return FixedMutualFilterParam.class;
    }
}

