/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitFilterInfoProducer;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BeServiceAddFactory;
import com.kingdee.eas.fm.be.BeServiceAddInfo;
import com.kingdee.eas.fm.be.BeServiceEntryFactory;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.client.AbstractMulBeServiceUI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MulBeServiceUI
extends AbstractMulBeServiceUI {
    private static final long serialVersionUID = 6943129219565721680L;
    private String resource = "com.kingdee.eas.fm.be.BEAutoGenerateResource";
    private static final Logger logger = CoreUIObject.getLogger(MulBeServiceUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPropEvi();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionSave.setEnabled(false);
        } else {
            this.actionSave.setEnabled(true);
        }
        this.actionAddLine.setEnabled(true);
        this.actionRemoveLine.setEnabled(true);
    }

    @Override
    public void loadFields() {
        this.tblMain.checkParsed();
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    protected void initPropEvi() {
        this.tblMain.checkParsed();
        KDBizPromptBox prmt = new KDBizPromptBox();
        this.initCompanyF7(prmt);
        KDTDefaultCellEditor editor1 = new KDTDefaultCellEditor((IKDEditor)prmt);
        this.tblMain.getColumn("company.number").setEditor((ICellEditor)editor1);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblMain.getColumn("company.number").setRenderer((IBasicRender)avr);
        this.tblMain.getColumn("company.name").getStyleAttributes().setLocked(true);
        if (!this.chkIsMultiple.isSelected()) {
            this.initStatus(false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtServiceAdd);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtRemark);
        if (!this.chkIsMultiple.isSelected()) {
            CoreBaseCollection listTotal = BeServiceAddFactory.getRemoteInstance().getCollection();
            EntityViewInfo info = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isMultiple", (Object)1, CompareType.EQUALS));
            info.setFilter(filter);
            CoreBaseCollection listMul = BeServiceAddFactory.getRemoteInstance().getCollection(info);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)listMul) && listMul.size() > 0 && (EmptyUtil.isEmpty((Object)this.editData.getId()) || listTotal.size() > 1)) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"302_ExistOpen"));
                SysUtil.abort();
            }
        } else if (this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"302_CompanySelected"));
            SysUtil.abort();
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int index = 0; index < this.tblMain.getRowCount(); ++index) {
            IRow row = this.tblMain.getRow(index);
            if (row.getCell("company.number").getValue() != null && row.getCell("company.number").getValue() instanceof CompanyOrgUnitInfo) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)row.getCell("company.number").getValue();
                String companyid = company.getId().toString();
                if (idSet.contains(companyid)) {
                    MsgBox.showInfo((String)(EASResource.getString((String)this.resource, (String)"303_Company") + "\u3010" + company.getName() + "\u3011" + EASResource.getString((String)this.resource, (String)"304_reinvent")));
                    SysUtil.abort();
                } else {
                    idSet.add(companyid);
                }
                FilterInfo filter = new FilterInfo();
                if (!FMHelper.isEmpty((Object)this.editData.getId())) {
                    filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
                }
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                boolean isExist = BeServiceEntryFactory.getRemoteInstance().exists(filter);
                if (!isExist) continue;
                MsgBox.showInfo((String)(EASResource.getString((String)this.resource, (String)"303_Company") + "\u3010" + company.getName() + "\u3011" + EASResource.getString((String)this.resource, (String)"304_reinvent")));
                SysUtil.abort();
                continue;
            }
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"305_CompanyNotEmpty"));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTable kdtEntries) {
        if (kdtEntries == null || kdtEntries.getRowCount() < 1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"306_AtLeastOne"));
            SysUtil.abort();
        }
    }

    protected void initCompanyF7(KDBizPromptBox bizOrgUnitBox) {
        bizOrgUnitBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        OrgUnitFilterInfoProducer iProducer = new OrgUnitFilterInfoProducer(OrgType.Company);
        if (iProducer != null) {
            bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
            if (iProducer.getModel() != null) {
                bizOrgUnitBox.setSelector((KDPromptSelector)iProducer.getModel());
                iProducer.getModel().setMultiSelect(true);
            }
        }
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
        bizOrgUnitBox.setEditFormat("$number$");
        bizOrgUnitBox.setDisplayFormat("$number$");
        bizOrgUnitBox.setEnabledMultiSelection(true);
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        this.initCompanyData(e, this.tblMain);
    }

    private void initCompanyData(KDTEditEvent e, KDTable tblMain) {
        if (e.getValue() == null || e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        String fieldName = tblMain.getColumn(e.getColIndex()).getKey();
        if ("company.number".equals(fieldName)) {
            if (e.getValue() == null) {
                IRow row = tblMain.getRow(e.getRowIndex());
                row.getCell("company.number").setValue(null);
                row.getCell("company.name").setValue(null);
            } else {
                IRow row = tblMain.getRow(e.getRowIndex());
                Object[] accountBankInfoArray = (Object[])e.getValue();
                int rowIndex = e.getRowIndex();
                for (int i = accountBankInfoArray.length - 1; i >= 0; --i) {
                    CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)accountBankInfoArray[i];
                    row.getCell(fieldName).setValue((Object)companyInfo);
                    row.getCell("company.number").setValue((Object)companyInfo);
                    row.getCell("company.name").setValue((Object)companyInfo.getName());
                    if (i <= 0) break;
                    row = tblMain.addRow(rowIndex);
                }
            }
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.deleteData(this.tblMain);
    }

    private void deleteData(KDTable tblMain) {
        ArrayList arrayList = tblMain.getSelectManager().getBlocks();
        for (int i = 0; i < arrayList.size(); ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)tblMain, (IBlock)tblMain.getSelectManager().get(i));
            for (int index = selectBlock.getBottom(); index >= selectBlock.getTop(); --index) {
                tblMain.removeRow(index);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ServiceAdd"));
        sic.add(new SelectorItemInfo("isMultiple"));
        sic.add(new SelectorItemInfo("BeUser"));
        sic.add(new SelectorItemInfo("BeUserPassword"));
        sic.add(new SelectorItemInfo("BeTime"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.company.number"));
        sic.add(new SelectorItemInfo("entry.company.name"));
        return sic;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK pkOut = LogUtil.beginLog(null, (String)"\u4fee\u6539\u94f6\u4f01\u670d\u52a1\u8bbe\u7f6e", (BOSObjectType)new BeServiceAddInfo().getBOSType(), null, null, (String)"bbc_parameter_modify");
        super.actionSave_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    protected IObjectValue createNewData() {
        BeServiceAddInfo objectValue = new BeServiceAddInfo();
        this.initStatus(false);
        objectValue.setDescription(EASResource.getString((String)this.resource, (String)"307_BeServiceAddress"));
        return objectValue;
    }

    private void initStatus(boolean flag) {
        this.tblMain.setVisible(flag);
        this.kDLabel6.setVisible(flag);
        this.btnAddLine.setVisible(flag);
        this.btnRemoveLine.setVisible(flag);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BeServiceAddFactory.getRemoteInstance();
    }

    @Override
    protected void chkIsMultiple_itemStateChanged(ItemEvent e) throws Exception {
    }

    @Override
    public void actionTest_actionPerformed(ActionEvent e) throws Exception {
        IBankFacade iBankFacade = BankFacadeFactory.getRemoteInstance();
        try {
            BeServiceAddInfo beServiceAddInfo = new BeServiceAddInfo();
            beServiceAddInfo.setServiceAdd(this.txtServiceAdd.getText());
            beServiceAddInfo.setBeUser(this.txtBeUser.getText());
            beServiceAddInfo.setBeUserPassword(this.txtBeUserPassword.getText());
            iBankFacade.getVersion(beServiceAddInfo);
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"187_CONN_SUCCESS"));
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new BEException(BEException.TESTVERSION, new String[]{ex.getMessage()});
        }
    }

    @Override
    protected void chkIsMultiple_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkIsMultiple.isSelected()) {
            this.initStatus(true);
        } else {
            int count = this.tblMain.getRowCount();
            String message = EASResource.getString((String)this.resource, (String)"308_OpenEas");
            if (count > 0) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2New((Component)((Object)this), (String)message))) {
                    this.tblMain.removeRows();
                    this.initStatus(false);
                } else {
                    this.chkIsMultiple.setSelected(true);
                    this.tblMain.setVisible(true);
                    this.kDLabel6.setVisible(true);
                    this.btnAddLine.setVisible(true);
                    this.btnRemoveLine.setVisible(true);
                    this.initStatus(true);
                }
            } else {
                this.initStatus(false);
            }
        }
    }
}

