/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.BeOpenAreaData;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.fm.be.client.AbstractOpenAreaFromBeImportUI;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OpenAreaFromBeImportUI
extends AbstractOpenAreaFromBeImportUI {
    private static final Logger logger = CoreUIObject.getLogger(OpenAreaFromBeImportUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.be.beResourse";
    private Map bankInterMap = new HashMap();

    public void onLoad() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int rows = OpenAreaFromBeImportUI.this.tblMain.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    OpenAreaFromBeImportUI.this.tblMain.getRow(i).getCell("isSelected").setValue((Object)Boolean.FALSE);
                }
                OpenAreaFromBeImportUI.this.tblMain.repaint();
            }
        });
        super.onLoad();
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.tblMain.checkParsed();
        this.tblMain.getColumn("isSelected").getStyleAttributes().setLocked(false);
        this.initBankInterface();
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.combAccInterfaceType.removeAllItems();
        Object[] bankCert = BankFacadeFactory.getRemoteInstance().getBankCert("");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < bankCert.length; ++i) {
            BankInterface info = (BankInterface)bankCert[i];
            if (info.getName().indexOf("-") >= 0) {
                info.setName(info.getName().substring(0, info.getName().indexOf("-")));
            }
            if (set.contains(info.getName())) continue;
            this.combAccInterfaceType.addItem((Object)info);
            set.add(info.getName());
        }
        this.combAccInterfaceType.setSelectedIndex(0);
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveAll_actionPerformed(e);
        int rows = this.tblMain.getRowCount();
        for (int i = 0; i < rows; ++i) {
            this.tblMain.getRow(i).getCell("isSelected").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    protected void kdBtnQuery_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        ProvinceInfo province = (ProvinceInfo)this.kDProvince.getValue();
        Map map = BankFacadeFactory.getRemoteInstance().getOpenArea(province);
        Set keySet = map.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            BeOpenAreaData data = (BeOpenAreaData)map.get(iter.next().toString());
            IRow row = this.tblMain.addRow();
            row.getCell("isSelected").setValue((Object)Boolean.FALSE);
            row.getCell("areaCode").setValue((Object)data.getAreaCode());
            row.getCell("province").setValue((Object)data.getProvince());
            row.getCell("city").setValue((Object)data.getCity());
            row.getCell("areaCodeName").setValue((Object)data.getAreaCodeName());
        }
        this.tblMain.setAutoscrolls(true);
        this.tblMain.setRowCount(keySet.size());
        this.tblMain.repaint();
        this.kDScrollPane1.setHorizontalScrollBarPolicy(32);
        this.kDScrollPane1.setVerticalScrollBarPolicy(22);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        int rows = this.tblMain.getRowCount();
        for (int i = 0; i < rows; ++i) {
            this.tblMain.getRow(i).getCell("isSelected").setValue((Object)Boolean.TRUE);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        String interType = this.combAccInterfaceType.getSelectedItem().toString();
        int rows = this.tblMain.getRowCount();
        HashSet<OpenAreaInfo> set = new HashSet<OpenAreaInfo>();
        for (int i = 0; i < rows; ++i) {
            boolean isSelected = (Boolean)this.tblMain.getRow(i).getCell("isSelected").getValue();
            if (!isSelected) continue;
            OpenAreaInfo info = new OpenAreaInfo();
            IRow row = this.tblMain.getRow(i);
            info.setNumber(row.getCell("areaCode").getValue().toString());
            info.setProvince(row.getCell("province").getValue().toString());
            info.setName(row.getCell("city").getValue().toString());
            info.setDescription(row.getCell("areaCodeName").getValue().toString());
            info.setBankInterFaceid(((BankInterface)this.combAccInterfaceType.getSelectedItem()).getNumber());
            info.setBankInterfaceName(interType);
            set.add(info);
        }
    }

    protected String getKeyFieldName() {
        return "areaCode";
    }
}

