/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.client.CapitalSubLegerFilterParam;
import com.kingdee.eas.fi.cas.client.CapitalSubLegerUI;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.RptTransUpDownDetailFacadeFactory;
import com.kingdee.eas.fm.be.client.AbstractRptTransUpDownDetaimMainUI;
import com.kingdee.eas.fm.be.client.RptTransUpDownDetailFilterUI;
import com.kingdee.eas.fm.common.FMLoginModel;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.bireport.IBireportBaseFacade;
import com.kingdee.eas.framework.bireport.client.BireportBaseFilterUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptTransUpDownDetaimMainUI
extends AbstractRptTransUpDownDetaimMainUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTransUpDownDetaimMainUI.class);
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CapitalSubLedgerResource";

    public void checkPeriodNull() throws Exception {
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodCollection pc = FMClientHelper.getValidPeriodColl((CompanyOrgUnitInfo)curCompany);
        if (pc == null || pc.size() == 0) {
            throw new CasException(CasException.PERIODISNULL);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected BireportBaseFilterUI getQueryDialogUserPanel() throws Exception {
        return new RptTransUpDownDetailFilterUI();
    }

    protected IBireportBaseFacade getRemoteInstance() throws BOSException {
        return RptTransUpDownDetailFacadeFactory.getRemoteInstance();
    }

    protected void onBeforeQuery() throws Exception {
        String txtDateRange = Constants.FORMAT_DAY.format((Date)this.params.getObjectElement("dtpFromDate.value")) + " ~ " + Constants.FORMAT_DAY.format((Date)this.params.getObjectElement("dtpToDate.value"));
        this.txtDateRange.setText(txtDateRange);
        this.txtCurrency.setText(this.params.getObjectElement("cboCurrency.value").toString());
        this.txtType.setText(this.params.getObjectElement("upDownType.value").toString());
        this.setMeasurePrecision(2);
        this.setShowDefaultChart(false);
    }

    protected void onAfterQuery() throws Exception {
        this.kDTable1.exchangeColumn(1, 4);
        this.kDTable1.repaint();
        this.addChart().setTitle(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"77_RptTransUpDownDetaimMainUI")).setChartType(ChartType.CT_COLUMNCLUSTERED).finishDataSet();
    }

    protected KDTable getTableForPrintSetting() {
        return this.kDTable1;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.lblPeriodRange.getBoundLabelText()).append("&[PeriodRange]&|").append(this.lblCurrency.getBoundLabelText()).append("&[Currency]&| ").append(this.lblUnit.getBoundLabelText()).append("&[type]");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("PeriodRange", this.txtDateRange.getText());
        map.put("Currency", this.txtCurrency.getText());
        map.put("type", this.txtType.getText());
        return map;
    }

    public static Object getKey(Member[] ms, String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        for (int i = 0; i < ms.length; ++i) {
            if (!ms[i].getDimension().getName().equalsIgnoreCase(name)) continue;
            return ms[i].getKey();
        }
        return null;
    }

    public void actionJoinQuery_actionPerformed(ActionEvent e) throws Exception {
        AccountBankCollection acctC;
        EntityViewInfo view;
        FilterInfo filter;
        CapitalSubLegerFilterParam param = new CapitalSubLegerFilterParam();
        Member[] ms = this.getSelectedDataCellItemInfo();
        if (ms == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"InValiadLine"));
            return;
        }
        Object com = RptTransUpDownDetaimMainUI.getKey(ms, "Company");
        Object per = RptTransUpDownDetaimMainUI.getKey(ms, "Period");
        if (per == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"search_bydate_cannot_search_detail"));
            return;
        }
        Object acctB = RptTransUpDownDetaimMainUI.getKey(ms, "Bank");
        Object acctV = RptTransUpDownDetaimMainUI.getKey(ms, "BankAccount");
        CompanyOrgUnitInfo company = null;
        if (com != null) {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(com.toString()));
        }
        if (company == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"InValiadLine"));
            return;
        }
        if (GlUtils.isCompanyUnion(company)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"NotOnlyUnionMsg"));
            SysUtil.abort();
            return;
        }
        if (acctB == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"can_not_search_total"));
            return;
        }
        param.setCompanyIds(new String[]{company.getId().toString()});
        PeriodInfo period = null;
        if (per != null) {
            period = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(per.toString()));
        }
        param.setPeriodId(period.getId().toString());
        param.setBeginYear(period.getPeriodYear());
        param.setBeginMonth(period.getPeriodNumber());
        param.setEndYear(period.getPeriodYear());
        param.setEndMonth(period.getPeriodNumber());
        param.setIncludeUnSettBill(true);
        param.setFromDate(period.getBeginDate());
        param.setToDate((Date)period.getEndDate());
        Object currency = FMSysDefinedEnum.SELECT_ALL;
        currency = this.params.getObjectElement("cboCurrency.value");
        AccountBankInfo acctBank = null;
        if (acctV != null && !acctV.toString().trim().equals("0")) {
            acctBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctV.toString()));
        }
        boolean bankHasAcctBank = false;
        AccountViewInfo acct = null;
        if (acctBank == null && acctB != null && !acctB.toString().trim().equals("00") && !acctB.toString().trim().equals("0")) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bank.id", acctB));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            view = new EntityViewInfo();
            view.setFilter(filter);
            acctC = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            if (acctC != null && acctC.size() > 0) {
                acctBank = acctC.get(0);
                acct = acctBank.getAccount();
                bankHasAcctBank = true;
            }
        }
        if (acctBank == null) {
            acct = null;
        }
        if (("0".equals(acctB.toString().trim()) || !bankHasAcctBank) && acctV == null) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            view = new EntityViewInfo();
            view.setFilter(filter);
            acctC = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            if (acctC != null && acctC.size() > 0) {
                acctBank = acctC.get(0);
            }
        }
        if ("00".equals(acctB.toString().trim())) {
            acctBank = null;
        }
        CapitalSubLegerUI.showCapitalSubUI((IUIObject)this, (CapitalSubLegerFilterParam)param, (Object)currency, (AccountBankInfo)acctBank, acct);
    }

    public static void main(String[] args) {
        FMLoginModel.newInstance().login("user", "", "eas", "ykport0828");
        FMLoginModel.newInstance().loginMain(RptTransUpDownDetaimMainUI.class.getName());
    }

    protected boolean isAutoMergeRowHead() {
        return false;
    }

    protected boolean isAutoMergeColumnHead() {
        return false;
    }

    protected RptParams getParamsForInit() {
        HashSet<String> set = new HashSet<String>();
        set.add(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        RptParams pp = new RptParams();
        pp.setObject("companyIdSet", set);
        return pp;
    }

    protected RptParams getParamsForRequest() {
        return this.params;
    }
}

