/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.be.client.AbstractRptVirtaulDetailMainUI;
import com.kingdee.eas.fm.be.client.RptVirtualDetailFilterUI;
import com.kingdee.eas.fm.be.client.RptVirtualDetailHandler;
import com.kingdee.eas.fm.be.client.RptVirtualDetailParam;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import org.apache.log4j.Logger;

public class RptVirtaulDetailMainUI
extends AbstractRptVirtaulDetailMainUI {
    private static final Logger logger = CoreUIObject.getLogger(RptVirtaulDetailMainUI.class);
    private RptVirtualDetailFilterUI filterUI = null;
    private static final String TDSOURCE_PATH = "com.kingdee.eas.fm.be.VirtualDetailResource";

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)currentCompany);
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void execQuery() throws BOSException {
        this.tblMain.checkParsed();
        this.tblMain.setColumnMoveable(false);
        RptVirtualDetailParam filterParam = (RptVirtualDetailParam)this.getFilterParam();
        IFMDetailRptHandler handler = this.getBizHander(filterParam);
        handler.initHeader();
        handler.setTableStateRow();
        IRowSet rs = handler.getRowSet();
        try {
            handler.filldata(rs);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        handler.endDataFill();
        this.initLable(filterParam);
    }

    private void initLable(RptVirtualDetailParam param) {
        this.kDLabCompany.setBoundLabelText(this.getResString("company") + SysContext.getSysContext().getCurrentFIUnit().getName());
        this.kDLabCurrency.setBoundLabelText(this.getResString("currency") + param.getCurrency().getName());
        this.kDLabdate.setBoundLabelText(this.getResString("date") + Constants.FORMAT_DAY.format(param.getBizDate()));
    }

    private IFMDetailRptHandler getBizHander(RptVirtualDetailParam filterParam) {
        return new RptVirtualDetailHandler(filterParam.getFilter(), this.tblMain, filterParam);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptVirtualDetailFilterUI();
        }
        return this.filterUI;
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected String getResString(String key) {
        return EASResource.getString((String)TDSOURCE_PATH, (String)key);
    }
}

