/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.SFTPServiceAddFactory;
import com.kingdee.eas.fm.be.SFTPServiceAddInfo;
import com.kingdee.eas.fm.be.client.AbstractSFTPServiceAddEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class SFTPServiceAddEditUI
extends AbstractSFTPServiceAddEditUI {
    private static final long serialVersionUID = 5765187178253990172L;
    private static final Logger logger = CoreUIObject.getLogger(SFTPServiceAddEditUI.class);
    private String resource = "com.kingdee.eas.fm.be.BEAutoGenerateResource";

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionSave.setEnabled(false);
        } else {
            this.actionSave.setEnabled(true);
        }
        this.actionAddLine.setEnabled(true);
        this.actionRemoveLine.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtSFTPServiceAddress);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtSFTPPort);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtSFTPUser);
        String txt = this.txtSFTPUserPassword.getText();
        if (txt == null || txt.trim().equals("")) {
            this.txtSFTPUserPassword.requestFocus(true);
            MsgBox.showWarning((String)EASResource.getString((String)this.resource, (String)"343_SFTP_PASSWORD_NOT_NULL"));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("SFTPServiceAddress"));
        sic.add(new SelectorItemInfo("SFTPPort"));
        sic.add(new SelectorItemInfo("SFTPUser"));
        sic.add(new SelectorItemInfo("SFTPUserPassword"));
        sic.add(new SelectorItemInfo("description"));
        return sic;
    }

    @Override
    protected void btnTest_actionPerformed(ActionEvent e) throws Exception {
        super.btnTest_actionPerformed(e);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionTest_actionPerformed(ActionEvent e) throws Exception {
        IBankFacade iBankFacade = BankFacadeFactory.getRemoteInstance();
        try {
            SFTPServiceAddInfo sftpServiceAddInfo = new SFTPServiceAddInfo();
            sftpServiceAddInfo.setSFTPServiceAddress(this.txtSFTPServiceAddress.getText());
            sftpServiceAddInfo.setSFTPPort(this.txtSFTPPort.getText());
            sftpServiceAddInfo.setSFTPUser(this.txtSFTPUser.getText());
            sftpServiceAddInfo.setSFTPUserPassword(this.txtSFTPUserPassword.getText());
            iBankFacade.checkSFTPLink(sftpServiceAddInfo);
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"340_SFTP_CONN_SUCCESS"));
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new BEException(BEException.SFTP_CONN_FAILED, new String[]{ex.getMessage()});
        }
    }

    protected IObjectValue createNewData() {
        SFTPServiceAddInfo objectValue = new SFTPServiceAddInfo();
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SFTPServiceAddFactory.getRemoteInstance();
    }
}

