/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.BeRpcCacheInfo;
import com.kingdee.eas.fm.be.SharedAcctFacadeFactory;
import com.kingdee.eas.fm.be.TransDetailFilterParam;
import com.kingdee.eas.fm.be.client.AbstractTransDetailFilterUI;
import com.kingdee.eas.fm.be.client.BEClientHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class TransDetailFilterUI
extends AbstractTransDetailFilterUI {
    public static final int ALL_TYPE = 3;
    public static final int REC_TYPE = 2;
    public static final int PAY_TYPE = 1;
    private static final Logger logger = CoreUIObject.getLogger(TransDetailFilterUI.class);
    private static final String F7_COMPANY_QUERY = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery";
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.beResourse";
    private Map bankInterMap = new HashMap();
    private BeRpcCacheInfo RpcCacheInfo;

    public TransDetailFilterUI() throws Exception {
    }

    public TransDetailFilterUI(BeRpcCacheInfo RpcCacheInfo) throws Exception {
        this.RpcCacheInfo = RpcCacheInfo;
    }

    protected void init() throws Exception {
        super.init();
        this.txtMiniAmount.setSupportedEmpty(true);
        this.txtMaxAmount.setSupportedEmpty(true);
        this.initBankInterface();
        this.f7BankAccount.setDisplayFormat("$number$ $name$");
        this.f7BankAccount.setCommitFormat("$number$");
        this.f7BankAccount.setEditFormat("$number$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.chkClose.setSelected(false);
        this.chkIsDataImport.setSelected(false);
        this.cmbxBankInterface.setEnabled(true);
        CurrencyCollection curCol = this.RpcCacheInfo.getAllCurrencyColl();
        this.cmbxCurrency.removeAllItems();
        this.cmbxCurrency.addItems(curCol.toArray());
        this.cmbxCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FMClientHelper.setSelectObject((KDComboBox)this.cmbxCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        this.reSetF7BankAccountQuery();
    }

    private void initF7Comapny(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            this.f7Company.setEnabled(true);
            this.f7Company.setDisplayFormat("$name$");
            this.f7Company.setHasCUDefaultFilter(false);
            this.f7Company.setEnabledMultiSelection(false);
            this.f7Company.setQueryInfo(F7_COMPANY_QUERY);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(company.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)("%!" + company.getLongNumber() + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 and #1 and (#2 or #3)");
            view.setFilter(filter);
            this.f7Company.setEntityViewInfo(view);
        } else {
            BankInfo clearingHouse = FSClientHelper.getClearingHouse();
            if (clearingHouse != null && clearingHouse.isUsed()) {
                if (company.getId().equals((Object)clearingHouse.getRelatedCompany().getId())) {
                    this.f7Company.setEnabled(true);
                    this.f7Company.setDisplayFormat("$name$");
                    this.f7Company.setHasCUDefaultFilter(false);
                    this.f7Company.setEnabledMultiSelection(false);
                    this.f7Company.setQueryInfo(F7_COMPANY_QUERY);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    view.setFilter(filter);
                    this.f7Company.setEntityViewInfo(view);
                }
            } else {
                this.f7Company.setData((Object)company);
                this.f7Company.setEnabled(false);
            }
        }
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.cmbxBankInterface.removeAllItems();
        AccountBankCollection colls = this.RpcCacheInfo.getBankAcctCol();
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.cmbxBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!this.bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.cmbxBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
        }
    }

    private void initF7BankAccount() {
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
        try {
            CompanyOrgUnitInfo clearingHouse = FSClientHelper.getClearingHouseCompany();
            if (clearingHouse != null && !clearingHouse.getId().equals((Object)curCompany.getId())) {
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompany.getId()));
            }
        }
        catch (Exception e1) {
            SysUtil.abort();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setDisplayFormat("$name$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.f7BankAccount.setEntityViewInfo(evi);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void rdbIsOnline_stateChanged(ChangeEvent e) throws Exception {
        if (this.rdbIsOnline.isSelected()) {
            this.chkClose.setSelected(false);
            this.chkClose.setEnabled(false);
            this.chkIsDataImport.setSelected(false);
            this.chkIsDataImport.setEnabled(false);
            if (this.cmbxCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
                CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
                FMClientHelper.setSelectObject((KDComboBox)this.cmbxCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
            }
            this.cmbxCurrency.removeItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.chkClose.setEnabled(true);
            this.chkIsDataImport.setEnabled(true);
            this.cmbxCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
    }

    @Override
    protected void cmbxBankInterface_actionPerformed(ActionEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    private void reSetF7BankAccountQuery() {
        this.f7BankAccount.setData(null);
    }

    @Override
    protected void f7BankAccount_dataChanged(DataChangeEvent e) throws Exception {
        int i;
        ChangeListener[] savedChangeListeners = this.rdbIsOnline.getChangeListeners();
        if (savedChangeListeners != null) {
            for (int i2 = 0; i2 < savedChangeListeners.length; ++i2) {
                this.rdbIsOnline.removeChangeListener(savedChangeListeners[i2]);
            }
        }
        this.rdbIsOnline.setEnabled(true);
        Object[] acctBank = (Object[])this.f7BankAccount.getData();
        if (!EmptyUtil.isEmpty((Object[])acctBank)) {
            for (i = 0; i < acctBank.length; ++i) {
                AccountBankInfo accountBank = (AccountBankInfo)acctBank[i];
                if (!accountBank.isIsClosed()) continue;
                this.rdbIsOnline.setEnabled(false);
                this.rdbIsOffline.setSelected(true);
                break;
            }
        }
        if (savedChangeListeners != null) {
            for (i = 0; i < savedChangeListeners.length; ++i) {
                this.rdbIsOnline.addChangeListener(savedChangeListeners[i]);
            }
        }
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"34_AccountBankBalanceFilterUI"));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)array);
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void f7Company_dataChanged(DataChangeEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void f7BankAccount_willCommit(CommitEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    @Override
    protected void f7BankAccount_willShow(SelectorEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    private void initAccountBankEvi() {
        CurrencyInfo selectedCurrency;
        BankInterface bankInterface;
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!FMHelper.isEmpty((Object[])companyId)) {
            HashSet<Object> list = new HashSet<Object>(companyId.length);
            for (int i = 0; i < companyId.length; ++i) {
                list.add(companyId[i]);
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", list, CompareType.INCLUDE));
        }
        if (!this.chkClose.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        if (!this.chkIsDataImport.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        }
        if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface && !FMHelper.isEmpty((String)(bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankInterface.getNumber()));
        }
        FilterInfo currencyFilter = new FilterInfo();
        if (this.cmbxCurrency.getSelectedItem() != null && !this.cmbxCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS) && (selectedCurrency = (CurrencyInfo)this.cmbxCurrency.getSelectedItem()) != null) {
            currencyFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)new Boolean(true)));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)selectedCurrency.getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)new Boolean(false)));
            currencyFilter.setMaskString("( #0 and #1 ) or #2 ");
        }
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
            filterInfo.mergeFilter(currencyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setEntityViewInfo(evi);
        this.f7BankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public Object getParam() {
        TransDetailFilterParam para = new TransDetailFilterParam();
        HashSet<String> idSet = new HashSet<String>();
        Object[] acctBank = (Object[])this.f7BankAccount.getData();
        if (!EmptyUtil.isEmpty((Object[])acctBank)) {
            for (int i = 0; i < acctBank.length; ++i) {
                idSet.add(((AccountBankInfo)acctBank[i]).getBankAccountNumber());
            }
            Map result = null;
            try {
                result = SharedAcctFacadeFactory.getRemoteInstance().getSharedAcctAndCompany(idSet);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            para.setBankAccts((AccountBankInfo[])result.get("acctBank"));
            String[] companyIds = (String[])result.get("companys");
            para.setCompanyId(companyIds);
        } else {
            para.setBankAccts(null);
            para.setCompanyId(null);
        }
        if (this.cmbxCurrency.getSelectedItem() == null || !this.cmbxCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cmbxCurrency));
        }
        para.setBeginDate(this.dtpBeginDate.getSqlDate());
        para.setEndDate(this.dtpEndDate.getSqlDate());
        para.setMiniAmount(this.txtMiniAmount.getBigDecimalValue());
        para.setMaxAmount(this.txtMaxAmount.getBigDecimalValue());
        if (this.rdbIsOnline.isSelected()) {
            para.setOnLine(true);
        } else {
            para.setOnLine(false);
        }
        para.setClose(this.chkClose.isSelected());
        para.setDataImport(this.chkIsDataImport.isSelected());
        if (this.rdbPay.isSelected()) {
            para.setTransType(1);
        } else if (this.rdbReceive.isSelected()) {
            para.setTransType(2);
        } else {
            para.setTransType(3);
        }
        if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface) {
            BankInterface bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem();
            para.setBankInterface(bankInterface.getNumber());
        } else {
            para.setBankInterface(null);
        }
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof TransDetailFilterParam)) {
            return;
        }
        TransDetailFilterParam para = (TransDetailFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cmbxCurrency, (Object)currencyInfo);
            } else {
                this.cmbxCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        String[] companyIds = para.getCompanyId();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        this.dtpBeginDate.setValue((Object)para.getBeginDate());
        this.dtpEndDate.setValue((Object)para.getEndDate());
        if (para.isOnLine()) {
            this.rdbIsOnline.setSelected(true);
        } else {
            this.rdbIsOffline.setSelected(true);
        }
        this.chkClose.setSelected(para.isClose());
        this.chkIsDataImport.setSelected(para.isDataImport());
        if (para.getTransType() == 1) {
            this.rdbPay.setSelected(true);
        } else if (para.getTransType() == 2) {
            this.rdbReceive.setSelected(true);
        } else {
            this.rdbRecPay.setSelected(true);
        }
        this.txtMiniAmount.setValue((Object)para.getMiniAmount());
        this.txtMaxAmount.setValue((Object)para.getMaxAmount());
        if (FMHelper.isEmpty((String)para.getBankInterface())) {
            this.cmbxBankInterface.setSelectedItem(this.cmbxBankInterface.getItemAt(this.cmbxBankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(para.getBankInterface());
            FMClientHelper.setSelectObject((KDComboBox)this.cmbxBankInterface, (Object)this.cmbxBankInterface.getItemAt(index));
        }
        if (para.getBankAccts() != null) {
            AccountBankCollection coll = new AccountBankCollection();
            for (int index = 0; index < para.getBankAccts().length; ++index) {
                coll.add(para.getBankAccts()[index]);
            }
            this.f7BankAccount.setData((Object)coll.toArray());
        } else if (para.getBankAcctIds() != null) {
            try {
                if (para.getBankAcctIds() != null) {
                    Set set = FMHelper.asSet((String[])para.getBankAcctIds());
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                    ev.setFilter(filter);
                    AccountBankCollection coll = null;
                    IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                    coll = bankAcct.getAccountBankCollection(ev);
                    this.f7BankAccount.setData((Object)coll.toArray());
                }
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void cmbxCurrency_actionPerformed(ActionEvent e) throws Exception {
        String currenyId;
        this.reSetF7BankAccountQuery();
        if (this.cmbxCurrency != null && this.cmbxCurrency.getSelectedItem() != null && !this.cmbxCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS) && (currenyId = AccessHelper.getCboId((KDComboBox)this.cmbxCurrency)) != null) {
            int precision = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)currenyId));
            this.txtMiniAmount.setPrecision(precision);
            this.txtMaxAmount.setPrecision(precision);
        }
    }

    public boolean verify() {
        try {
            this.checkPermission(this.rdbIsOnline.isSelected());
        }
        catch (Exception e) {
            MsgBox.showError((String)e.getMessage());
            SysUtil.abort();
        }
        BigDecimal miniAmt = Constants.ZERO;
        BigDecimal maxAmt = Constants.ZERO;
        if (this.txtMiniAmount.getBigDecimalValue() != null && (miniAmt = this.txtMiniAmount.getBigDecimalValue()).compareTo(Constants.MAX_VALUE) == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.txtMiniAmount.setValue((Object)Constants.ZERO);
            SysUtil.abort();
        }
        if (this.txtMaxAmount.getBigDecimalValue() != null && (maxAmt = this.txtMaxAmount.getBigDecimalValue()).compareTo(Constants.MAX_VALUE) == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.txtMaxAmount.setValue((Object)Constants.ZERO);
            SysUtil.abort();
        }
        if (miniAmt.compareTo(maxAmt) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"78_TransDetailFilterUI"));
            SysUtil.abort();
        }
        if (this.f7BankAccount.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckAccountBank"));
            SysUtil.abort();
        }
        return BEClientHelper.verifyDate((Component)((Object)this), this.dtpBeginDate, this.dtpEndDate);
    }

    private void checkPermission(boolean isOnline) throws BOSException, EASBizException {
        IPermission permission = PermissionFactory.getRemoteInstance();
        String companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        String userId = ContextHelperFactory.getRemoteInstance().getCurrentUser().getId().toString();
        boolean BE020 = ContextHelperFactory.getRemoteInstance().getBooleanParam("BE020", (IObjectPK)new ObjectUuidPK(companyId));
        if (BE020 && isOnline) {
            permission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(companyId), "transDetail_13onLineView");
        }
    }

    @Override
    protected void chkIsDataImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkIsDataImport.isSelected()) {
            this.cmbxBankInterface.setSelectedItem(this.cmbxBankInterface.getItemAt(this.cmbxBankInterface.getItemCount() - 1));
        } else {
            this.reSetF7BankAccountQuery();
        }
    }

    protected Class getParamClass() {
        return TransDetailFilterParam.class;
    }

    @Override
    protected void chkClose_actionPerformed(ActionEvent e) throws Exception {
        this.f7BankAccount.setData(null);
    }
}

