/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.client.CasPaymentBillUI;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BeRpcCacheInfo;
import com.kingdee.eas.fm.be.EReceiptWebFacadeFactory;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.ITransDetail;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailFilterParam;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.TransDetailRecedEnum;
import com.kingdee.eas.fm.be.TransDetailVerify;
import com.kingdee.eas.fm.be.client.AbstractTransDetailListUI;
import com.kingdee.eas.fm.be.client.BeDetailCheckUI;
import com.kingdee.eas.fm.be.client.TransDetailFilterUI;
import com.kingdee.eas.fm.be.client.TransDetailRecedUpdateStateUI;
import com.kingdee.eas.fm.be.client.TransDetailRefundPaymentBill;
import com.kingdee.eas.fm.be.client.TransDetailServiceClient;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.H;
import com.kingdee.eas.fm.common.client.EReceiptCommonClientHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransDetailListUI
extends AbstractTransDetailListUI {
    private static final Logger logger = CoreUIObject.getLogger(TransDetailListUI.class);
    private TransDetailFilterUI filterUI;
    public static final String RESOURCE_PATH = "com.kingdee.eas.fm.be.BEAutoGenerateResource";
    public BeRpcCacheInfo envirRpc = null;
    private TransDetailFilterParam para;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnQuery.setText(this.resHelper.getString("ActionQuery.NAME"));
        this.actionDetailCheck.setEnabled(true);
        this.actionCreateTo.setEnabled(false);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionConfirmRecked.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_payment"));
        this.actionConfirmRecked.setEnabled(true);
        this.actionCancelConfirmRecked.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unpayment"));
        this.actionCancelConfirmRecked.setEnabled(true);
        this.actionExport.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_output"));
        this.btnCelConfirmTransDown.setVisible(false);
        this.actionImportData.setEnabled(true);
        this.actionNavEreceipt.setEnabled(true);
        this.actionNavEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnMatchTransDetail.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.menuItemImportData.setVisible(true);
        this.menuItemImportData.setEnabled(true);
        this.actionBankWithHoldingConfirm.setEnabled(true);
        this.actionCancelBankWithHoldingConfirm.setEnabled(true);
    }

    public void setCurrencyFormat(KDTable tblMain, TransDetailFilterParam param) {
        String numberFtm = param.getCurrencyId() == null ? "%r-[ ]{###,###,##0.00}15.2n" : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)param.getCurrencyId()));
        tblMain.getColumn("bankAcct").getStyleAttributes().setNumberFormat("@");
        tblMain.getColumn("bankAcctName").getStyleAttributes().setNumberFormat("@");
        tblMain.getColumn("oppBankNumber").getStyleAttributes().setNumberFormat("@");
        tblMain.getColumn("debitAmount").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("creditAmount").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("transBalance").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("transBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void onLoad() throws Exception {
        this.envirRpc = (BeRpcCacheInfo)this.rpcCacheInfo;
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getColumn("bizTime").getStyleAttributes().setNumberFormat(this.timeFormat);
    }

    protected boolean isRpcCacheProcess() {
        return true;
    }

    protected FmRpcCacheInfo getRpcCacheParam() {
        BeRpcCacheInfo paramInfo = new BeRpcCacheInfo();
        paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
        paramInfo.setBillInfo((CoreBaseInfo)new TransDetailInfo());
        return paramInfo;
    }

    protected String getRpcBatchImplClassName() {
        return "com.kingdee.eas.fm.be.app.BeRpcBatchFetcher";
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow footRow = super.appendFootRow();
        if (footRow != null) {
            int i;
            String[] numberCols = new String[]{"debitAmount", "creditAmount"};
            int[] numberColsPrecision = new int[]{4, 4};
            BigDecimal debitAmt = new BigDecimal(0.0);
            BigDecimal creditAmt = new BigDecimal(0.0);
            ArrayList<String> idList = new ArrayList<String>();
            boolean needUpdate = false;
            for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                String parentid = (String)row.getCell("id").getValue();
                if (idList.contains(parentid)) {
                    needUpdate = true;
                    continue;
                }
                idList.add(parentid);
                if (row.equals(footRow)) continue;
                debitAmt = debitAmt.add((BigDecimal)row.getCell("debitAmount").getValue());
                creditAmt = creditAmt.add((BigDecimal)row.getCell("creditAmount").getValue());
            }
            if (needUpdate) {
                this.tblMain.getFootRow(0).getCell("debitAmount").setValue((Object)debitAmt);
                this.tblMain.getFootRow(0).getCell("creditAmount").setValue((Object)creditAmt);
            }
            for (i = 0; i < numberCols.length; ++i) {
                this.tblMain.getFootRow(0).getCell(numberCols[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)numberColsPrecision[i]));
            }
        }
        return footRow;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new TransDetailFilterUI(this.envirRpc);
        }
        return this.filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TransDetailFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(FilterParam param) throws BOSException {
        this.para = (TransDetailFilterParam)param;
        this.setCurrencyFormat(this.tblMain, this.para);
        if (this.para.isOnLine()) {
            IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
            AccountBankInfo[] ids = this.para.getBankAccts();
            ArrayList<String> lockIds = new ArrayList<String>();
            ArrayList<String> idList = new ArrayList<String>();
            for (int i = 0; i < ids.length; ++i) {
                lockIds.add(ids[i].getId().toString() + "JYMX");
                idList.add(ids[i].getId().toString());
            }
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            ArrayList appliedList = new ArrayList();
            ArrayList releaseList = new ArrayList();
            try {
                Boolean boolResult;
                int i;
                Map resultRequest = iMutex.batchRequestObjIDForUpdate(lockIds);
                for (i = 0; i < lockIds.size(); ++i) {
                    boolResult = (Boolean)resultRequest.get(lockIds.get(i));
                    if (!boolResult.booleanValue()) continue;
                    appliedList.add(idList.get(i));
                    releaseList.add(lockIds.get(i));
                }
                for (i = 0; i < lockIds.size(); ++i) {
                    boolResult = (Boolean)resultRequest.get(lockIds.get(i));
                    if (boolResult.booleanValue()) continue;
                    String msg1 = EASResource.getString((String)RESOURCE_PATH, (String)"186_GETACCBANKFAIL");
                    MsgBox.showInfo((String)msg1);
                    return;
                }
                BigDecimal miniAmount = this.para.getMiniAmount();
                BigDecimal maxAmount = this.para.getMaxAmount();
                if (miniAmount == null) {
                    miniAmount = Constants.MIN_VALUE;
                }
                if (maxAmount == null) {
                    maxAmount = Constants.MAX_VALUE;
                }
                Map rst = null;
                long startTime = System.currentTimeMillis();
                if (EmptyUtil.isEmpty((String)this.para.getBankInterface())) {
                    TransDetailServiceClient service = new TransDetailServiceClient();
                    rst = service.queryTransDetail(this.para.getCurrencyId(), this.para.getBankAccts(), this.para.getBeginDate(), this.para.getEndDate(), miniAmount, maxAmount);
                } else {
                    String[] idss = new String[appliedList.size()];
                    rst = bankFacade.getDetails(this.para.getCurrencyId(), appliedList.toArray(idss), this.para.getBeginDate(), this.para.getEndDate(), miniAmount, maxAmount);
                }
                long endTime = System.currentTimeMillis();
                logger.error((Object)(EASResource.getString((String)RESOURCE_PATH, (String)"1158_AccountBankBalanceUI") + (endTime - startTime) / 1000L + EASResource.getString((String)RESOURCE_PATH, (String)"108_BankInterfaceListUI")));
                String failed = (String)rst.get("failed");
                int failedCount = (Integer)rst.get("failedcount");
                int success = this.para.getBankAccts().length - failedCount;
                String message = MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"115_TransDetailMainMsg"), new Integer(success), new Integer(failedCount));
                MsgBox.showDetailAndOK((Component)((Object)this), (String)message, (String)failed, (int)1);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"OnLineSearchError"), e.getMessage());
                MsgBox.showInfo((Component)((Object)this), (String)msgStr);
            }
            finally {
                if (releaseList.size() > 0) {
                    iMutex.batchReleaseObjIDForUpdate(releaseList);
                }
                super.executeQuery(param);
                this.tblMain.setColumnMoveable(true);
            }
        } else {
            super.executeQuery(param);
            this.tblMain.setColumnMoveable(true);
        }
    }

    private boolean isBotp() {
        if (this.getUIContext().get("BOTPViewStatus") == null) {
            return false;
        }
        int status = (Integer)this.getUIContext().get("BOTPViewStatus");
        return status == 1;
    }

    protected void execQuery() {
        if (this.isBotp()) {
            try {
                FilterInfo filter = this.getFilter();
                this.mainQuery.getFilter().mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        super.execQuery();
        this.setCurrenyFrm2Cell();
    }

    private void setCurrenyFrm2Cell() {
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblMain.getRow(i);
            Object currency = row.getCell("currency.id").getValue();
            String numberFtm = currency == null ? "%r-[ ]{###,###,##0.00}15.2n" : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currency.toString()));
            row.getCell("bankAcct").getStyleAttributes().setNumberFormat("@");
            row.getCell("bankAcctName").getStyleAttributes().setNumberFormat("@");
            row.getCell("oppBankNumber").getStyleAttributes().setNumberFormat("@");
            row.getCell("debitAmount").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("creditAmount").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("transBalance").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("transBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    private FilterInfo getFilter() throws BOSException {
        Map botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (botpCtx == null) {
            return null;
        }
        String targetBill = (String)botpCtx.get("TargetBill");
        String companyId = (String)botpCtx.get("companyId");
        if (targetBill == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"80_TransDetailListUI"));
        }
        if (companyId == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"81_TransDetailListUI"));
        }
        FilterInfo filter = new FilterInfo();
        if (targetBill != null && (targetBill.equals("TransUpBill") || targetBill.equals("TransDownBill"))) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            if (targetBill.equals("TransUpBill")) {
                filter.getFilterItems().add(new FilterItemInfo("isDebit", (Object)Boolean.FALSE));
                filter.getFilterItems().add(new FilterItemInfo("isTransUp", (Object)Boolean.TRUE));
                filter.getFilterItems().add(new FilterItemInfo("isCreatedTransUp", (Object)Boolean.FALSE));
            }
            if (targetBill.equals("TransDownBill")) {
                filter.getFilterItems().add(new FilterItemInfo("isTransDown", (Object)Boolean.TRUE));
                filter.getFilterItems().add(new FilterItemInfo("isCreatedtransDown", (Object)Boolean.FALSE));
            }
            filter.getFilterItems().add(new FilterItemInfo("isReced", (Object)TransDetailRecedEnum.toBeReced.getValue()));
        }
        FilterInfo kdFilter = new FilterInfo();
        kdFilter.getFilterItems().add(new FilterItemInfo("number", (Object)"KD%", CompareType.NOTLIKE));
        kdFilter.getFilterItems().add(new FilterItemInfo("number", null));
        kdFilter.setMaskString("#0 or #1 ");
        filter.mergeFilter(kdFilter, "AND");
        return filter;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat("yyyy-mm-dd");
        super.actionExport_actionPerformed(e);
    }

    @Override
    public void actionDetailCheck_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BeDetailCheckUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionConfirmTransUP_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet ids = new HashSet();
        ids.addAll(this.getSelectedIdValues());
        TransDetailFactory.getRemoteInstance().confirmTransUP(ids);
        this.refresh(e);
    }

    @Override
    public void actionCancelConfirmTransUP_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet ids = new HashSet();
        ids.addAll(this.getSelectedIdValues());
        TransDetailFactory.getRemoteInstance().cancelConfirmTransUP(ids);
        this.refresh(e);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        String selectedKeyValue = this.getSelectedKeyValue();
        if (selectedKeyValue == null) {
            return;
        }
        int idx = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(idx);
        TransDetailInfo info = new TransDetailInfo();
        info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            this.refreshList();
            return;
        }
        info.setIsTransDown((Boolean)row.getCell("isTransDown").getValue());
        info.setIsTransUp((Boolean)row.getCell("isTransUp").getValue());
        info.setIsCreatedTransUp((Boolean)row.getCell("isCreatedTransUp").getValue());
        BigDecimal creditAmount = row.getCell("creditAmount").getValue() == null ? Constants.ZERO : (BigDecimal)row.getCell("creditAmount").getValue();
        info.setIsCreatedtransDown((Boolean)row.getCell("isCreatedtransDown").getValue());
        BigDecimal debitAmount = row.getCell("debitAmount").getValue() == null ? Constants.ZERO : (BigDecimal)row.getCell("debitAmount").getValue();
        info.setDebitAmount(debitAmount);
        info.setCreditAmount(creditAmount);
        info.setHasRefundPay((Boolean)row.getCell("hasRefundPay").getValue());
        this.actionConfirmTransUP.setEnabled(TransDetailVerify.isCanConfirmTransUP(info));
        this.actionCancelConfirmTransUP.setEnabled(TransDetailVerify.isCanCancelConfirmTransUP(info));
        this.actionConfirmTransDown.setEnabled(TransDetailVerify.isCanConfirmTransDown(info));
        this.actionCelConfirmTransDown.setEnabled(TransDetailVerify.isCanCancelConfirmTransDown(info));
        this.actionRefundPay.setEnabled(TransDetailVerify.isCanRefundPay(info));
    }

    @Override
    public void actionRefundPay_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return;
        }
        ITransDetail biz = TransDetailFactory.getRemoteInstance();
        TransDetailInfo info = biz.getTransDetailInfo(H.PK((Object)id));
        if (info.isHasRefundPay()) {
            throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"323_ExsitDataForRepay")});
        }
        Map params = H.JSMAP((Object[])new Object[]{"id", id});
        params.put("date", H.DATE((Object[])new Object[]{info.getBizTime(), "yyyy-MM-dd"}));
        params.put("accountId", H.IDSTR((Object)info.getBankAccount()));
        params.put("companyId", H.IDSTR((Object)info.getCompany()));
        params.put("currencyId", H.IDSTR((Object)info.getCurrency()));
        if (H.isEmpty((Object)info.getCreditAmount())) {
            params.put("amount", H.BDEC((Object)info.getDebitAmount()));
        } else {
            params.put("amount", H.BDEC((Object)info.getCreditAmount()));
        }
        Map ret = biz.getRefundPaymentBills(params);
        PaymentBillCollection bills = (PaymentBillCollection)ret.get("bills");
        if (bills == null || bills.size() == 0) {
            if (ret.get("DateRange") != null) {
                int d = (Integer)ret.get("DateRange");
                throw new BEException(BEException.COMMON, new String[]{MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"313_NoDataForRepay"), new Integer(d), new Integer(d))});
            }
            throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"344_NoDataForRepay")});
        }
        if (bills.size() == 1) {
            this.createRefundPaymentBill(info, bills.get(0));
        } else {
            TransDetailRefundPaymentBill.showBills(bills);
            if (TransDetailRefundPaymentBill.selBill != null) {
                this.createRefundPaymentBill(info, TransDetailRefundPaymentBill.selBill);
            }
        }
    }

    public void createRefundPaymentBill(TransDetailInfo info, PaymentBillInfo bill) throws BOSException {
        PaymentBillInfo pinfo = (PaymentBillInfo)H.getInfo((Object[])new Object[]{"*,entries.*,assItems.*", H.IDSTR((Object)bill.getId())});
        pinfo.setRefundPayBillId(H.IDSTR((Object)bill.getId()));
        UIContext uiContext = new UIContext((Object)this.getUIContext());
        uiContext.put((Object)"COPY", (Object)"COPY");
        uiContext.put((Object)"ID", (Object)H.IDSTR((Object)bill.getId()));
        uiContext.put((Object)"transDetailInfo", (Object)info);
        uiContext.put((Object)"refundPaymentBillInfo", (Object)pinfo);
        uiContext.put((Object)"isRefundPay", (Object)true);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(CasPaymentBillUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public void beforeTransform(IObjectCollection srcObjCols, String destBillBosType) {
        if (srcObjCols == null) {
            return;
        }
        if (destBillBosType.equals(TransUpBillInfo.BOSTypeString()) || destBillBosType.equals(TransDownBillInfo.BOSTypeString()) && srcObjCols.size() > 0) {
            try {
                int n = srcObjCols.size();
                for (int i = 0; i < n; ++i) {
                    TransDetailInfo transDetailInfo = (TransDetailInfo)srcObjCols.getObject(i);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)transDetailInfo.getCompany())) {
                        throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"1237_TransDetailListUI")});
                    }
                    if (EmptyUtil.isEmpty((CoreBaseInfo)transDetailInfo.getBankAccount())) {
                        throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"1238_TransDetailListUI")});
                    }
                    if (EmptyUtil.isEmpty((CoreBaseInfo)transDetailInfo.getCurrency())) {
                        throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"1239_TransDetailListUI")});
                    }
                    if (EmptyUtil.isEmpty((Object)transDetailInfo.getBizTime())) {
                        throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"1240_TransDetailListUI")});
                    }
                    if (EmptyUtil.isEmpty((Object)transDetailInfo.getDebitAmount())) {
                        throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"1241_TransDetailListUI")});
                    }
                    if (EmptyUtil.isEmpty((Object)transDetailInfo.getCreditAmount())) {
                        throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"1242_TransDetailListUI")});
                    }
                    if (EmptyUtil.isEmpty((String)transDetailInfo.getOppBankNumber())) {
                        throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"1243_TransDetailListUI")});
                    }
                    if (!EmptyUtil.isEmpty((String)transDetailInfo.getOppUnit())) continue;
                    throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"1244_TransDetailListUI")});
                }
                TransDetailVerify.verifyBotpTransUpbill((CoreBillBaseCollection)srcObjCols);
                AccountBankInfo motherAccBank = ((TransDetailInfo)srcObjCols.getObject(0)).getBankAccount();
                IAccountBank accBankSvr = AccountBankFactory.getRemoteInstance();
                int n2 = srcObjCols.size();
                for (int i = 0; i < n2; ++i) {
                    String msgStr;
                    TransDetailInfo transDetailInfo = (TransDetailInfo)srcObjCols.getObject(i);
                    AccountBankCollection accbankcols = accBankSvr.getAccountBankCollection("select id, number, name, bankAccountNumber, subAccount.id, subAccount.number, subAccount.name, subAccount.bankAccountNumber, subAccount.accountBank.*, company.id, company.name, company.number where bankAccountNumber = '" + transDetailInfo.getOppBankNumber() + "'");
                    if (accbankcols.size() == 0) {
                        throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"82_TransDetailListUI") + TransDetailVerify.getTransDetailTitle(transDetailInfo) + EASResource.getString((String)RESOURCE_PATH, (String)"83_TransDetailListUI") + transDetailInfo.getOppBankNumber()});
                    }
                    if (accbankcols.size() > 1) {
                        throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"84_TransDetailListUI") + TransDetailVerify.getTransDetailTitle(transDetailInfo) + EASResource.getString((String)RESOURCE_PATH, (String)"85_TransDetailListUI") + transDetailInfo.getOppBankNumber()});
                    }
                    AccountBankInfo unitAccBank = accbankcols.get(0);
                    if (null == unitAccBank.getSubAccount()) {
                        msgStr = MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"164_TransDetailListUI"), TransDetailVerify.getTransDetailTitle(transDetailInfo));
                        throw new BEException(BEException.COMMON, new String[]{msgStr});
                    }
                    if (null == unitAccBank.getCompany()) {
                        msgStr = MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"165_TransDetailListUI"), TransDetailVerify.getTransDetailTitle(transDetailInfo));
                        throw new BEException(BEException.COMMON, new String[]{msgStr});
                    }
                    AccountBankInfo thisMotherAccBank = unitAccBank.getSubAccount();
                    if (i == 0) {
                        motherAccBank = thisMotherAccBank;
                        continue;
                    }
                    if (motherAccBank.equalsPK((IObjectValue)thisMotherAccBank)) continue;
                    String msgStr2 = MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"166_TransDetailListUI"), TransDetailVerify.getTransDetailTitle(transDetailInfo));
                    throw new BEException(BEException.COMMON, new String[]{msgStr2});
                }
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"90_TransDetailListUI"));
    }

    @Override
    public void actionConfirmTransDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet ids = new HashSet();
        ids.addAll(this.getSelectedIdValues());
        TransDetailFactory.getRemoteInstance().confirmTransDown(ids);
        this.refresh(e);
    }

    @Override
    public void actionCelConfirmTransDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet ids = new HashSet();
        ids.addAll(this.getSelectedIdValues());
        TransDetailFactory.getRemoteInstance().cancelConfirmTransDown(ids);
        this.refresh(e);
    }

    @Override
    public void actionConfirmRecked_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        ObjectUuidPK pk = null;
        ArrayList idList = this.getSelectedIdValues();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        for (int i = 0; i < idList.size(); ++i) {
            pk = new ObjectUuidPK(idList.get(i).toString());
            TransDetailInfo checkInfo = ((ITransDetail)this.getBizInterface()).getTransDetailInfo((IObjectPK)pk, sic);
            iPermission.checkDataPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(checkInfo.getCompany().getId().toString()), "transDetail_10confirmReced", (IObjectPK)pk);
        }
        HashSet ids = new HashSet();
        ids.addAll(idList);
        UIContext uiContext = new UIContext((Object)this);
        String uiName = TransDetailRecedUpdateStateUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        TransDetailRecedEnum updateState = ((TransDetailRecedUpdateStateUI)uiWindow.getUIObject()).getResult();
        if (null == updateState) {
            return;
        }
        Map result = TransDetailFactory.getRemoteInstance().confirmRecked(ids, updateState.getValue());
        String errMsg = (String)result.get("fails");
        String summary = (String)result.get("summary");
        if (EmptyUtil.isEmpty((String)errMsg)) {
            MsgBox.showInfo((Component)((Object)this), (String)summary);
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)summary, (String)errMsg, (int)0);
        }
        this.refresh(e);
    }

    @Override
    public void actionCancelConfirmRecked_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet ids = new HashSet();
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        ObjectUuidPK pk = null;
        ArrayList idList = this.getSelectedIdValues();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        for (int i = 0; i < idList.size(); ++i) {
            pk = new ObjectUuidPK(idList.get(i).toString());
            TransDetailInfo checkInfo = ((ITransDetail)this.getBizInterface()).getTransDetailInfo((IObjectPK)pk, sic);
            iPermission.checkDataPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(checkInfo.getCompany().getId().toString()), "transDetail_11cancelConfirmReced", (IObjectPK)pk);
        }
        ids.addAll(idList);
        TransDetailFactory.getRemoteInstance().cancelConfirmRecked(ids);
        this.refresh(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.be.TransDetail";
        param.alias = EASResource.getString((String)RESOURCE_PATH, (String)"86_TransDetailListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionNavEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        List ereceiptList = EReceiptWebFacadeFactory.getRemoteInstance().getEReceiptByTransDetailIdList(idList);
        if (!EmptyUtil.isEmpty((Collection)ereceiptList) && ereceiptList.size() > 0) {
            EReceiptCommonClientHelper.viewEreceiptByIdList((List)ereceiptList, (Component)((Object)this));
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH, (String)"1245_TransDetailListUI"));
            SysUtil.abort();
        }
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    @Override
    public void actionBankWithHoldingConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet ids = new HashSet();
        ids.addAll(this.getSelectedIdValues());
        TransDetailFactory.getRemoteInstance().confirmBankWithHolding(ids);
        this.refresh(e);
    }

    @Override
    public void actionCancelBankWithHoldingConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet ids = new HashSet();
        ids.addAll(this.getSelectedIdValues());
        TransDetailFactory.getRemoteInstance().cancelConfirmBankWithHolding(ids);
        this.refresh(e);
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        boolean isPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission(this.getUserPk(), this.getOrgPK((ItemAction)this.actionImportData), "transDetail_12import");
        if (!isPermission) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"333_NOIMPORTPERMISSION"));
            SysUtil.abort();
        }
        super.actionImportData_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionMatchBizBill_actionPerformed(ActionEvent e) throws Exception {
        ArrayList selectIds = this.getSelectedIdValues();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        HashSet<String> appliedList = new HashSet<String>();
        ArrayList releasedList = new ArrayList();
        ArrayList<String> lockIds = new ArrayList<String>();
        if (!EmptyUtil.isEmpty((Collection)selectIds)) {
            for (int i = 0; i < selectIds.size(); ++i) {
                lockIds.add(selectIds.get(i) + "MatchBill");
            }
            try {
                Boolean boolResult;
                int i;
                Map resultRequest = iMutex.batchRequestObjIDForUpdate(lockIds);
                for (i = 0; i < lockIds.size(); ++i) {
                    boolResult = (Boolean)resultRequest.get(lockIds.get(i));
                    if (!boolResult.booleanValue()) continue;
                    appliedList.add((String)selectIds.get(i));
                    releasedList.add(lockIds.get(i));
                }
                for (i = 0; i < lockIds.size(); ++i) {
                    boolResult = (Boolean)resultRequest.get(lockIds.get(i));
                    if (boolResult.booleanValue()) continue;
                    String msg1 = EASResource.getString((String)RESOURCE_PATH, (String)"186_GETTRANSDEATAILFAIL");
                    MsgBox.showInfo((String)msg1);
                    return;
                }
                Map ret = BankFacadeFactory.getRemoteInstance().matchBizBillInfo(appliedList, null, null);
                int matchCount = (Integer)ret.get("totalCount");
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RESOURCE_PATH, (String)"1246_TransDetailListUI") + matchCount + EASResource.getString((String)RESOURCE_PATH, (String)"1247_TransDetailListUI")));
            }
            finally {
                if (releasedList.size() > 0) {
                    iMutex.batchReleaseObjIDForUpdate(releasedList);
                }
            }
        }
        AccountBankInfo[] ids = this.para.getBankAccts();
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            lockIds.add(ids[i].getId().toString() + "MatchBill");
            idList.add(ids[i].getId().toString());
        }
        try {
            Boolean boolResult;
            int i;
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(lockIds);
            for (i = 0; i < lockIds.size(); ++i) {
                boolResult = (Boolean)resultRequest.get(lockIds.get(i));
                if (!boolResult.booleanValue()) continue;
                appliedList.add((String)idList.get(i));
                releasedList.add(lockIds.get(i));
            }
            for (i = 0; i < lockIds.size(); ++i) {
                boolResult = (Boolean)resultRequest.get(lockIds.get(i));
                if (boolResult.booleanValue()) continue;
                String msg1 = EASResource.getString((String)RESOURCE_PATH, (String)"186_GETACCBANKFAIL");
                MsgBox.showInfo((String)msg1);
                return;
            }
            Map ret = BankFacadeFactory.getRemoteInstance().matchBizBillInfo(appliedList, this.para.getBeginDate(), this.para.getEndDate());
            int matchCount = (Integer)ret.get("totalCount");
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RESOURCE_PATH, (String)"1246_TransDetailListUI") + matchCount + EASResource.getString((String)RESOURCE_PATH, (String)"1247_TransDetailListUI")));
        }
        finally {
            if (releasedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(releasedList);
            }
        }
        this.refreshList();
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dlg = super.getQueryDlg();
        dlg.setWidth(586);
        return dlg;
    }
}

