/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.JobTypeEnum;
import com.kingdee.eas.fm.be.ScheduleJobFactory;
import com.kingdee.eas.fm.be.ScheduleJobInfo;
import com.kingdee.eas.fm.be.vo.ScheduleJobVO;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;

public class ScheduleJobHelper {
    public static final String strResource = "com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteFail_ByNumber";
    public static final String commonResource = "com.kingdee.eas.common.CommonResource";

    public static ScheduleJobHelper getInstance() {
        return new ScheduleJobHelper();
    }

    public ScheduleJobInfo VOToInfo(Context ctx, ScheduleJobVO vo) throws EASBizException, BOSException {
        ScheduleJobInfo info = new ScheduleJobInfo();
        AccountBankInfo accountBankInfo = null;
        if (vo == null) {
            return info;
        }
        if (vo.getId() != null) {
            try {
                info = ScheduleJobFactory.getLocalInstance(ctx).getScheduleJobInfo((IObjectPK)new ObjectUuidPK(vo.getId()));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (info == null) {
            info = new ScheduleJobInfo();
        }
        if (vo.getAccountBank() != null) {
            try {
                accountBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(vo.getAccountBank()));
                if (accountBankInfo != null && info != null) {
                    info.setAccountBank(accountBankInfo);
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            info.setAccountBank(null);
        }
        if (vo.getBankInterFace() != null) {
            info.setBankInterFace(vo.getBankInterFace());
        } else {
            info.setBankInterFace(null);
        }
        if (!EmptyUtil.isEmpty((String)vo.getCurrency())) {
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(vo.getCurrency()));
            info.setCurrency(currencyInfo);
        } else {
            info.setCurrency(null);
        }
        if (vo.getCycle() > 0) {
            info.setCycle(vo.getCycle());
        } else {
            info.setCycle(vo.getCycle());
        }
        info.setMessagerName(vo.getMessagerName());
        info.setReceiveMessager(vo.getReceiveMessager());
        if (vo.getNumber() != null) {
            info.setNumber(vo.getNumber());
        }
        if (accountBankInfo != null) {
            CompanyOrgUnitInfo company = accountBankInfo.getCompany();
            info.setCompany(company);
        } else {
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
            info.setCompany(companyInfo);
        }
        if (vo.getType() != null) {
            JobTypeEnum type = JobTypeEnum.getEnum(Integer.parseInt(vo.getType().toString()));
            info.setType(type);
        }
        info.setIsEffected(vo.isEffected());
        info.setIsGenTranUp(vo.isGenTranUp());
        info.setDateTime(DateUtil.getTimeStampDayBegin());
        return info;
    }

    public void isReferenced(IDataBase idataBase, IObjectPK[] pkArray, Context ctx) throws EASBizException {
        HashMap<IObjectPK, Exception> exceptionMap = new HashMap<IObjectPK, Exception>();
        HashMap<IObjectPK, String> numberMap = new HashMap<IObjectPK, String>();
        for (int idx = 0; idx < pkArray.length; ++idx) {
            IObjectPK curPKID = pkArray[idx];
            try {
                if (!idataBase.exists(curPKID)) continue;
                DataBaseInfo baseInfo = idataBase.getDataBaseInfo(curPKID);
                numberMap.put(curPKID, baseInfo.getNumber());
                idataBase.isReferenced(curPKID);
                continue;
            }
            catch (Exception ex) {
                exceptionMap.put(curPKID, ex);
            }
        }
        String numbetMsg = EASCommonResource.getString((String)strResource, (Locale)ctx.getLocale());
        StringBuffer errorMsg = new StringBuffer();
        Set key = exceptionMap.keySet();
        for (IObjectPK idPK : key) {
            Exception exception = (Exception)exceptionMap.get(idPK);
            errorMsg.append(MessageFormat.format(numbetMsg, numberMap.get(idPK)));
            errorMsg.append(",").append(ScheduleJobHelper.getMessage(exception, ctx)).append("\n");
        }
        if (errorMsg.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("cas100", errorMsg.toString()));
        }
    }

    public void handler(Exception exc, Context ctx) throws BOSException {
        if (exc instanceof ObjectReferedException) {
            StringBuffer msg = new StringBuffer();
            BizReference ref = (BizReference)((ObjectReferedException)exc).getReferingObject();
            if (ref != null) {
                Object[] objects = new Object[1];
                String locale = ctx.getLocale().toString();
                objects[0] = ref.getRefEntityAlias(new Locale(locale));
                String template = EASCommonResource.getString((String)commonResource, (String)"isReferedError", (Locale)ctx.getLocale());
                msg.append(MessageFormat.format(template, objects));
            } else {
                msg.append(EASCommonResource.getString((String)commonResource, (String)"ReferCheckError", (Locale)ctx.getLocale()));
            }
            throw new BOSException(msg.toString());
        }
        throw new BOSException((Throwable)exc);
    }

    public static String getMessage(Throwable exc, Context ctx) {
        if (exc instanceof ObjectReferedException) {
            StringBuffer msg = new StringBuffer();
            BizReference ref = (BizReference)((ObjectReferedException)exc).getReferingObject();
            if (ref != null) {
                Object[] objects = new Object[1];
                String locale = ctx.getLocale().toString();
                objects[0] = ref.getRefEntityAlias(new Locale(locale));
                String template = CASWebUtil.getResource((Context)ctx, (String)commonResource, (String)"isReferedError");
                msg.append(MessageFormat.format(template, objects));
            } else {
                msg.append(exc.getMessage());
            }
            return msg.toString();
        }
        if (exc instanceof MissMatchParticipantException) {
            return CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MissMatchParticipant");
        }
        if (exc instanceof AlreadyInProcessQueueException) {
            return CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AlreadyInProcessQueue");
        }
        if (exc instanceof MatchAssignmentException) {
            return CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFMatch");
        }
        return exc.getMessage();
    }
}

