/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.SwiftCodeFactory;
import com.kingdee.eas.fm.be.SwiftCodeInfo;
import com.kingdee.eas.fm.be.vo.SwiftCodeVO;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;

public class SwiftCodeHelper {
    public static final String strResource = "com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteFail_ByNumber";
    public static final String commonResource = "com.kingdee.eas.common.CommonResource";

    public static SwiftCodeHelper getInstance() {
        return new SwiftCodeHelper();
    }

    public SwiftCodeInfo VOToInfo(Context ctx, SwiftCodeVO vo) {
        SwiftCodeInfo info = new SwiftCodeInfo();
        if (vo == null) {
            return info;
        }
        if (vo.getId() != null) {
            try {
                info = SwiftCodeFactory.getRemoteInstance().getSwiftCodeInfo((IObjectPK)new ObjectUuidPK(vo.getId()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (vo.getNumber() != null) {
            info.setNumber(vo.getNumber());
        }
        if (vo.getBeBank() != null) {
            info.setBeBank(vo.getBeBank());
        }
        info.setDescription(vo.getDescription_l1(), LocaleUtils.getLocale((String)"l1"));
        info.setDescription(vo.getDescription_l2(), LocaleUtils.getLocale((String)"l2"));
        info.setDescription(vo.getDescription_l3(), LocaleUtils.getLocale((String)"l3"));
        return info;
    }

    public void isReferenced(IDataBase idataBase, IObjectPK[] pkArray, Context ctx) throws EASBizException {
        HashMap<IObjectPK, Exception> exceptionMap = new HashMap<IObjectPK, Exception>();
        HashMap<IObjectPK, String> numberMap = new HashMap<IObjectPK, String>();
        for (int idx = 0; idx < pkArray.length; ++idx) {
            IObjectPK curPKID = pkArray[idx];
            try {
                if (!idataBase.exists(curPKID)) continue;
                DataBaseInfo baseInfo = idataBase.getDataBaseInfo(curPKID);
                numberMap.put(curPKID, baseInfo.getNumber());
                idataBase.isReferenced(curPKID);
                continue;
            }
            catch (Exception ex) {
                exceptionMap.put(curPKID, ex);
            }
        }
        String numbetMsg = EASCommonResource.getString((String)strResource, (Locale)ctx.getLocale());
        StringBuffer errorMsg = new StringBuffer();
        Set key = exceptionMap.keySet();
        for (IObjectPK idPK : key) {
            Exception exception = (Exception)exceptionMap.get(idPK);
            errorMsg.append(MessageFormat.format(numbetMsg, numberMap.get(idPK)));
            errorMsg.append(",").append(SwiftCodeHelper.getMessage(exception, ctx)).append("\n");
        }
        if (errorMsg.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("cas100", errorMsg.toString()));
        }
    }

    public void handler(Exception exc, Context ctx) throws BOSException {
        if (exc instanceof ObjectReferedException) {
            StringBuffer msg = new StringBuffer();
            BizReference ref = (BizReference)((ObjectReferedException)exc).getReferingObject();
            if (ref != null) {
                Object[] objects = new Object[1];
                String locale = ctx.getLocale().toString();
                objects[0] = ref.getRefEntityAlias(new Locale(locale));
                String template = EASCommonResource.getString((String)commonResource, (String)"isReferedError", (Locale)ctx.getLocale());
                msg.append(MessageFormat.format(template, objects));
            } else {
                msg.append(EASCommonResource.getString((String)commonResource, (String)"ReferCheckError", (Locale)ctx.getLocale()));
            }
            throw new BOSException(msg.toString());
        }
        throw new BOSException((Throwable)exc);
    }

    public static String getMessage(Throwable exc, Context ctx) {
        if (exc instanceof ObjectReferedException) {
            StringBuffer msg = new StringBuffer();
            BizReference ref = (BizReference)((ObjectReferedException)exc).getReferingObject();
            if (ref != null) {
                Object[] objects = new Object[1];
                String locale = ctx.getLocale().toString();
                objects[0] = ref.getRefEntityAlias(new Locale(locale));
                String template = CASWebUtil.getResource((Context)ctx, (String)commonResource, (String)"isReferedError");
                msg.append(MessageFormat.format(template, objects));
            } else {
                msg.append(exc.getMessage());
            }
            return msg.toString();
        }
        if (exc instanceof MissMatchParticipantException) {
            return CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MissMatchParticipant");
        }
        if (exc instanceof AlreadyInProcessQueueException) {
            return CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AlreadyInProcessQueue");
        }
        if (exc instanceof MatchAssignmentException) {
            return CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFMatch");
        }
        return exc.getMessage();
    }
}

