/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountApplyBillFactory;
import com.kingdee.eas.basedata.assistant.AccountApplyBillInfo;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.BillStateEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.client.AbstractAccountApplyBillEditUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class AccountApplyBillEditUI
extends AbstractAccountApplyBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountApplyBillEditUI.class);
    private static final String resourcePath = "com.kingdee.eas.basedata.assistant.AccountApplyBillResource";

    @Override
    public void loadFields() {
        super.loadFields();
        this.initButtonState();
        if (!this.chkisByCurrency.isSelected()) {
            this.prmtcurrency.setEnabled(false);
        } else {
            this.prmtcurrency.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit == null || GLUtil.isCompanyUnion((CompanyOrgUnitInfo)currentFIUnit)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"nullCompanyConnotAddNew"));
            SysUtil.abort();
        }
        super.actionCopy_actionPerformed(e);
        this.billState.setSelectedItem((Object)BillStateEnum.SAVED);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit == null || GLUtil.isCompanyUnion((CompanyOrgUnitInfo)currentFIUnit)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"nullCompanyConnotAddNew"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit == null || GLUtil.isCompanyUnion((CompanyOrgUnitInfo)currentFIUnit)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"nullCompanyConnotEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        if (!this.chkisByCurrency.isSelected()) {
            this.prmtcurrency.setEnabled(false);
        } else {
            this.prmtcurrency.setEnabled(true);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit == null || GLUtil.isCompanyUnion((CompanyOrgUnitInfo)currentFIUnit)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"nullCompanyConnotRemove"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AccountApplyBillFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return null;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        AccountApplyBillInfo objectValue = new AccountApplyBillInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        objectValue.setCompany(currentCompany);
        objectValue.setCU(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit());
        Date date = new Date();
        try {
            date = DateUtil.getTimeStampDayBegin();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        objectValue.setBizDate(date);
        objectValue.setAccountType(AccountType.PAYINOUT);
        objectValue.setBillState(BillStateEnum.SAVED);
        objectValue.setIsCreateToAcc(false);
        objectValue.setIsByCurrency(true);
        try {
            if (currentCompany.getBaseCurrency() != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                objectValue.setCurrency(iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currentCompany.getBaseCurrency().getId())));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return objectValue;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        F7SelectorFactory.initBankTree((IUIObject)this, this.prmtbank, true);
        if (!this.chkisByCurrency.isSelected()) {
            this.prmtcurrency.setEnabled(false);
        } else {
            this.prmtcurrency.setEnabled(true);
        }
    }

    private void initButtonState() {
        this.btnAttachment.setEnabled(true);
        this.MenuItemAttachment.setEnabled(true);
        if (BillStateEnum.AUDITED.equals((Object)this.getBillState()) || BillStateEnum.DUMPED.equals((Object)this.getBillState())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        AccountApplyBillInfo info = (AccountApplyBillInfo)this.getDataObject();
        BillStateEnum billState = null;
        if (info.getBillState() != null) {
            billState = info.getBillState();
        }
        if (OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        } else {
            this.actionSave.setEnabled(BillStateEnum.SAVED.equals((Object)billState));
            this.actionSubmit.setEnabled(BillStateEnum.SAVED.equals((Object)billState) || BillStateEnum.SUBMITTED.equals((Object)billState));
        }
    }

    @Override
    protected void chkisByCurrency_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (this.chkisByCurrency.isSelected()) {
            this.prmtcurrency.setEnabled(true);
            if (currentCompany.getBaseCurrency() != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                this.prmtcurrency.setData((Object)iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currentCompany.getBaseCurrency().getId())));
            }
        } else {
            this.prmtcurrency.setData(null);
            this.prmtcurrency.setEnabled(false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (e != null && (e.getSource() instanceof KDWorkButton && this.btnSave.getName().equals(((KDWorkButton)e.getSource()).getName()) || e.getSource() instanceof KDMenuItem && this.btnSave.getName().equals(((KDMenuItem)e.getSource()).getName()))) {
            return;
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.pkBizDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.prmtcompany);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.prmtbank);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.prmtproperty);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.accountType);
    }

    private BillStateEnum getBillState() {
        if (this.editData.getId() == null) {
            return BillStateEnum.SAVED;
        }
        return this.editData.getBillState();
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    @Override
    protected String getTDFileName() {
        return "/FM/AC/AccountApplyBill";
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.basedata.assistant.AccountApplyTDQuery");
    }
}

