/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.client.f7.F7ContextInitializationHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BillStateEnum;
import com.kingdee.eas.basedata.assistant.client.AbstractAccountApplyBillFilterUI;
import com.kingdee.eas.basedata.assistant.client.AccountApplyBillFilterParam;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountApplyBillFilterUI
extends AbstractAccountApplyBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountApplyBillFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        boolean clearHouse;
        super.onLoad();
        this.btnCompanySelect.setVisible(false);
        this.prmtcompany.setDisplayFormat("$name$");
        this.prmtcompany.setEditFormat("$number$");
        this.prmtcompany.setCommitFormat("$number$");
        this.prmtbank.setEnabledMultiSelection(true);
        F7SelectorFactory.initBankTree((IUIObject)this, this.prmtbank);
        this.prmtcompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        NewCompanyF7 selector = F7ContextInitializationHelper.getSelectCompany((IUIObject)this, null, null, (boolean)true);
        this.prmtcompany.setSelector((KDPromptSelector)selector);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!ContextHelperFactory.getRemoteInstance().isOnlyUnion(currentCompany)) {
            this.prmtcompany.setData((Object)currentCompany);
        }
        if (!(clearHouse = BankFactory.getRemoteInstance().isClearinghouseCompany(currentCompany.getId().toString()))) {
            if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(currentCompany)) {
                this.prmtcompany.setFilterInfoProducer(FilterInfoProducerFactory.getOrgUnitFilterInfoProducer((OrgType)OrgType.Company));
            } else {
                this.prmtcompany.setEnabled(false);
            }
        }
    }

    @Override
    public boolean verify() {
        Date beginDate = (Date)this.pkBizDateFrom.getValue();
        Date endDate = (Date)this.pkBizDateTo.getValue();
        if (this.pkBizDateFrom.getValue() != null && this.pkBizDateTo.getValue() != null && beginDate.after(endDate)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"38_AccountApplyBillFilterUI"));
            this.pkBizDateFrom.requestFocus();
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    public Object getParam() {
        AccountApplyBillFilterParam filterParam = new AccountApplyBillFilterParam();
        filterParam.setBankIds(this.getIdSetFromF7(this.prmtbank));
        filterParam.setCompanyIds(this.getIdSetFromF7(this.prmtcompany));
        if (this.pkBizDateFrom.getValue() != null) {
            filterParam.setBeginDate(DateTimeUtils.truncateDate((Date)this.pkBizDateFrom.getSqlDate()));
        }
        if (this.pkBizDateTo.getValue() != null) {
            filterParam.setEndDate(DateTimeUtils.truncateDate((Date)this.pkBizDateTo.getSqlDate()));
        }
        if (this.billState.getSelectedIndex() > 0) {
            BillStateEnum state = (BillStateEnum)this.billState.getSelectedItem();
            filterParam.setState(state);
        }
        return filterParam;
    }

    @Override
    public void setParam(Object param) {
        AccountApplyBillFilterParam filterParam = (AccountApplyBillFilterParam)param;
        try {
            Set bankIds = filterParam.getBankIds();
            CoreBaseInfo[] c = RptFmClientUtil.getBaseInfoFromIdSet(bankIds);
            this.prmtbank.setData((Object)c);
            Set companyIds = filterParam.getCompanyIds();
            CoreBaseInfo[] d = RptFmClientUtil.getBaseInfoFromIdSet(companyIds);
            this.prmtcompany.setData((Object)d);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.pkBizDateFrom.setValue((Object)filterParam.getBeginDate());
        this.pkBizDateTo.setValue((Object)filterParam.getEndDate());
        if (filterParam.getState() == null) {
            this.billState.setSelectedIndex(0);
        } else {
            UIUtil.setSelectObject((KDComboBox)this.billState, (Object)filterParam.getState());
        }
    }

    @Override
    protected void init() throws Exception {
        this.billState.insertItemAt((Object)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"39_AccountApplyBillFilterUI"), 0);
        super.init();
    }

    @Override
    protected void setDefaultValue() {
        super.setDefaultValue();
        this.billState.setSelectedIndex(0);
        try {
            if (!ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany)) {
                this.prmtcompany.setData((Object)this.currentCompany);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.prmtbank.setValue(null);
        Date date = new Date();
        try {
            date = DateUtil.getTimeStampDayBegin();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.pkBizDateTo.setValue((Object)date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        this.pkBizDateFrom.setValue((Object)calendar.getTime());
    }

    @Override
    public void clear() {
        super.clear();
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.prmtcompany.setData((Object)currentCompany);
    }

    @Override
    protected Class getParamClass() {
        return AccountApplyBillFilterParam.class;
    }
}

