/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountApplyBillFactory;
import com.kingdee.eas.basedata.assistant.AccountApplyBillInfo;
import com.kingdee.eas.basedata.assistant.BillStateEnum;
import com.kingdee.eas.basedata.assistant.client.AbstractAccountApplyBillListUI;
import com.kingdee.eas.basedata.assistant.client.AccountApplyBillFilterUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.service.FMActionProxy;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.ITableSelectionHelper;
import com.kingdee.eas.framework.batchaction.service.BatchActionManager;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountApplyBillListUI
extends AbstractAccountApplyBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountApplyBillListUI.class);
    private static final String resourcePath = "com.kingdee.eas.basedata.assistant.AccountApplyBillResource";
    private CommonQueryDialog queryDlg = null;
    private AccountApplyBillFilterUI filterUI = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("preOpenDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.btnDelVoucher.setVisible(false);
        this.btnVoucher.setVisible(false);
    }

    @Override
    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        try {
            this.queryDlg = new CommonQueryDialog();
            this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDlg.setParentUIClassName(this.getClass().getName());
            this.queryDlg.setQueryObjectPK(this.mainQueryPK);
            this.queryDlg.setHeight(300);
            this.queryDlg.setWidth(500);
            this.queryDlg.addUserPanel((KDPanel)this.getFilterUI());
            this.queryDlg.setTitle(EASResource.getString((String)resourcePath, (String)"filterUITitle"));
            this.queryDlg.setShowSorter(false);
            this.queryDlg.setUiObject((IUIObject)this);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.getCause());
        }
        return this.queryDlg;
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AccountApplyBillFilterUI();
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        AccountApplyBillInfo info = this.getSelectBillInfo();
        if (info == null) {
            return;
        }
        if (BillStateEnum.AUDITED.equals((Object)info.getBillState()) || BillStateEnum.DUMPED.equals((Object)info.getBillState())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit == null || GLUtil.isCompanyUnion((CompanyOrgUnitInfo)currentFIUnit)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"unionCompanyCannotAddnew_acctApply"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit == null || GLUtil.isCompanyUnion((CompanyOrgUnitInfo)currentFIUnit)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"nullCompanyConnotEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit == null || GLUtil.isCompanyUnion((CompanyOrgUnitInfo)currentFIUnit)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"nullCompanyConnotRemove"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String isBotp = (String)this.getUIContext().get("isBotp");
        if (!"botp".equals(isBotp)) {
            super.actionQuery_actionPerformed(e);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AccountApplyBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        AccountApplyBillInfo objectValue = new AccountApplyBillInfo();
        return objectValue;
    }

    private AccountApplyBillInfo getSelectBillInfo() throws Exception {
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("isCreateToAcc"));
        AccountApplyBillInfo info = AccountApplyBillFactory.getRemoteInstance().getAccountApplyBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return info;
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList validList;
        boolean allInProcess;
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        BizEnumValueDTO billState = null;
        String isCreateToAcc = "false";
        String isCreateToInner = "false";
        HashSet<Integer> results = new HashSet<Integer>();
        for (int i = 0; i < selectRows.length; ++i) {
            row = this.tblMain.getRow(selectRows[i]);
            billState = (BizEnumValueDTO)row.getCell("billState").getValue();
            isCreateToAcc = row.getCell("isCreateToAcc").getValue() == null ? "false" : row.getCell("isCreateToAcc").getValue().toString();
            String string = isCreateToInner = row.getCell("isCreateToInner").getValue() == null ? "false" : row.getCell("isCreateToInner").getValue().toString();
            if (3 != billState.getInt() || !"false".equals(isCreateToAcc) || !"false".equals(isCreateToInner)) continue;
            results.add(billState.getInt());
        }
        if (results.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"41_AccountApplyBillListUI"));
            SysUtil.abort();
        }
        if (allInProcess = this.allInWFInstance(null, validList = this.getSelectedIdValues())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"215_AcctApplyBillListUI"));
            SysUtil.abort();
        }
        BatchActionManager actionManager = new BatchActionManager((CoreUIObject)this, ContextTypeEnum.INQUERYING);
        actionManager.setTableSelectionHelper((ITableSelectionHelper)this.getTableSelectionHelper());
        actionManager.setServiceContext(this.getServiceContext());
        actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, AccountApplyBillFactory.class);
        FMActionProxy actionProxy = new FMActionProxy(this.actionAntiAudit, "antiAudit", BatchActionEnum.UNAUDIT, actionManager);
        actionProxy.actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList validList;
        boolean allInProcess;
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        BizEnumValueDTO billState = null;
        HashSet<Integer> results = new HashSet<Integer>();
        for (int i = 0; i < selectRows.length; ++i) {
            row = this.tblMain.getRow(selectRows[i]);
            billState = (BizEnumValueDTO)row.getCell("billState").getValue();
            if (2 != billState.getInt()) continue;
            results.add(billState.getInt());
        }
        if (results.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"43_AccountApplyBillListUI"));
            SysUtil.abort();
        }
        if (allInProcess = this.allInWFInstance(null, validList = this.getSelectedIdValues())) {
            if (validList.size() == 1) {
                AccountApplyBillInfo applyBill = AccountApplyBillFactory.getRemoteInstance().getAccountApplyBillInfo((IObjectPK)new ObjectUuidPK((String)validList.get(0)));
                IPermission iPermission = PermissionFactory.getRemoteInstance();
                iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(applyBill.getCompany().getId().toString()), "bd_assistant_accountApplyBill_auditnew");
                this.actionMultiapprove_actionPerformed(e);
                this.refreshList();
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"215_AcctApplyBillListUI"));
                SysUtil.abort();
            }
        } else {
            BatchActionManager actionManager = new BatchActionManager((CoreUIObject)this, ContextTypeEnum.INQUERYING);
            actionManager.setTableSelectionHelper((ITableSelectionHelper)this.getTableSelectionHelper());
            actionManager.setServiceContext(this.getServiceContext());
            actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, AccountApplyBillFactory.class);
            FMActionProxy actionProxy = new FMActionProxy(this.actionAudit, "audit", BatchActionEnum.AUDIT, actionManager);
            actionProxy.actionPerformed(e);
        }
    }

    private boolean allInWFInstance(Context ctx, List list) throws EASBizException, BOSException {
        if (list != null && list.size() > 0) {
            ArrayList<String> hasWFList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String id = (String)list.get(i);
                if (!FMHelper.hasWFInstance(null, id)) continue;
                hasWFList.add(id);
            }
            if (!hasWFList.isEmpty() && hasWFList.size() == list.size()) {
                return true;
            }
        }
        return false;
    }

    protected void execQuery() {
        String isBotp = (String)this.getUIContext().get("isBotp");
        if ("botp".equals(isBotp)) {
            FilterInfo filter = new FilterInfo();
            Set idSet = (Set)this.getUIContext().get("idSet");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            try {
                this.mainQuery.setFilter(filter);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.btnAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.btnRefresh.setVisible(false);
            this.btnQuery.setVisible(false);
            this.btnLocate.setVisible(false);
            this.btnAudit.setVisible(false);
            this.btnAntiAudit.setVisible(false);
            this.btnAuditResult.setVisible(false);
            this.btnWorkFlowG.setVisible(false);
        }
        super.execQuery();
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.basedata.assistant.AccountApplyTDQuery");
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAttachment.setEnabled(true);
        this.MenuItemAttachment.setEnabled(true);
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
    }

    @Override
    protected String getTDFileName() {
        return "/FM/AC/AccountApplyBill";
    }

    @Override
    public void initBatchActions() {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, AccountApplyBillFactory.class);
        this.getTableSelectionHelper().setTableProperty((ListUI)this, this.mainQueryPK, this.tblMain, "id", null, "number", null, "company.id");
    }

    @Override
    public boolean isSupportedBatchActions() {
        return true;
    }
}

