/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AcctModifyApplyCollection;
import com.kingdee.eas.basedata.assistant.AcctModifyApplyEntryCollection;
import com.kingdee.eas.basedata.assistant.AcctModifyApplyEntryInfo;
import com.kingdee.eas.basedata.assistant.AcctModifyApplyFactory;
import com.kingdee.eas.basedata.assistant.AcctModifyApplyInfo;
import com.kingdee.eas.basedata.assistant.AcctModifyBillStateEnum;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CountryCollection;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.DestroyAccountApplyCollection;
import com.kingdee.eas.basedata.assistant.DestroyAccountApplyFactory;
import com.kingdee.eas.basedata.assistant.ModifyFieldEnum;
import com.kingdee.eas.basedata.assistant.client.AbstractAcctModifyApplyEditUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.dynbusiness.condition.InterfaceItem;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent;
import com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AcctModifyApplyEditUI
extends AbstractAcctModifyApplyEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(AcctModifyApplyEditUI.class);
    private IContextHelper contextHelp = ContextHelperFactory.getRemoteInstance();
    private static final String F7_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7BankQuery";
    private static boolean checkEntrys = false;

    @Override
    public void onLoad() throws Exception {
        this.initTable();
        super.onLoad();
        if (this.getUIContext().get("bankAcctInfo") != null) {
            this.loadFields();
            this.prmtAccountNumber.setEnabled(false);
            this.btnAddNew.setEnabled(false);
        }
    }

    protected void initTable() {
        this.kdtEntrys.checkParsed();
        this.initUI();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        AcctModifyApplyEditUI.initNumber((CoreBaseInfo)this.editData, this.txtNumber, this.editData.getModifyCompany().getId().toString());
        this.prmtAccountNumber.setRequired(true);
        this.pkApplyDate.setRequired(true);
        if (this.getOprtState().equals(OprtState.EDIT) && AcctModifyBillStateEnum.SUBMITTED.equals((Object)this.editData.getBillState())) {
            this.btnSave.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnSave.setEnabled(true);
        } else if ((this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) && (AcctModifyBillStateEnum.AUDITED.equals((Object)this.editData.getBillState()) || AcctModifyBillStateEnum.CANCELED.equals((Object)this.editData.getBillState()) || AcctModifyBillStateEnum.CONFIRMED.equals((Object)this.editData.getBillState()))) {
            this.btnSave.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
        }
        this.btnCreateFrom.setVisible(false);
        this.btnCreateTo.setVisible(false);
        if (AcctModifyApplyEditUI.hasNumber((CoreBaseInfo)this.editData, this.currentCompany.getId().toString())) {
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
        if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals("FINDVIEW")) {
            this.txtNumber.setEnabled(false);
            this.setEntrys();
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.prmtAccountNumber.setEnabled(true);
        }
    }

    private void setEntrys() {
        int rowCount = this.kdtEntrys.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            KDTDefaultCellEditor editor;
            KDCheckBox prmt;
            String postValue;
            IRow row = this.kdtEntrys.getRow(i);
            if (row.getCell("modifyField").getValue() == null) continue;
            String preValue = row.getCell("preValue").getValue() == null ? null : row.getCell("preValue").getValue().toString();
            String string = postValue = row.getCell("postValue").getValue() == null ? null : row.getCell("postValue").getValue().toString();
            if (row.getCell("modifyField").getValue().equals((Object)ModifyFieldEnum.IS_BY_CUR) || row.getCell("modifyField").getValue().equals((Object)ModifyFieldEnum.IS_ONLY_READ) || row.getCell("modifyField").getValue().equals((Object)ModifyFieldEnum.IS_SET_BANK_INT)) {
                if (preValue != null && preValue.equals("true")) {
                    prmt = new KDCheckBox();
                    editor = new KDTDefaultCellEditor((JCheckBox)prmt);
                    row.getCell("preValue").setEditor((ICellEditor)editor);
                    row.getCell("preValue").setValue((Object)true);
                } else if (preValue == null || preValue.equals("false")) {
                    prmt = new KDCheckBox();
                    editor = new KDTDefaultCellEditor((JCheckBox)prmt);
                    row.getCell("preValue").setEditor((ICellEditor)editor);
                    row.getCell("preValue").setValue((Object)false);
                }
                if (postValue != null && postValue.equals("true")) {
                    prmt = new KDCheckBox();
                    editor = new KDTDefaultCellEditor((JCheckBox)prmt);
                    row.getCell("postValue").setEditor((ICellEditor)editor);
                    row.getCell("postValue").setValue((Object)true);
                } else if (postValue == null || postValue.equals("false")) {
                    prmt = new KDCheckBox();
                    editor = new KDTDefaultCellEditor((JCheckBox)prmt);
                    row.getCell("postValue").setEditor((ICellEditor)editor);
                    row.getCell("postValue").setValue((Object)false);
                }
            }
            if (row.getCell("modifyField").getValue().equals((Object)ModifyFieldEnum.MAX_PAY_AMT)) {
                if (preValue != null) {
                    this.initMaxPayAmount(row, "preValue", new BigDecimal(row.getCell("preValue").getValue().toString()), false);
                }
                if (postValue != null) {
                    this.initMaxPayAmount(row, "postValue", new BigDecimal(row.getCell("postValue").getValue().toString()), false);
                }
            }
            row.getCell("preValue").getStyleAttributes().setLocked(true);
            try {
                if (row.getCell("postValueId") != null) {
                    if (row.getCell("modifyField").getValue().equals((Object)ModifyFieldEnum.BANK)) {
                        BankInfo bankInfo = null;
                        if (row.getCell("postValueId").getValue() != null) {
                            bankInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(row.getCell("postValueId").getValue().toString()));
                        }
                        this.initBank(i, bankInfo, true);
                        row.getCell("postValue").setValue(bankInfo);
                    } else if (row.getCell("modifyField").getValue().equals((Object)ModifyFieldEnum.COUNTRY)) {
                        CountryInfo countryInfo = CountryFactory.getRemoteInstance().getCountryInfo((IObjectPK)new ObjectUuidPK(row.getCell("postValueId").getValue().toString()));
                        this.initCountry(row, countryInfo, true);
                        row.getCell("postValue").setValue((Object)countryInfo);
                    } else if (row.getCell("modifyField").getValue().equals((Object)ModifyFieldEnum.OPEN_AREA)) {
                        OpenAreaInfo openAreaInfo = null;
                        if (row.getCell("postValueId").getValue() != null) {
                            openAreaInfo = OpenAreaFactory.getRemoteInstance().getOpenAreaInfo((IObjectPK)new ObjectUuidPK(row.getCell("postValueId").getValue().toString()));
                        }
                        this.initOpenArea(row, openAreaInfo, true);
                        row.getCell("postValue").setValue(openAreaInfo);
                    }
                }
                if (row.getCell("modifyField").getValue().equals((Object)ModifyFieldEnum.BANK_INT_TYPE)) {
                    AccountBankInfo bankAcct = (AccountBankInfo)this.prmtAccountNumber.getValue();
                    bankAcct = this.getAccountBankInfo(bankAcct.getId());
                    this.initBankInterfaceType(row, null, bankAcct);
                    continue;
                }
                if (row.getCell("modifyField").getValue().equals((Object)ModifyFieldEnum.MAX_PAY_AMT)) {
                    if (preValue != null) {
                        this.initMaxPayAmount(row, "preValue", new BigDecimal(row.getCell("preValue").getValue().toString()), false);
                    }
                    if (postValue != null) {
                        this.initMaxPayAmount(row, "postValue", new BigDecimal(row.getCell("postValue").getValue().toString()), false);
                        continue;
                    }
                    this.initMaxPayAmount(row, "postValue", Constants.ZERO, false);
                    continue;
                }
                if (!row.getCell("modifyField").getValue().equals((Object)ModifyFieldEnum.IS_SET_BANK_INT)) continue;
                prmt = new KDCheckBox();
                editor = new KDTDefaultCellEditor((JCheckBox)prmt);
                row.getCell("postValue").setEditor((ICellEditor)editor);
                prmt.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent arg0) {
                        if (arg0.getStateChange() == 1) {
                            AcctModifyApplyEditUI.this.initInterfaceField();
                        } else {
                            AcctModifyApplyEditUI.this.removeInterfaceField();
                        }
                    }
                });
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setEmpty();
    }

    public static void initNumber(CoreBaseInfo info, KDTextField txtField, String companyId) {
        if (!EmptyUtil.isEmpty((String)info.getString("number"))) {
            txtField.setEnabled(false);
            return;
        }
        boolean rst = AcctModifyApplyEditUI.hasNumber(info, companyId);
        if (rst) {
            txtField.setEditable(false);
            txtField.setEnabled(false);
            txtField.setRequired(false);
            String number = AcctModifyApplyEditUI.getDispNumber(info, companyId);
            if (!EmptyUtil.isEmpty((String)number)) {
                info.setString("number", number);
                txtField.setText(number);
            }
            if (AcctModifyApplyEditUI.isModifiable(info, companyId)) {
                txtField.setEditable(true);
                txtField.setEnabled(true);
                txtField.setRequired(true);
            }
        } else {
            txtField.setEnabled(true);
            txtField.setEditable(true);
            txtField.setRequired(true);
        }
    }

    public static boolean isModifiable(CoreBaseInfo info, String companyId) {
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isModifiable((IObjectValue)info, companyId);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return result;
    }

    private void initUI() {
        KDComboBox prmt = new KDComboBox();
        this.initModifyField(prmt);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)prmt);
        this.kdtEntrys.getColumn("modifyField").setEditor((ICellEditor)editor);
        this.kdtEntrys_detailPanel.addRemoveListener(new IDetailPanelListener(){

            public void beforeEvent(DetailPanelEvent event) throws Exception {
                int rowIndex = AcctModifyApplyEditUI.this.kdtEntrys.getSelectManager().getActiveRowIndex();
                if (AcctModifyApplyEditUI.this.kdtEntrys.getRow(rowIndex).getCell("modifyField").getValue() != null && AcctModifyApplyEditUI.this.kdtEntrys.getRow(rowIndex).getCell("modifyField").getValue().equals((Object)ModifyFieldEnum.IS_SET_BANK_INT)) {
                    AcctModifyApplyEditUI.this.removeInterfaceField();
                }
            }

            public void afterEvent(DetailPanelEvent event) throws Exception {
            }
        });
        this.kdtEntrys_detailPanel.addAddListener(new IDetailPanelListener(){

            public void beforeEvent(DetailPanelEvent event) throws Exception {
            }

            public void afterEvent(DetailPanelEvent event) throws Exception {
                AcctModifyApplyEditUI.this.setEmpty();
            }
        });
        this.kdtEntrys_detailPanel.addInsertListener(new IDetailPanelListener(){

            public void beforeEvent(DetailPanelEvent event) throws Exception {
            }

            public void afterEvent(DetailPanelEvent event) throws Exception {
                AcctModifyApplyEditUI.this.setEmpty();
            }
        });
    }

    private void setEmpty() {
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            if (this.kdtEntrys.getRow(i).getCell("modifyField").getValue() != null) continue;
            this.kdtEntrys.getRow(i).getCell("preValue").getStyleAttributes().setLocked(true);
            this.kdtEntrys.getRow(i).getCell("postValue").getStyleAttributes().setLocked(true);
            this.kdtEntrys.getRow(i).getCell("description").getStyleAttributes().setLocked(true);
        }
    }

    private void initModifyField(KDComboBox modifyField) {
        modifyField.addItems(ModifyFieldEnum.getEnumList().toArray());
        modifyField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    int rowIndex = AcctModifyApplyEditUI.this.kdtEntrys.getSelectManager().getActiveRowIndex();
                    if (e.getStateChange() == 1) {
                        if (!AcctModifyApplyEditUI.this.exist(e, rowIndex)) {
                            AcctModifyApplyEditUI.this.modifyField_itemStateChanged(e);
                        } else {
                            AcctModifyApplyEditUI.this.kdtEntrys.getRow(rowIndex).getCell("modifyField").setValue((Object)"");
                            AcctModifyApplyEditUI.this.kdtEntrys.getRow(rowIndex).getCell("preValue").setValue((Object)"");
                            AcctModifyApplyEditUI.this.kdtEntrys.getRow(rowIndex).getCell("postValue").setValue((Object)"");
                            AcctModifyApplyEditUI.this.kdtEntrys.getRow(rowIndex).getCell("description").setValue((Object)"");
                        }
                    }
                }
                catch (Exception e1) {
                    AcctModifyApplyEditUI.this.handUIException(e1);
                }
            }
        });
    }

    private void modifyField_itemStateChanged(ItemEvent e) throws Exception {
        int rowIndex = this.kdtEntrys.getSelectManager().getActiveRowIndex();
        AccountBankInfo abInfoTmp = (AccountBankInfo)this.prmtAccountNumber.getValue();
        if (abInfoTmp == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"201_AcctModifyApplyEditUI"));
            this.kdtEntrys.getRow(rowIndex).getCell("modifyField").setValue((Object)"");
            SysUtil.abort();
        }
        abInfoTmp = this.getAccountBankInfo(abInfoTmp.getId());
        this.kdtEntrys.getRow(rowIndex).getCell("preValue").setValue(null);
        this.kdtEntrys.getRow(rowIndex).getCell("postValue").setValue(null);
        this.kdtEntrys.getRow(rowIndex).getCell("description").setValue(null);
        this.kdtEntrys.getRow(rowIndex).getCell("preValue").getStyleAttributes().setLocked(false);
        this.kdtEntrys.getRow(rowIndex).getCell("postValue").getStyleAttributes().setLocked(false);
        this.kdtEntrys.getRow(rowIndex).getCell("description").getStyleAttributes().setLocked(false);
        if (e.getItem().equals((Object)ModifyFieldEnum.BANK_ACCT_NUM)) {
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").setValue((Object)abInfoTmp.getBankAccountNumber());
            this.kdtEntrys.getRow(rowIndex).getCell("preValueId").getFormattedStyleAttributes().setLocked(true);
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").getFormattedStyleAttributes().setLocked(true);
            KDTextField prmt = new KDTextField();
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)prmt);
            this.kdtEntrys.getRow(rowIndex).getCell("postValue").setEditor((ICellEditor)editor);
        } else if (e.getItem().equals((Object)ModifyFieldEnum.BANK)) {
            this.initBank(rowIndex, abInfoTmp.getBank(), false);
            this.kdtEntrys.getRow(rowIndex).getCell("preValueId").setValue((Object)abInfoTmp.getBank().getId().toString());
            this.initBank(rowIndex, abInfoTmp.getBank(), true);
        } else if (e.getItem().equals((Object)ModifyFieldEnum.NAME)) {
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").setValue((Object)abInfoTmp.getName());
            this.kdtEntrys.getRow(rowIndex).getCell("preValueId").getFormattedStyleAttributes().setLocked(true);
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").getFormattedStyleAttributes().setLocked(true);
            KDTextField prmt = new KDTextField();
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)prmt);
            this.kdtEntrys.getRow(rowIndex).getCell("postValue").setEditor((ICellEditor)editor);
        } else if (e.getItem().equals((Object)ModifyFieldEnum.IS_SET_BANK_INT)) {
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").setValue((Object)abInfoTmp.isIsSetBankInterface());
            this.kdtEntrys.getRow(rowIndex).getCell("preValueId").getFormattedStyleAttributes().setLocked(true);
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").getFormattedStyleAttributes().setLocked(true);
            KDCheckBox prmt = new KDCheckBox();
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)prmt);
            this.kdtEntrys.getRow(rowIndex).getCell("postValue").setEditor((ICellEditor)editor);
            prmt.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (arg0.getStateChange() == 1) {
                        AcctModifyApplyEditUI.this.initInterfaceField();
                    } else {
                        AcctModifyApplyEditUI.this.removeInterfaceField();
                    }
                }
            });
        } else if (e.getItem().equals((Object)ModifyFieldEnum.IS_BY_CUR)) {
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").setValue(null);
            this.kdtEntrys.getRow(rowIndex).getCell("postValue").setValue(null);
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").setValue((Object)abInfoTmp.isIsByCurrency());
            this.kdtEntrys.getRow(rowIndex).getCell("preValueId").getFormattedStyleAttributes().setLocked(true);
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").getFormattedStyleAttributes().setLocked(true);
            KDCheckBox prmt = new KDCheckBox();
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)prmt);
            this.kdtEntrys.getRow(rowIndex).getCell("postValue").setEditor((ICellEditor)editor);
        } else if (e.getItem().equals((Object)ModifyFieldEnum.IS_ONLY_READ)) {
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").setValue((Object)abInfoTmp.isIsOnlyRead());
            KDCheckBox prmt = new KDCheckBox();
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)prmt);
            this.kdtEntrys.getRow(rowIndex).getCell("postValue").setEditor((ICellEditor)editor);
        } else if (e.getItem().equals((Object)ModifyFieldEnum.BANK_INT_TYPE)) {
            this.initBankInterfaceType(this.kdtEntrys.getRow(rowIndex), null, abInfoTmp);
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").setValue((Object)abInfoTmp.getBankInterFace());
            this.kdtEntrys.getRow(rowIndex).getCell("preValueId").setValue((Object)abInfoTmp.getBankInterFaceID());
            this.kdtEntrys.getRow(rowIndex).getCell("postValue").setValue((Object)abInfoTmp.getBankInterFace());
            this.kdtEntrys.getRow(rowIndex).getCell("postValueId").setValue((Object)abInfoTmp.getBankInterFaceID());
        } else if (e.getItem().equals((Object)ModifyFieldEnum.ACCT_NAME)) {
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").setValue((Object)abInfoTmp.getAcctName());
            this.kdtEntrys.getRow(rowIndex).getCell("preValue").getFormattedStyleAttributes().setLocked(true);
            KDTextField prmt = new KDTextField();
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)prmt);
            this.kdtEntrys.getRow(rowIndex).getCell("postValue").setEditor((ICellEditor)editor);
            this.kdtEntrys.getRow(rowIndex).getCell("postValue").setValue((Object)abInfoTmp.getAcctName());
        } else if (e.getItem().equals((Object)ModifyFieldEnum.COUNTRY)) {
            this.initCountry(this.kdtEntrys.getRow(rowIndex), abInfoTmp.getCountry(), false);
            this.initCountry(this.kdtEntrys.getRow(rowIndex), abInfoTmp.getCountry(), true);
        } else if (e.getItem().equals((Object)ModifyFieldEnum.OPEN_AREA)) {
            this.initOpenArea(this.kdtEntrys.getRow(rowIndex), abInfoTmp.getOpenArea(), false);
            this.initOpenArea(this.kdtEntrys.getRow(rowIndex), abInfoTmp.getOpenArea(), true);
        } else if (e.getItem().equals((Object)ModifyFieldEnum.MAX_PAY_AMT)) {
            this.initMaxPayAmount(this.kdtEntrys.getRow(rowIndex), "preValue", abInfoTmp.getMaxPayAmount(), true);
            this.initMaxPayAmount(this.kdtEntrys.getRow(rowIndex), "postValue", Constants.ZERO, false);
        }
    }

    private void initMaxPayAmount(IRow row, String field, BigDecimal value, boolean lockFlag) {
        KDFormattedTextField txtmaxPayAmount = new KDFormattedTextField();
        txtmaxPayAmount.setDataType(1);
        txtmaxPayAmount.setSupportedEmpty(true);
        txtmaxPayAmount.setPrecision(2);
        txtmaxPayAmount.setRemoveingZeroInDispaly(false);
        txtmaxPayAmount.setHorizontalAlignment(4);
        txtmaxPayAmount.setMaximumValue((Comparable)new BigDecimal("9999999999999.99"));
        txtmaxPayAmount.setMinimumValue((Comparable)Constants.ZERO);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtmaxPayAmount);
        row.getCell(field).setEditor((ICellEditor)editor);
        if (value != null && !value.equals(Constants.ZERO)) {
            row.getCell(field).setValue((Object)value);
        }
        row.getCell(field).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(field).getStyleAttributes().setNumberFormat("0.00");
        if (lockFlag) {
            row.getCell(field).getStyleAttributes().setLocked(true);
        }
    }

    private boolean exist(ItemEvent e, int rowIndex) {
        this.kdtEntrys.getEditManager().stopEditing();
        if (this.kdtEntrys.getRowCount() > 0) {
            for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
                if (e.getItem() == "" || rowIndex == i || this.kdtEntrys.getRow(i).getCell("modifyField").getValue() == null || !this.kdtEntrys.getRow(i).getCell("modifyField").getValue().equals(e.getItem())) continue;
                MsgBox.showWarning((Component)((Object)this), (String)"\u6709\u91cd\u590d\u9879\u4e0d\u80fd\u6dfb\u52a0");
                return true;
            }
        }
        return false;
    }

    private void initInterfaceField() {
        int i;
        ModifyFieldEnum[] modifyFields = new ModifyFieldEnum[]{ModifyFieldEnum.IS_ONLY_READ, ModifyFieldEnum.BANK_INT_TYPE, ModifyFieldEnum.ACCT_NAME, ModifyFieldEnum.COUNTRY, ModifyFieldEnum.OPEN_AREA, ModifyFieldEnum.MAX_PAY_AMT};
        HashMap<ModifyFieldEnum, ModifyFieldEnum> modifyFieldsMap = new HashMap<ModifyFieldEnum, ModifyFieldEnum>();
        AccountBankInfo abInfoTmp = (AccountBankInfo)this.prmtAccountNumber.getValue();
        try {
            abInfoTmp = this.getAccountBankInfo(abInfoTmp.getId());
        }
        catch (Exception e) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"201_AcctModifyApplyEditUI"));
            SysUtil.abort();
        }
        for (int i2 = 0; i2 < modifyFields.length; ++i2) {
            modifyFieldsMap.put(modifyFields[i2], modifyFields[i2]);
        }
        boolean flag = true;
        for (i = this.kdtEntrys.getRowCount() - 1; i >= 0; --i) {
            if (modifyFieldsMap.get(this.kdtEntrys.getRow(i).getCell("modifyField").getValue()) == null) continue;
            flag = false;
            break;
        }
        if (flag) {
            for (i = 0; i < modifyFields.length; ++i) {
                IRow row = this.kdtEntrys.addRow();
                row.getCell("modifyField").setValue((Object)modifyFields[i]);
                this.setModifyFieldValue(row, abInfoTmp, modifyFields[i]);
                row.getCell("modifyField").getFormattedStyleAttributes().setLocked(true);
                row.getCell("preValue").getFormattedStyleAttributes().setLocked(true);
            }
        }
    }

    private void removeInterfaceField() {
        int i;
        this.kdtEntrys.getEditManager().stopEditing();
        ModifyFieldEnum[] modifyFields = new ModifyFieldEnum[]{ModifyFieldEnum.IS_ONLY_READ, ModifyFieldEnum.BANK_INT_TYPE, ModifyFieldEnum.ACCT_NAME, ModifyFieldEnum.COUNTRY, ModifyFieldEnum.OPEN_AREA, ModifyFieldEnum.MAX_PAY_AMT};
        HashMap<ModifyFieldEnum, ModifyFieldEnum> modifyFieldsMap = new HashMap<ModifyFieldEnum, ModifyFieldEnum>();
        for (i = 0; i < modifyFields.length; ++i) {
            modifyFieldsMap.put(modifyFields[i], modifyFields[i]);
        }
        for (i = this.kdtEntrys.getRowCount() - 1; i >= 0; --i) {
            if (modifyFieldsMap.get(this.kdtEntrys.getRow(i).getCell("modifyField").getValue()) == null) continue;
            this.kdtEntrys.removeRow(i);
        }
    }

    private void setModifyFieldValue(IRow row, AccountBankInfo abInfoTmp, ModifyFieldEnum modifyFieldEnum) {
        if (modifyFieldEnum.equals((Object)ModifyFieldEnum.IS_ONLY_READ)) {
            row.getCell("preValue").setValue((Object)abInfoTmp.isIsOnlyRead());
            KDCheckBox prmt = new KDCheckBox();
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)prmt);
            row.getCell("postValue").setEditor((ICellEditor)editor);
        } else if (modifyFieldEnum.equals((Object)ModifyFieldEnum.BANK_INT_TYPE)) {
            row.getCell("preValue").setValue((Object)abInfoTmp.getBankInterFace());
            row.getCell("preValueId").setValue((Object)abInfoTmp.getBankInterFaceID());
            this.initBankInterfaceType(row, null, abInfoTmp);
        } else if (modifyFieldEnum.equals((Object)ModifyFieldEnum.ACCT_NAME)) {
            row.getCell("preValue").setValue((Object)abInfoTmp.getAcctName());
            row.getCell("postValue").setValue((Object)abInfoTmp.getCompany().getName());
        } else if (modifyFieldEnum.equals((Object)ModifyFieldEnum.COUNTRY)) {
            this.initCountry(row, abInfoTmp.getCountry(), false);
            this.initCountry(row, abInfoTmp.getCountry(), true);
        } else if (modifyFieldEnum.equals((Object)ModifyFieldEnum.OPEN_AREA)) {
            this.initOpenArea(row, abInfoTmp.getOpenArea(), false);
            this.initOpenArea(row, null, true);
        } else if (modifyFieldEnum.equals((Object)ModifyFieldEnum.MAX_PAY_AMT)) {
            this.initMaxPayAmount(row, "preValue", abInfoTmp.getMaxPayAmount(), false);
            this.initMaxPayAmount(row, "postValue", Constants.ZERO, false);
        }
    }

    private void initBankInterfaceType(final IRow row, BankInterfaceTypeEnum bankInterfaceType, AccountBankInfo bankAcct) {
        KDComboBox prmt = new KDComboBox();
        Object[] bankCert = null;
        try {
            String bank = bankAcct.getBank().getName();
            String company = bankAcct.getCompany().getId().toString();
            bankCert = BankFacadeFactory.getRemoteInstance().getBankCert(bank, company);
        }
        catch (Exception e) {
            MsgBox.showWarning((String)e.getMessage());
        }
        prmt.removeAllItems();
        prmt.addItems(bankCert);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)prmt);
        row.getCell("postValue").setEditor((ICellEditor)editor);
        prmt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (e.getItem() instanceof BankInterface) {
                        row.getCell("postValueId").setValue((Object)((BankInterface)e.getItem()).getNumber());
                    }
                }
                catch (Exception e1) {
                    AcctModifyApplyEditUI.this.handUIException(e1);
                }
            }
        });
    }

    private static void initBankInterface(KDComboBox cmp, String bank) throws Exception {
        Object[] bankCert = null;
        try {
            InterfaceItem item = new InterfaceItem("BankFacade", "A2F61E6C", "getBankCert", "facade", new Class[]{String.class}, null);
            bankCert = (Object[])item.doInvoke(null, new Object[]{bank});
        }
        catch (Exception e) {
            MsgBox.showWarning((String)e.getMessage());
        }
        cmp.removeAllItems();
        cmp.addItems(bankCert);
    }

    private void initOpenArea(final IRow row, OpenAreaInfo openArea, boolean enable) {
        KDBizPromptBox prmt = new KDBizPromptBox();
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        prmt.setQueryInfo("com.kingdee.eas.fm.be.F7OpenAreaQuery");
        prmt.setVisible(true);
        prmt.setEditable(true);
        prmt.setDisplayFormat("$number$ $name$");
        prmt.setEditFormat("$number$ $name$");
        prmt.setCommitFormat("$number$");
        prmt.setEntityViewInfo(evi);
        prmt.setEnabledMultiSelection(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmt);
        row.getCell("postValue").setEditor((ICellEditor)editor);
        if (enable) {
            row.getCell("postValue").setValue(null);
            row.getCell("postValue").getFormattedStyleAttributes().setLocked(false);
            prmt.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    OpenAreaInfo openArea = (OpenAreaInfo)eventObj.getNewValue();
                    if (null == openArea) {
                        return;
                    }
                    row.getCell("postValueId").setValue((Object)openArea.getId().toString());
                }
            });
        } else {
            row.getCell("preValue").setValue((Object)openArea);
            row.getCell("preValue").getFormattedStyleAttributes().setLocked(true);
        }
    }

    private void initCountry(final IRow row, CountryInfo countryInfo, boolean enable) {
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"C01"));
        evi1.setFilter(filter);
        CountryCollection col = null;
        try {
            col = CountryFactory.getRemoteInstance().getCountryCollection(evi1);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        KDBizPromptBox prmt = new KDBizPromptBox();
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        prmt.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CountryQuery");
        prmt.setVisible(true);
        prmt.setEditable(true);
        prmt.setDisplayFormat("$number$ $name$");
        prmt.setEditFormat("$number$ $name$");
        prmt.setCommitFormat("$number$");
        prmt.setEntityViewInfo(evi);
        prmt.setEnabledMultiSelection(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmt);
        row.getCell("postValue").setEditor((ICellEditor)editor);
        if (enable) {
            if (countryInfo == null || countryInfo.isEmpty()) {
                if (col.size() > 0) {
                    row.getCell("postValue").setValue((Object)col.get(0));
                }
                row.getCell("postValueId").setValue((Object)col.get(0).getId().toString());
            }
            row.getCell("postValue").getFormattedStyleAttributes().setLocked(false);
            prmt.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    CountryInfo countryInfo = (CountryInfo)eventObj.getNewValue();
                    if (null == countryInfo) {
                        return;
                    }
                    row.getCell("postValueId").setValue((Object)countryInfo.getId().toString());
                }
            });
        } else {
            row.getCell("preValue").setValue((Object)countryInfo);
            row.getCell("preValue").getFormattedStyleAttributes().setLocked(true);
        }
    }

    private void initBank(final int index, BankInfo bankInfo, boolean enable) {
        KDBizPromptBox prmt = new KDBizPromptBox();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        if (!EmptyUtil.isEmpty((CoreBaseInfo)bankInfo)) {
            filter.getFilterItems().add(new FilterItemInfo("inGroup", (Object)bankInfo.isInGroup()));
        }
        evi.setFilter(filter);
        prmt.setQueryInfo(F7_BANK_QUERY);
        prmt.setVisible(true);
        prmt.setEditable(true);
        prmt.setDisplayFormat("$number$ $name$");
        prmt.setEditFormat("$number$ $name$");
        prmt.setCommitFormat("$number$");
        prmt.setEntityViewInfo(evi);
        prmt.setEnabledMultiSelection(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmt);
        this.kdtEntrys.getRow(index).getCell("postValue").setEditor((ICellEditor)editor);
        if (enable) {
            this.kdtEntrys.getRow(index).getCell("postValue").setValue(null);
            this.kdtEntrys.getRow(index).getCell("postValue").getFormattedStyleAttributes().setLocked(false);
            prmt.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    BankInfo bankInfo = (BankInfo)eventObj.getNewValue();
                    if (null == bankInfo) {
                        return;
                    }
                    AcctModifyApplyEditUI.this.kdtEntrys.getRow(index).getCell("postValueId").setValue((Object)bankInfo.getId().toString());
                }
            });
        } else {
            this.kdtEntrys.getRow(index).getCell("preValue").setValue((Object)bankInfo);
            this.kdtEntrys.getRow(index).getCell("preValue").getFormattedStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void prmtAccountNumber_willShow(SelectorEvent e) throws Exception {
        CompanyOrgUnitInfo company = this.contextHelp.getCurrentCompany();
        if (company == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"198_AcctModifyApplyEditUI"));
            this.prmtAccountNumber.requestFocus();
            e.setCanceled(true);
            return;
        }
        FilterUtil.mergerFilterItem(this.prmtAccountNumber, new FilterItemInfo("company.id", (Object)company.getId().toString()));
        FilterUtil.mergerFilterItem(this.prmtAccountNumber, new FilterItemInfo("shareType", (Object)new Integer(0), CompareType.EQUALS));
        FilterUtil.mergerFilterItem(this.prmtAccountNumber, new FilterItemInfo("isClosed", (Object)false));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("operDate"));
        sic.add(new SelectorItemInfo("isClosed"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("accountType"));
        sic.add(new SelectorItemInfo("acctName"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("shareType"));
        sic.add(new SelectorItemInfo("bank.inGroup"));
        this.prmtAccountNumber.setSelectorCollection(sic);
        this.prmtAccountNumber.getQueryAgent().resetRuntimeEntityView();
    }

    private static String getDispNumber(CoreBaseInfo info, String companyId) {
        String number = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (codingRuleManager.isAddView((IObjectValue)info, companyId) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                number = codingRuleManager.getNumber((IObjectValue)info, companyId);
            }
        }
        catch (BOSException bOSException) {
        }
        catch (CodingRuleException codingRuleException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return number;
    }

    public static boolean hasNumber(CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist((IObjectValue)info, companyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("billState");
        return sic;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AcctModifyApplyFactory.getRemoteInstance();
    }

    @Override
    protected void initDataStatus() {
        super.initDataStatus();
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        AcctModifyApplyInfo info = (AcctModifyApplyInfo)this.getDataObject();
        AcctModifyBillStateEnum billState = null;
        if (info.getBillState() != null) {
            billState = info.getBillState();
        }
        if (OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        } else {
            this.actionSave.setEnabled(AcctModifyBillStateEnum.SAVED.equals((Object)billState));
            this.actionSubmit.setEnabled(AcctModifyBillStateEnum.SAVED.equals((Object)billState) || AcctModifyBillStateEnum.SUBMITTED.equals((Object)billState));
        }
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        this.verifyNumber();
        if (checkEntrys) {
            if (this.editData.getEntrys().size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"200_AcctModifyApplyEditUI"));
                SysUtil.abort();
            } else {
                this.checkEntrys(this.editData.getEntrys());
            }
        }
    }

    private void verifyNumber() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.editData.getNumber()));
        if (this.getOprtState().equals(OprtState.EDIT)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        evi.setFilter(filter);
        DestroyAccountApplyCollection coll = DestroyAccountApplyFactory.getRemoteInstance().getDestroyAccountApplyCollection(evi);
        if (null != coll && coll.size() > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"91_DestroyAccountApplyEditUI"));
            SysUtil.abort();
        }
    }

    private AcctModifyApplyCollection getAcctModifyApplyCollection(String id) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)id));
        evi.setFilter(filter);
        return AcctModifyApplyFactory.getRemoteInstance().getAcctModifyApplyCollection(evi);
    }

    @Override
    protected IObjectValue createNewData() {
        AcctModifyApplyInfo info = new AcctModifyApplyInfo();
        info.setApplyDate(DateUtil.getDayBegin());
        info.setBizDate(DateUtil.getDayBegin());
        info.setBillState(AcctModifyBillStateEnum.SAVED);
        info.setModifyCompany(this.contextHelp.getCurrentCompany());
        info.setCreator(this.contextHelp.getCurrentUser());
        AccountBankInfo acctBank = (AccountBankInfo)this.getUIContext().get("bankAcctInfo");
        if (acctBank != null) {
            info.setAccountBank(acctBank);
            info.setAcctBankNumber(acctBank.getBankAccountNumber());
            info.setCompany(acctBank.getCompany());
            info.setBank(acctBank.getBank());
        }
        return info;
    }

    private AccountBankInfo getAccountBankInfo(BOSUuid id) throws Exception {
        if (null == id || "".equals(id)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("openDate"));
        sic.add(new SelectorItemInfo("closeDate"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("property.name"));
        sic.add(new SelectorItemInfo("isSetBankInterface"));
        sic.add(new SelectorItemInfo("ctrlStrategy.name"));
        sic.add(new SelectorItemInfo("openArea.name"));
        sic.add(new SelectorItemInfo("InnerAcct.name"));
        sic.add(new SelectorItemInfo("isUseGroupPayment"));
        sic.add(new SelectorItemInfo("isClosed"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isDCPay"));
        sic.add(new SelectorItemInfo("isReckoning"));
        sic.add(new SelectorItemInfo("simpleCode"));
        sic.add(new SelectorItemInfo("agencyCompany.number"));
        sic.add(new SelectorItemInfo("isDefaultReck"));
        sic.add(new SelectorItemInfo("isOnlyRead"));
        sic.add(new SelectorItemInfo("maxPayAmount"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("isMotherAccount"));
        sic.add(new SelectorItemInfo("isByCurrency"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("bankVersion"));
        sic.add(new SelectorItemInfo("bankCert"));
        sic.add(new SelectorItemInfo("acctName"));
        sic.add(new SelectorItemInfo("bankInterFace"));
        sic.add(new SelectorItemInfo("bankInterFaceID"));
        sic.add(new SelectorItemInfo("isForEDrafOnly"));
        sic.add(new SelectorItemInfo("isVirtualAcct"));
        sic.add(new SelectorItemInfo("subAccount.name"));
        sic.add(new SelectorItemInfo("shareType"));
        sic.add(new SelectorItemInfo("shareAcct.name"));
        sic.add(new SelectorItemInfo("acctManageAmount"));
        sic.add(new SelectorItemInfo("accountBankType"));
        sic.add(new SelectorItemInfo("bank.inGroup"));
        sic.add(new SelectorItemInfo("bankInterfaceType"));
        sic.add(new SelectorItemInfo("openArea.id"));
        sic.add(new SelectorItemInfo("openArea.number"));
        sic.add(new SelectorItemInfo("country.id"));
        sic.add(new SelectorItemInfo("country.name"));
        sic.add(new SelectorItemInfo("country.number"));
        return AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    @Override
    protected void prmtAccountNumber_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo abInfo = (AccountBankInfo)this.prmtAccountNumber.getValue();
        if (null == abInfo) {
            this.prmtAcctCompany.setValue(null);
            this.prmtBank.setData(null);
            this.txtAccountBankNumber.setText(null);
            return;
        }
        abInfo = this.getAccountBankInfo(abInfo.getId());
        this.prmtAcctCompany.setData((Object)abInfo.getCompany());
        this.prmtBank.setData((Object)abInfo.getBank());
        this.txtAccountBankNumber.setText(abInfo.getBankAccountNumber().toString());
        this.editData.setSourceBillId(abInfo.getId().toString());
        this.kdtEntrys.removeRows();
        this.kdtEntrys.refresh();
        this.initTable();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        AccountBankInfo abInfo = (AccountBankInfo)this.prmtAccountNumber.getValue();
        if (abInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"201_AcctModifyApplyEditUI"));
            SysUtil.abort();
        }
        AcctModifyApplyCollection acctModifyApplyCol = this.getAcctModifyApplyCollection(abInfo.getId().toString());
        if (this.getOprtState().equals(OprtState.ADDNEW) && acctModifyApplyCol != null && acctModifyApplyCol.size() != 0) {
            for (int i = 0; i < acctModifyApplyCol.size(); ++i) {
                AcctModifyApplyInfo acctModifyInfo = acctModifyApplyCol.get(i);
                if (acctModifyInfo.getBillState().equals((Object)AcctModifyBillStateEnum.CANCELED) || acctModifyInfo.getBillState().equals((Object)AcctModifyBillStateEnum.CONFIRMED)) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"199_AcctModifyApplyEditUI"));
                SysUtil.abort();
            }
        }
        checkEntrys = true;
        this.editData.setBillState(AcctModifyBillStateEnum.SUBMITTED);
        this.editData.setCompany(this.contextHelp.getCurrentCompany());
        super.actionSubmit_actionPerformed(e);
    }

    private void checkEntrys(AcctModifyApplyEntryCollection entrys) throws Exception {
        block15: {
            ModifyFieldEnum[] bankInterfaceSubFields;
            HashMap<String, AcctModifyApplyEntryInfo> modifyFields;
            block16: {
                block17: {
                    block14: {
                        modifyFields = new HashMap<String, AcctModifyApplyEntryInfo>();
                        for (int i = 0; i < entrys.size(); ++i) {
                            AcctModifyApplyEntryInfo info = entrys.get(i);
                            if (info.getModifyField() == null) {
                                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"206_AcctModifyApplyEditUI"));
                                this.checkAbort();
                            }
                            if (modifyFields.get(info.getModifyField().getValue()) != null) {
                                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"202_AcctModifyApplyEditUI"));
                                this.checkAbort();
                            } else {
                                modifyFields.put(info.getModifyField().getValue(), info);
                            }
                            if (info.getPostValue() != null && (info.getModifyField().equals((Object)ModifyFieldEnum.NAME) || info.getModifyField().equals((Object)ModifyFieldEnum.BANK_ACCT_NUM))) {
                                EntityViewInfo view = new EntityViewInfo();
                                FilterInfo filter = new FilterInfo();
                                filter.getFilterItems().add(new FilterItemInfo(info.getModifyField().getValue(), (Object)info.getPostValue().toString()));
                                view.setFilter(filter);
                                SelectorItemCollection sic = new SelectorItemCollection();
                                sic.add(new SelectorItemInfo("bankAccountNumber"));
                                sic.add(new SelectorItemInfo("name"));
                                AccountBankCollection coll = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                                if (coll.size() != 0) {
                                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"213_AcctModifyApplyEditUI", (Object[])new String[]{info.getModifyField().getAlias()}));
                                    this.checkAbort();
                                }
                            }
                            if (info.getPostValue() != null && info.getModifyField().equals((Object)ModifyFieldEnum.BANK)) {
                                AccountBankInfo account = (AccountBankInfo)this.prmtAccountNumber.getValue();
                                Map accountBankMap = AccountBankFactory.getRemoteInstance().modifyDisplay((IObjectPK)new ObjectUuidPK(account.getId()));
                                boolean canModifyBank = (Boolean)accountBankMap.get("bank");
                                if (!canModifyBank) {
                                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"216_AcctModifyApplyEditUI"));
                                    this.checkAbort();
                                }
                            }
                            if (!(info.getPostValue() != null && !info.getPostValue().isEmpty() || info.getModifyField().equals((Object)ModifyFieldEnum.MAX_PAY_AMT) || info.getModifyField().equals((Object)ModifyFieldEnum.IS_ONLY_READ))) {
                                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"204_AcctModifyApplyEditUI", (Object[])new String[]{info.getModifyField().toString()}));
                                this.checkAbort();
                                continue;
                            }
                            if (info.getPreValue() == null || !info.getPreValue().equals(info.getPostValue()) || info.getPreValue().isEmpty() || info.getModifyField().equals((Object)ModifyFieldEnum.IS_ONLY_READ) || info.getModifyField().equals((Object)ModifyFieldEnum.COUNTRY) || info.getModifyField().equals((Object)ModifyFieldEnum.ACCT_NAME) || info.getModifyField().equals((Object)ModifyFieldEnum.BANK_INT_TYPE) || info.getModifyField().equals((Object)ModifyFieldEnum.MAX_PAY_AMT) || info.getModifyField().equals((Object)ModifyFieldEnum.IS_SET_BANK_INT) || info.getModifyField().equals((Object)ModifyFieldEnum.OPEN_AREA)) continue;
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"205_AcctModifyApplyEditUI", (Object[])new String[]{info.getModifyField().toString()}));
                            this.checkAbort();
                        }
                        bankInterfaceSubFields = new ModifyFieldEnum[]{ModifyFieldEnum.IS_ONLY_READ, ModifyFieldEnum.BANK_INT_TYPE, ModifyFieldEnum.ACCT_NAME, ModifyFieldEnum.COUNTRY, ModifyFieldEnum.OPEN_AREA, ModifyFieldEnum.MAX_PAY_AMT};
                        if (modifyFields.get("isSetBankInterface") == null || !Boolean.valueOf(((AcctModifyApplyEntryInfo)modifyFields.get("isSetBankInterface")).getPostValue()).booleanValue()) break block14;
                        ModifyFieldEnum[] bankInterfaceRequiredSubFields = new ModifyFieldEnum[]{ModifyFieldEnum.BANK_INT_TYPE, ModifyFieldEnum.ACCT_NAME, ModifyFieldEnum.COUNTRY, ModifyFieldEnum.OPEN_AREA};
                        for (int i = 0; i < bankInterfaceRequiredSubFields.length; ++i) {
                            if (modifyFields.get(bankInterfaceRequiredSubFields[i].getValue()) != null) continue;
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"210_AcctModifyApplyEditUI", (Object[])new String[]{bankInterfaceRequiredSubFields[i].getAlias()}));
                            this.checkAbort();
                        }
                        this.checkRepeatValue(bankInterfaceSubFields, modifyFields);
                        break block15;
                    }
                    if (modifyFields.get("isSetBankInterface") != null) break block16;
                    AccountBankInfo abInfo = (AccountBankInfo)this.prmtAccountNumber.getValue();
                    if ((abInfo = this.getAccountBankInfo(abInfo.getId())).isIsSetBankInterface()) break block17;
                    for (int i = 0; i < bankInterfaceSubFields.length; ++i) {
                        if (modifyFields.get(bankInterfaceSubFields[i].getValue()) == null) continue;
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"210_AcctModifyApplyEditUI", (Object[])new String[]{bankInterfaceSubFields[i].getAlias()}));
                        this.checkAbort();
                    }
                    break block15;
                }
                boolean checkRepeat = false;
                for (int i = 0; i < bankInterfaceSubFields.length; ++i) {
                    if (modifyFields.get(bankInterfaceSubFields[i].getValue()) == null) continue;
                    checkRepeat = true;
                    break;
                }
                if (!checkRepeat) break block15;
                this.checkRepeatValue(bankInterfaceSubFields, modifyFields);
                break block15;
            }
            if (!(modifyFields.get("isSetBankInterface") == null || ((AcctModifyApplyEntryInfo)modifyFields.get("isSetBankInterface")).getPostValue() != null && Boolean.valueOf(((AcctModifyApplyEntryInfo)modifyFields.get("isSetBankInterface")).getPostValue()).booleanValue())) {
                for (int i = 0; i < bankInterfaceSubFields.length; ++i) {
                    if (modifyFields.get(bankInterfaceSubFields[i].getValue()) == null) continue;
                    MsgBox.showWarning((Component)((Object)this), (String)"\u662f\u5426\u8bbe\u7f6e\u94f6\u4f01\u63a5\u53e3 \u672a\u52fe\u9009\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u76f8\u5173\u5c5e\u6027\uff01");
                    this.checkAbort();
                }
            }
        }
    }

    private void checkAbort() {
        this.editData.setBillState(AcctModifyBillStateEnum.SAVED);
        SysUtil.abort();
    }

    private void checkRepeatValue(ModifyFieldEnum[] bankInterfaceSubFields, Map<String, AcctModifyApplyEntryInfo> modifyFields) {
        boolean flag = true;
        for (int i = 0; i < bankInterfaceSubFields.length; ++i) {
            if (modifyFields.get(bankInterfaceSubFields[i].getValue()) != null && modifyFields.get(bankInterfaceSubFields[i].getValue()).getPreValue() != null && modifyFields.get(bankInterfaceSubFields[i].getValue()) != null && modifyFields.get(bankInterfaceSubFields[i].getValue()).getPostValue() != null && !modifyFields.get(bankInterfaceSubFields[i].getValue()).getPreValue().equals(modifyFields.get(bankInterfaceSubFields[i].getValue()).getPostValue())) {
                flag = false;
            }
            if (modifyFields.get(bankInterfaceSubFields[i].getValue()) != null && modifyFields.get(bankInterfaceSubFields[i].getValue()).getPreValue() != null || modifyFields.get(bankInterfaceSubFields[i].getValue()) == null || modifyFields.get(bankInterfaceSubFields[i].getValue()).getPostValue() == null) continue;
            flag = false;
        }
        if (flag) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"205_AcctModifyApplyEditUI", (Object[])new String[]{"\u94f6\u884c\u63a5\u53e3\u76f8\u5173\u5c5e\u6027"}));
            this.checkAbort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        AcctModifyApplyInfo bdrInfo = AcctModifyApplyFactory.getRemoteInstance().getAcctModifyApplyInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (bdrInfo.getBillState() == AcctModifyBillStateEnum.AUDITED) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"92_DestroyAccountApplyEditUI"));
            SysUtil.abort();
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        AcctModifyApplyInfo bdrInfo = AcctModifyApplyFactory.getRemoteInstance().getAcctModifyApplyInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (bdrInfo.getBillState() == AcctModifyBillStateEnum.AUDITED || bdrInfo.getBillState() == AcctModifyBillStateEnum.CANCELED || bdrInfo.getBillState() == AcctModifyBillStateEnum.CONFIRMED) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"203_AcctModifyApplyEditUI"));
            SysUtil.abort();
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        AccountBankInfo abInfo = (AccountBankInfo)this.prmtAccountNumber.getValue();
        if (abInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"201_AcctModifyApplyEditUI"));
            SysUtil.abort();
        }
        AcctModifyApplyCollection acctModifyApplyCol = this.getAcctModifyApplyCollection(abInfo.getId().toString());
        if (this.getOprtState().equals(OprtState.ADDNEW) && acctModifyApplyCol != null && acctModifyApplyCol.size() != 0) {
            for (int i = 0; i < acctModifyApplyCol.size(); ++i) {
                AcctModifyApplyInfo acctModifyInfo = acctModifyApplyCol.get(i);
                if (acctModifyInfo.getBillState().equals((Object)AcctModifyBillStateEnum.CANCELED) || acctModifyInfo.getBillState().equals((Object)AcctModifyBillStateEnum.CONFIRMED)) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"199_AcctModifyApplyEditUI"));
                SysUtil.abort();
            }
        }
        checkEntrys = false;
        this.editData.setCompany(this.contextHelp.getCurrentCompany());
        super.actionSave_actionPerformed(e);
        this.setEntrys();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected KDTable getDetailTable() {
        return null;
    }
}

