/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.AccessHelper;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.client.AbstractApplyToBankFilterUI;
import com.kingdee.eas.basedata.assistant.client.IApplyToBankFilter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.util.SysUtil;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ApplyToBankFilterUI
extends AbstractApplyToBankFilterUI
implements IApplyToBankFilter {
    private static final Logger logger = CoreUIObject.getLogger(ApplyToBankFilterUI.class);
    private HashMap selectCondition = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtbank.setDisplayFormat("$name$");
        this.prmtbank.setEditFormat("$number$");
        this.prmtbank.setCommitFormat("$number$");
        this.initCompValue();
    }

    public HashMap showApplyToBankFilterUI(CoreUIObject ui) {
        HashMap returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"bankId", ui.getUIContext().get("bankId"));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ApplyToBankFilterUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((ApplyToBankFilterUI)uiWindow.getUIObject()).getReturnValue();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.pkBizDateFrom);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.pkBizDateTo);
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, this.pkBizDateFrom, this.pkBizDateTo);
        return true;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.disposeUIWindow();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.selectCondition.put("bizDateFrom", this.pkBizDateFrom.getValue());
        this.selectCondition.put("bizDateTo", this.pkBizDateTo.getValue());
        this.selectCondition.put("bank", AccessHelper.getF7Id((KDBizPromptBox)this.prmtbank));
        this.disposeUIWindow();
    }

    private HashMap getReturnValue() {
        return this.selectCondition;
    }

    private void initCompValue() {
        Date date = new Date();
        try {
            date = SysUtil.getAppServerTime(null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.pkBizDateTo.setValue((Object)date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        this.pkBizDateFrom.setValue((Object)calendar.getTime());
        if (this.getUIContext().get("bankId") != null) {
            String bankId = this.getUIContext().get("bankId").toString();
            try {
                BankInfo bankInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(bankId));
                this.prmtbank.setValue((Object)bankInfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }
}

