/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.client.AbstractApplyToBankListUI;
import com.kingdee.eas.basedata.assistant.client.ApplyToBankFilterUI;
import com.kingdee.eas.basedata.assistant.client.IApplyToBankList;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class ApplyToBankListUI
extends AbstractApplyToBankListUI
implements IApplyToBankList {
    private static final Logger logger = CoreUIObject.getLogger(ApplyToBankListUI.class);
    private static final String resourcePath = "com.kingdee.eas.basedata.assistant.AccountApplyBillResource";
    private Set selectCondition;

    public ApplyToBankListUI() throws Exception {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.selectCondition = new HashSet();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        Date bizDateFrom = null;
        Date bizDateTo = null;
        String bankID = "";
        this.filltblMain(bizDateFrom, bizDateTo, bankID);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void filltblMain(Date beginDate, Date endDate, String bankID) throws BOSException, SQLException {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.removeRows();
        IRowSet rs = this.getRowSet(beginDate, endDate, bankID);
        if (rs == null || rs.toCollection().size() == 0) {
            return;
        }
        while (rs.next()) {
            IRow row = this.tblMain.addRow();
            row.getCell("number").setValue(rs.getObject("number"));
            row.getCell("bizDate").setValue(rs.getObject("bizDate"));
            row.getCell("company").setValue(rs.getObject("company.name"));
            row.getCell("bank").setValue(rs.getObject("bank.name"));
            row.getCell("currency").setValue(rs.getObject("currency.name"));
            row.getCell("property").setValue(rs.getObject("property.name"));
            row.getCell("accountType").setValue((Object)AccountType.getEnum((int)((Integer)rs.getObject("accountType"))));
            row.getCell("preOpenDate").setValue(rs.getObject("preOpenDate"));
            row.getCell("creator").setValue(rs.getObject("creator.name"));
            row.getCell("ID").setValue(rs.getObject("id"));
        }
        this.tblMain.getColumn("ID").getStyleAttributes().setHided(true);
    }

    private IRowSet getRowSet(Date beginDate, Date endDate, String bankID) throws BOSException {
        MetaDataPK PK = new MetaDataPK("com.kingdee.eas.basedata.assistant.app", "ApplyToBankQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)PK);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String companyID = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("isCreateToAcc", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        if (null != beginDate) {
            filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        }
        if (null != endDate) {
            filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)endDate, CompareType.LESS_EQUALS));
        }
        if (!"".equals(bankID.trim())) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bankID, CompareType.EQUALS));
        }
        ev.setFilter(filter);
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        HashMap selectCondition = new ApplyToBankFilterUI().showApplyToBankFilterUI(this);
        this.getUIContext().put("bankId", selectCondition.get("bank".toString()));
        if (selectCondition != null && selectCondition.isEmpty()) {
            return;
        }
        Date bizDateFrom = null;
        if (!FMHelper.isEmpty(selectCondition.get("bizDateFrom"))) {
            bizDateFrom = (Date)selectCondition.get("bizDateFrom");
        }
        Date bizDateTo = null;
        if (!FMHelper.isEmpty(selectCondition.get("bizDateTo"))) {
            bizDateTo = (Date)selectCondition.get("bizDateTo");
        }
        String bankID = selectCondition.get("bank") != null ? selectCondition.get("bank").toString() : "";
        this.filltblMain(bizDateFrom, bizDateTo, bankID);
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"mustSelect"));
            return;
        }
        Set selectedSet = ApplyToBankListUI.getSelectedRows(this.tblMain);
        Iterator iterator = selectedSet.iterator();
        HashSet<String> idSet = new HashSet<String>();
        while (iterator.hasNext()) {
            Integer i = (Integer)iterator.next();
            String IDString = this.tblMain.getRow(i.intValue()).getCell("ID").getValue().toString();
            idSet.add(IDString);
        }
        this.selectCondition.addAll(idSet);
        this.disposeUIWindow();
    }

    public static Set getSelectedRows(KDTable table) {
        ArrayList arrayList = table.getSelectManager().getBlocks();
        TreeSet<Integer> set = new TreeSet<Integer>();
        int size = arrayList.size();
        for (int i = 0; i < size; ++i) {
            KDTBlock block = (KDTBlock)arrayList.get(i);
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int j = top; j <= bottom; ++j) {
                Integer theInteger = new Integer(j);
                set.add(theInteger);
            }
        }
        return set;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    public Set showApplyToBankListUI(CoreUIObject ui) {
        Set returnValue = new HashSet();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ApplyToBankListUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((ApplyToBankListUI)uiWindow.getUIObject()).getReturnValue();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }

    private Set getReturnValue() {
        return this.selectCondition;
    }
}

