/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountBillStateEnum;
import com.kingdee.eas.basedata.assistant.AccountResultEnum;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.DestroyAccountApplyCollection;
import com.kingdee.eas.basedata.assistant.DestroyAccountApplyFactory;
import com.kingdee.eas.basedata.assistant.DestroyAccountApplyInfo;
import com.kingdee.eas.basedata.assistant.InnerAccountResultEnum;
import com.kingdee.eas.basedata.assistant.client.AbstractDestroyAccountApplyEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DestroyAccountApplyEditUI
extends AbstractDestroyAccountApplyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DestroyAccountApplyEditUI.class);
    private IContextHelper contextHelp = ContextHelperFactory.getRemoteInstance();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        DestroyAccountApplyEditUI.initNumber((CoreBaseInfo)this.editData, this.txtNumber, this.editData.getCompany().getId().toString());
        if (this.getOprtState().equals(OprtState.EDIT) && AccountBillStateEnum.SUBMIT.equals((Object)this.editData.getBillState())) {
            this.btnSave.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.actionCreateFrom.setVisible(false);
        }
        if (DestroyAccountApplyEditUI.hasNumber((CoreBaseInfo)this.editData, this.currentCompany.getId().toString())) {
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
    }

    public static void initNumber(CoreBaseInfo info, KDTextField txtField, String companyId) {
        if (!EmptyUtil.isEmpty((String)info.getString("number"))) {
            txtField.setEnabled(false);
            return;
        }
        boolean rst = DestroyAccountApplyEditUI.hasNumber(info, companyId);
        if (rst) {
            txtField.setEditable(false);
            txtField.setEnabled(false);
            txtField.setRequired(false);
            String number = DestroyAccountApplyEditUI.getDispNumber(info, companyId);
            if (!EmptyUtil.isEmpty((String)number)) {
                info.setString("number", number);
                txtField.setText(number);
            }
            if (DestroyAccountApplyEditUI.isModifiable(info, companyId)) {
                txtField.setEditable(true);
                txtField.setEnabled(true);
                txtField.setRequired(true);
            }
        } else {
            txtField.setEnabled(true);
            txtField.setEditable(true);
            txtField.setRequired(true);
        }
    }

    public static boolean isModifiable(CoreBaseInfo info, String companyId) {
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isModifiable((IObjectValue)info, companyId);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return result;
    }

    private static String getDispNumber(CoreBaseInfo info, String companyId) {
        String number = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (codingRuleManager.isAddView((IObjectValue)info, companyId) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                number = codingRuleManager.getNumber((IObjectValue)info, companyId);
            }
        }
        catch (BOSException bOSException) {
        }
        catch (CodingRuleException codingRuleException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return number;
    }

    public static boolean hasNumber(CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist((IObjectValue)info, companyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("billState");
        return sic;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DestroyAccountApplyFactory.getRemoteInstance();
    }

    @Override
    protected void initDataStatus() {
        super.initDataStatus();
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionViewBdgBalance.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionCreateFrom.setVisible(true);
        DestroyAccountApplyInfo info = (DestroyAccountApplyInfo)this.getDataObject();
        AccountBillStateEnum billState = null;
        if (info.getBillState() != null) {
            billState = info.getBillState();
        }
        if (OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            this.actionTDPrint.setVisible(true);
            this.actionTDPrintPreview.setVisible(true);
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        } else {
            this.actionTDPrint.setVisible(false);
            this.actionTDPrintPreview.setVisible(false);
            this.actionSave.setEnabled(AccountBillStateEnum.SAVE.equals((Object)billState));
            this.actionSubmit.setEnabled(AccountBillStateEnum.SAVE.equals((Object)billState) || AccountBillStateEnum.SUBMIT.equals((Object)billState));
        }
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        DestroyAccountApplyCollection coll;
        super.verifyInput(e);
        ClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        if (this.getOprtState().equals(OprtState.ADDNEW) && null != (coll = this.getDestroyAccountApplyCollection(this.editData.getAccountBank().getId().toString())) && coll.size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"90_DestroyAccountApplyEditUI"));
            SysUtil.abort();
        }
        this.verifyNumber();
    }

    private void verifyNumber() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.editData.getNumber()));
        if (this.getOprtState().equals(OprtState.EDIT)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        evi.setFilter(filter);
        DestroyAccountApplyCollection coll = DestroyAccountApplyFactory.getRemoteInstance().getDestroyAccountApplyCollection(evi);
        if (null != coll && coll.size() > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"91_DestroyAccountApplyEditUI"));
            SysUtil.abort();
        }
    }

    private DestroyAccountApplyCollection getDestroyAccountApplyCollection(String id) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)id));
        evi.setFilter(filter);
        return DestroyAccountApplyFactory.getRemoteInstance().getDestroyAccountApplyCollection(evi);
    }

    protected IObjectValue createNewData() {
        DestroyAccountApplyInfo info = new DestroyAccountApplyInfo();
        info.setApplyDate(DateUtil.getDayBegin());
        info.setDestroyDate(DateUtil.getDayBegin());
        info.setAccountResult(AccountResultEnum.NOACCOUNT);
        info.setInnerAccountResult(InnerAccountResultEnum.NOACCOUNT);
        info.setBillState(AccountBillStateEnum.SAVE);
        info.setCompany(this.contextHelp.getCurrentCompany());
        info.setCU(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit());
        info.setCreator(this.contextHelp.getCurrentUser());
        info.setAccountType(AccountType.PAYIN);
        return info;
    }

    private AccountBankInfo getAccountBankInfo(BOSUuid id) throws Exception {
        if (null == id || "".equals(id)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.*");
        sic.add("bank.*");
        sic.add("property.*");
        sic.add("currency.*");
        return AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    @Override
    protected void prmtAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo abInfo = (AccountBankInfo)this.prmtAccountBank.getValue();
        if (null == abInfo) {
            return;
        }
        abInfo = this.getAccountBankInfo(abInfo.getId());
        this.prmtDesCompany.setData((Object)abInfo.getCompany());
        this.prmtBank.setData((Object)abInfo.getBank());
        this.prmtCurrency.setData((Object)abInfo.getCurrency());
        this.comboAccountType.setSelectedItem((Object)abInfo.getAccountType());
        this.prmtProperty.setData((Object)abInfo.getProperty());
        this.editData.setSourceBillId(abInfo.getId().toString());
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        this.prmtAccountBank.setDataBySelector();
        SelectorEvent itemEvent = new SelectorEvent((Object)this.prmtAccountBank);
        this.prmtAccountBank_willShow(itemEvent);
    }

    @Override
    protected void prmtAccountBank_willShow(SelectorEvent e) throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        ev.setFilter(filter);
        this.prmtAccountBank.setEntityViewInfo(ev);
        this.prmtAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setBillState(AccountBillStateEnum.SUBMIT);
        super.actionSubmit_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        DestroyAccountApplyInfo bdrInfo = DestroyAccountApplyFactory.getRemoteInstance().getDestroyAccountApplyInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (bdrInfo.getBillState() == AccountBillStateEnum.AUDIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"92_DestroyAccountApplyEditUI"));
            SysUtil.abort();
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        DestroyAccountApplyInfo bdrInfo = DestroyAccountApplyFactory.getRemoteInstance().getDestroyAccountApplyInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (bdrInfo.getBillState() == AccountBillStateEnum.AUDIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"93_DestroyAccountApplyEditUI"));
            SysUtil.abort();
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    protected String getTDFileName() {
        return "/FM/AC/DestroyAccountBill";
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.basedata.assistant.app.DestroyAccountTDQuery");
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }
}

