/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.CurrencyUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBillStateEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.client.AbstractDestroyAccountApplyFilterUI;
import com.kingdee.eas.basedata.assistant.client.DestroyAccountApplyFilterParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class DestroyAccountApplyFilterUI
extends AbstractDestroyAccountApplyFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DestroyAccountApplyFilterUI.class);

    public DestroyAccountApplyFilterUI() throws Exception {
        this.endTime.setSupportedEmpty(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void init() throws Exception {
        CurrencyUtil.fillCombCurrency((KDComboBox)this.comboCurrency);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comboBillState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.startTime.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.endTime.setValue((Object)new Date());
        this.comboBillState.addItems(AccountBillStateEnum.getEnumList().toArray());
        super.init();
    }

    @Override
    protected void setDefaultValue() {
        super.setDefaultValue();
        this.startTime.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.endTime.setValue((Object)new Date());
        UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)((Object)FMSysDefinedEnum.SELECT_ALL));
        UIUtil.setSelectObject((KDComboBox)this.comboBillState, (Object)((Object)FMSysDefinedEnum.SELECT_ALL));
    }

    @Override
    public Object getParam() {
        DestroyAccountApplyFilterParam param = new DestroyAccountApplyFilterParam();
        if (null != this.startTime.getValue()) {
            param.setStartTime((Date)this.startTime.getValue());
        }
        if (null != this.endTime.getValue()) {
            param.setEndTime((Date)this.endTime.getValue());
        }
        if (FMSysDefinedEnum.SELECT_ALL == this.comboCurrency.getSelectedItem()) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        }
        if (FMSysDefinedEnum.SELECT_ALL == this.comboBillState.getSelectedItem()) {
            param.setBillState(null);
        } else {
            param.setBillState((AccountBillStateEnum)this.comboBillState.getSelectedItem());
        }
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            param.setCompanyIdSet(this.getCompanyIdSet());
        }
        return param;
    }

    @Override
    public void setParam(Object param) {
        DestroyAccountApplyFilterParam filterParam = (DestroyAccountApplyFilterParam)param;
        this.startTime.setValue((Object)filterParam.getStartTime());
        this.endTime.setValue((Object)filterParam.getEndTime());
        if (null == filterParam.getCurrencyId()) {
            UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)((Object)FMSysDefinedEnum.SELECT_ALL));
        } else {
            CurrencyInfo currencyInfo = DestroyAccountApplyFilterUI.getCurrencyInfo(BOSUuid.read((String)filterParam.getCurrencyId()));
            UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)currencyInfo);
        }
        if (null == filterParam.getBillState()) {
            UIUtil.setSelectObject((KDComboBox)this.comboBillState, (Object)((Object)FMSysDefinedEnum.SELECT_ALL));
        } else {
            this.comboBillState.setSelectedItem((Object)filterParam.getBillState());
        }
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
    }

    public static CurrencyInfo getCurrencyInfo(BOSUuid id) {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CurrencyInfo info = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            info = iCurrency.getCurrencyInfo((IObjectPK)pk);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return info;
    }

    @Override
    public boolean verify() {
        Date start = (Date)this.startTime.getValue();
        Date end = (Date)this.endTime.getValue();
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.startTime);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.endTime);
        if (end.before(start)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"94_DestroyAccountApplyFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    protected Class getParamClass() {
        return DestroyAccountApplyFilterParam.class;
    }
}

