/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.basedata.assistant.AccountBillStateEnum;
import com.kingdee.eas.basedata.assistant.AccountResultEnum;
import com.kingdee.eas.basedata.assistant.DestroyAccountApplyCollection;
import com.kingdee.eas.basedata.assistant.DestroyAccountApplyFactory;
import com.kingdee.eas.basedata.assistant.DestroyAccountApplyInfo;
import com.kingdee.eas.basedata.assistant.IDestroyAccountApply;
import com.kingdee.eas.basedata.assistant.InnerAccountResultEnum;
import com.kingdee.eas.basedata.assistant.client.AbstractDestroyAccountApplyListUI;
import com.kingdee.eas.basedata.assistant.client.AccountBankMainUI;
import com.kingdee.eas.basedata.assistant.client.DestroyAccountApplyEditUI;
import com.kingdee.eas.basedata.assistant.client.DestroyAccountApplyFilterUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DestroyAccountApplyListUI
extends AbstractDestroyAccountApplyListUI {
    private static final Logger logger = CoreUIObject.getLogger(DestroyAccountApplyListUI.class);
    FMFilterBaseUI filterUI = null;
    private static final String resourcePath = "com.kingdee.eas.basedata.assistant.AccountApplyBillResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnUnAudit.setEnabled(true);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionViewBdgBalance.setVisible(false);
        this.menuItemUnAudit.setEnabled(true);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        if (GLUtil.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompanyCommon)) {
            this.actionDelVoucher.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionUnAudit.setVisible(false);
            this.actionViewBdgBalance.setVisible(false);
            this.actionAttachment.setVisible(false);
            this.actionAuditResult.setVisible(false);
        }
        this.tblMain.getColumn("applyDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("destroyDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DestroyAccountApplyFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return DestroyAccountApplyEditUI.class.getName();
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (null == this.filterUI) {
            this.filterUI = new DestroyAccountApplyFilterUI();
        }
        return this.filterUI;
    }

    protected void execQuery() {
        String accountBankId = (String)this.getUIContext().get("accountBankId");
        if (null == accountBankId || "".equals(accountBankId)) {
            super.execQuery();
        } else {
            this.actionWorkFlowG.setVisible(false);
            this.actionDelVoucher.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionUnAudit.setVisible(false);
            this.actionViewBdgBalance.setVisible(false);
            this.actionAttachment.setVisible(false);
            this.actionAuditResult.setVisible(false);
            this.actionAddNew.setVisible(false);
            this.actionQuery.setVisible(false);
            this.actionLocate.setVisible(false);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)accountBankId));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompanyCommon.getId()));
            this.mainQuery.setFilter(filter);
            super.execQuery();
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        DestroyAccountApplyCollection col = this.getDestroyAccountApplyColl(idSet);
        for (int i = 0; i < col.size(); ++i) {
            DestroyAccountApplyInfo info = col.get(i);
            if (info.getBillState() != AccountBillStateEnum.SAVE && info.getBillState() != AccountBillStateEnum.AUDIT) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"95_DestroyAccountApplyListUI"));
            SysUtil.abort();
        }
        DestroyAccountApplyFactory.getRemoteInstance().batchAudit(idSet);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"96_DestroyAccountApplyListUI"));
        this.refresh(e);
    }

    protected DestroyAccountApplyCollection getDestroyAccountApplyColl(Set idSet) throws BOSException, Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return ((IDestroyAccountApply)this.getBizInterface()).getDestroyAccountApplyCollection(evi);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        DestroyAccountApplyCollection col = this.getDestroyAccountApplyColl(idSet);
        for (int i = 0; i < col.size(); ++i) {
            DestroyAccountApplyInfo info = col.get(i);
            if (info.getBillState() == AccountBillStateEnum.AUDIT && info.getAccountResult() == AccountResultEnum.NOACCOUNT && info.getInnerAccountResult() == InnerAccountResultEnum.NOACCOUNT) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"35_DestroyAccountApplyControllerBean"));
            SysUtil.abort();
        }
        DestroyAccountApplyFactory.getRemoteInstance().batchUnAudit(idSet);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"97_DestroyAccountApplyListUI"));
        this.refresh(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        DestroyAccountApplyInfo bdrInfo = DestroyAccountApplyFactory.getRemoteInstance().getDestroyAccountApplyInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (bdrInfo.getBillState() == AccountBillStateEnum.AUDIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"92_DestroyAccountApplyEditUI"));
            SysUtil.abort();
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        DestroyAccountApplyInfo bdrInfo = DestroyAccountApplyFactory.getRemoteInstance().getDestroyAccountApplyInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (bdrInfo.getBillState() == AccountBillStateEnum.AUDIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"93_DestroyAccountApplyEditUI"));
            SysUtil.abort();
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        Set idSet = BOTPUtil.getSrcBillIdSet(null, (String)id);
        if (idSet == null || idSet.size() <= 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"51_AccountBankMainUI"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this.ui);
        uiContext.put((Object)"isBotp", (Object)"botp");
        uiContext.put((Object)"idSet", (Object)idSet);
        Frame mainFrame = UIFrameUtil.getCurrMainFrame((Component)((Object)this));
        uiContext.put((Object)"Owner", (Object)mainFrame);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AccountBankMainUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit == null || GLUtil.isCompanyUnion((CompanyOrgUnitInfo)currentFIUnit)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"nullCompanyConnotAdd"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected String getTDFileName() {
        return "/FM/AC/DestroyAccountBill";
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.basedata.assistant.app.DestroyAccountTDQuery");
    }
}

