/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.client.AbstractRptAccountBankDetailFilterUI;
import com.kingdee.eas.basedata.assistant.client.RptAccountBankDetailFilterParam;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AcctBankChangeTypeEnum;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptAccountBankDetailFilterUI
extends AbstractRptAccountBankDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptAccountBankDetailFilterUI.class);

    public RptAccountBankDetailFilterUI() throws Exception {
        this.comboChangeType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        F7SelectorFactory.initBankTree((IUIObject)this, this.prmtBank);
    }

    @Override
    public Object getParam() {
        RptAccountBankDetailFilterParam param = new RptAccountBankDetailFilterParam();
        param.setCompanyIdSet(this.getIdSetFromF7(this.prmtCompany));
        param.setBankIdSet(this.getIdSetFromF7(this.prmtBank));
        java.util.Date dateFrom = DateTimeUtils.truncateDate((java.util.Date)this.rptLDFDateFrom.getSqlDate());
        param.setDateFrom(new Date(dateFrom.getTime()));
        java.util.Date dateTo = DateTimeUtils.truncateDate((java.util.Date)this.rptLDFDateTo.getSqlDate());
        param.setDateTo(new Date(dateTo.getTime()));
        param.setBankProperty(this.isBankProperty.isSelected());
        param.setIncledeUsed(this.cbIncledeUsed.isSelected());
        if (!(this.comboChangeType.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setChangeType((AcctBankChangeTypeEnum)((Object)this.comboChangeType.getSelectedItem()));
        } else {
            param.setChangeType(null);
        }
        return param;
    }

    @Override
    public void setParam(Object param) {
        RptAccountBankDetailFilterParam loParam = (RptAccountBankDetailFilterParam)param;
        try {
            Set companyIds = loParam.getCompanyIdSet();
            CoreBaseInfo[] data = RptFmClientUtil.getBaseInfoFromIdSet(companyIds);
            this.prmtCompany.setData((Object)data);
            this.prmtBank.setData((Object)this.getBaseInfoFromIdSet(loParam.getBankIdSet()));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.rptLDFDateFrom.setValue((Object)loParam.getDateFrom());
        this.rptLDFDateTo.setValue((Object)loParam.getDateTo());
        this.isBankProperty.setSelected(loParam.isBankProperty());
        this.cbIncledeUsed.setSelected(loParam.isIncledeUsed());
        if (loParam.getChangeType() != null) {
            FMClientHelper.setSelectObject(this.comboChangeType, (Object)loParam.getChangeType());
        } else {
            FMClientHelper.setSelectObject(this.comboChangeType, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.doInit();
    }

    @Override
    public void clear() {
        super.clear();
        this.doInit();
    }

    private void doInit() {
        this.initFirstDayOfMonth(this.rptLDFDateFrom);
        this.initLastDayOfMonth(this.rptLDFDateTo);
        this.comboChangeType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.isBankProperty.setSelected(false);
        this.cbIncledeUsed.setSelected(true);
        this.prmtCompany.setValue((Object)this.currentCompany);
    }

    private void initFirstDayOfMonth(KDDatePicker kdDate) {
        java.util.Date date = new java.util.Date();
        GregorianCalendar firstDay = new GregorianCalendar();
        firstDay.add(5, -(date.getDate() - 1));
        kdDate.setValue((Object)firstDay.getTime());
    }

    private void initLastDayOfMonth(KDDatePicker kdDate) {
        java.util.Date date = new java.util.Date();
        GregorianCalendar lastDay = new GregorianCalendar();
        lastDay.add(2, 1);
        lastDay.add(5, -date.getDate());
        kdDate.setValue((Object)lastDay.getTime());
    }

    @Override
    public boolean verify() {
        String resourcePath = "com.kingdee.eas.basedata.assistant.client.RptAccountBankDetailResource";
        Date kdDateFrom = this.rptLDFDateFrom.getSqlDate();
        Date kdDateTo = this.rptLDFDateTo.getSqlDate();
        if (kdDateFrom == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"staVerify"));
            SysUtil.abort();
        }
        if (kdDateTo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"endVerify"));
            SysUtil.abort();
        }
        if (kdDateFrom.compareTo(kdDateTo) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"verify"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public CompanyOrgUnitInfo getCurrentCompany() {
        if (null == this.currentCompany) {
            this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        return this.currentCompany;
    }

    public boolean isVirtualBody() {
        try {
            return ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.getCurrentCompany());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
    }

    @Override
    protected Class getParamClass() {
        return RptAccountBankDetailFilterParam.class;
    }

    @Override
    public void initCompanyState() {
        this.chkIA.setEnabled(false);
        this.btnCompanySelect.setEnabled(false);
        this.btnCompanySelect.setVisible(false);
    }

    @Override
    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    @Override
    public boolean isSupportMultiOrgs() {
        return true;
    }
}

