/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.FilterZeroParser;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.client.RptAccountBankDetailFilterParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class RptAccountBankDetailHandler
extends FMDetailRptBaseHandler {
    public static final String resourcePath = "com.kingdee.eas.basedata.assistant.client.RptAccountBankDetailResource";
    protected boolean isBankProperty = false;
    protected boolean cbIncledeUsed = false;
    protected RptAccountBankDetailFilterParam param;

    public RptAccountBankDetailHandler(RptAccountBankDetailFilterParam param, KDTable kdt) {
        super(param.getFilter(), param.getSorterItems(), kdt);
        this.sorter = param.getSorterItems();
        this.isBankProperty = param.isBankProperty();
        this.cbIncledeUsed = param.isIncledeUsed();
        this.param = param;
    }

    public static SorterItemCollection getSorter() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("company"));
        sorter.add(new SorterItemInfo("isClosed"));
        sorter.add(new SorterItemInfo("property"));
        return sorter;
    }

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    @Override
    protected String getQueryPath() {
        return "com.kingdee.eas.basedata.assistant.app.RptAccountBankDetailQuery";
    }

    @Override
    public void initHeader() {
        super.initHeader();
        this.insertHeadRow();
        this.formatHeadRow();
    }

    protected void insertHeadRow() {
        IColumn colCompany = this.kdt.addColumn();
        colCompany.setKey("company");
        colCompany.setMergeable(true);
        colCompany.setGroup(true);
        colCompany.setWidth(250);
        IColumn colIsClosed = this.kdt.addColumn();
        colIsClosed.setKey("isClosed");
        colIsClosed.setGroup(true);
        colIsClosed.setWidth(100);
        colIsClosed.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        IColumn colProperty = this.kdt.addColumn();
        colProperty.setKey("property.name");
        colProperty.setGroup(true);
        colProperty.setWidth(100);
        colProperty.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        colProperty.getStyleAttributes().setHided(false);
        IColumn colBankAccountNumber = this.kdt.addColumn();
        colBankAccountNumber.setKey("bankAccountNumber");
        colBankAccountNumber.setWidth(200);
        IColumn colAccountBankName = this.kdt.addColumn();
        colAccountBankName.setKey("accountBankName");
        colAccountBankName.setWidth(200);
        IColumn colBank = this.kdt.addColumn();
        colBank.setKey("bank");
        colBank.setWidth(200);
        IColumn colOpenCount = this.kdt.addColumn();
        colOpenCount.setKey("openCount");
        colOpenCount.getStyleAttributes().setHided(true);
        IColumn colCloseCount = this.kdt.addColumn();
        colCloseCount.setKey("closeCount");
        colCloseCount.getStyleAttributes().setHided(true);
        IColumn colModifyCount = this.kdt.addColumn();
        colModifyCount.setKey("modifyCount");
        colModifyCount.getStyleAttributes().setHided(true);
        IColumn colOpenDate = this.kdt.addColumn();
        colOpenDate.setKey("changeDate");
        colOpenDate.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        colOpenDate.setWidth(200);
        IColumn colID = this.kdt.addColumn();
        colID.setKey("id");
        colID.getStyleAttributes().setHided(true);
        IColumn colcompanyId = this.kdt.addColumn();
        colcompanyId.setKey("companyId");
        colcompanyId.getStyleAttributes().setHided(true);
        IColumn propertyNumber = this.kdt.addColumn();
        propertyNumber.setKey("propertyNumber");
        propertyNumber.getStyleAttributes().setHided(true);
        IColumn colacctId = this.kdt.addColumn();
        colacctId.setKey("acctId");
        colacctId.getStyleAttributes().setHided(true);
    }

    protected void formatHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("company").setValue((Object)this.getResString("company"));
        headRow.getCell("isClosed").setValue((Object)this.getResString("changeType"));
        headRow.getCell("bank").setValue((Object)this.getResString("bank"));
        headRow.getCell("property.name").setValue((Object)this.getResString("property"));
        headRow.getCell("bankAccountNumber").setValue((Object)this.getResString("bankAccountNumber"));
        headRow.getCell("accountBankName").setValue((Object)this.getResString("accountBankName"));
        headRow.getCell("changeDate").setValue((Object)this.getResString("changeDate"));
        headRow.getCell("id").setValue((Object)"id");
        headRow.getCell("companyId").setValue((Object)"companyId");
        headRow.getCell("openCount").setValue((Object)"openCount");
        headRow.getCell("closeCount").setValue((Object)"closeCount");
        headRow.getCell("modifyCount").setValue((Object)"modifyCount");
        headRow.getCell("propertyNumber").setValue((Object)"property");
        headRow.getCell("acctId").setValue((Object)"acctId");
    }

    @Override
    public IRowSet getRowSet() throws BOSException {
        IRowSet rowset = null;
        StringBuffer sql = new StringBuffer();
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        sql.append("SELECT * FROM (");
        sql.append("SELECT COMPANY.FName_l2 AS company, ACCOUNTBANK.FIsClosed AS isClosed, BANK.FName_l2 AS bank,BANK.FID AS bankId,ACCOUNTBANK.FID AS acctId,");
        sql.append("PROPERTY.FNumber AS property, ACCOUNTBANK.FBankAccountNumber AS BANKACCOUNTNUMBER, ACCOUNTBANK.FOpenDate AS OPENDATE, ");
        sql.append("ACCOUNTBANK.FCloseDate AS CLOSEDATE, ACCOUNTBANK.FApplyBillId AS ID, ACCOUNTBANK.FCompanyID AS COMPANYID, ");
        sql.append("CASE ACCOUNTBANK.FIsClosed WHEN 0 THEN 1 ELSE 0 END AS OPENCOUNT, CASE ACCOUNTBANK.FIsClosed WHEN 1 THEN 1 ELSE 0 END AS CLOSECOUNT, 0 AS modifyCount,");
        sql.append("COMPANY.FIsBizUnit AS isBizUnit,COMPANY.FLongNumber AS longNumber,BANK.FNumber AS bankNumber, ");
        sql.append("PROPERTY.FName_l2 AS propertyName, ACCOUNTBANK.FshareType AS shareType, ACCOUNTBANK.FName_l2 AS accountBankName, ");
        sql.append("CASE ACCOUNTBANK.FIsClosed WHEN 0 THEN 1 ELSE 2 END AS changeType ");
        sql.append("FROM T_BD_AccountBanks AS ACCOUNTBANK ");
        sql.append("LEFT OUTER JOIN T_BD_AccountProperty AS PROPERTY ON ACCOUNTBANK.FPropertyId = PROPERTY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Bank AS BANK ON ACCOUNTBANK.FBank = BANK.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ON ACCOUNTBANK.FCompanyID = COMPANY.FID ");
        sql.append("where ((ACCOUNTBANK.FOpenDate>={ts'" + dtformat.format(this.param.getDateFrom()) + "'} and ACCOUNTBANK.FOpenDate<={ts'" + dtformat.format(this.param.getDateTo()) + "'}) or (ACCOUNTBANK.FCloseDate>={ts'" + dtformat.format(this.param.getDateFrom()) + "'} and ACCOUNTBANK.FCloseDate<={ts'" + dtformat.format(this.param.getDateTo()) + "'})) ");
        sql.append(" UNION ALL ");
        sql.append("SELECT COMPANY.FName_l2 AS company, ap.isClosed AS isClosed, BANK.FName_l2 AS bankName,BANK.FID AS bankId,ap.acctId AS acctId,");
        sql.append("ap.property AS property, ap.BANKACCOUNTNUMBER AS BANKACCOUNTNUMBER, ACCTMODIFYAPPLY.FConfirmDate AS OPENDATE, ");
        sql.append("ap.closeDate AS CLOSEDATE, ACCTMODIFYAPPLY.FID AS ID, ACCTMODIFYAPPLY.FCompanyID AS COMPANYID, ");
        sql.append("0 AS OPENCOUNT, 0 AS CLOSECOUNT, 1 AS modifyCount,");
        sql.append("COMPANY.FIsBizUnit AS isBizUnit,COMPANY.FLongNumber AS longNumber,BANK.FNumber AS bankNumber, ");
        sql.append("ap.propertyName AS propertyName, ap.shareType AS shareType, ap.accountBankName AS accountBankName, ");
        sql.append("3 AS changeType ");
        sql.append("from T_BD_AcctModifyApply AS ACCTMODIFYAPPLY ");
        sql.append("LEFT OUTER JOIN (select A.FID AS acctId,A.FShareType as shareType,A.FPropertyId as propertyID,A.FIsClosed AS isClosed,A.FBankAccountNumber AS BANKACCOUNTNUMBER,A.FName_l2 AS accountBankName,A.FCloseDate AS closeDate,P.FName_l2 AS propertyName,P.FNumber AS property from t_bd_accountbanks as A LEFT OUTER JOIN T_BD_AccountProperty AS P ON A.FPropertyId = P.FID ) AS ap ON ACCTMODIFYAPPLY.FAccountBankID = ap.acctId ");
        sql.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ON ACCTMODIFYAPPLY.FCompanyID = COMPANY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Bank AS BANK ON ACCTMODIFYAPPLY.FBankID = BANK.FID ");
        sql.append("where ACCTMODIFYAPPLY.FBillState=5 and ACCTMODIFYAPPLY.FConfirmDate>={ts'" + dtformat.format(this.param.getDateFrom()) + "'} and ACCTMODIFYAPPLY.FConfirmDate<={ts'" + dtformat.format(this.param.getDateTo()) + "'}");
        sql.append(") aa where 1=1 ");
        if (this.param.getCompanyIdSet() != null && this.param.getCompanyIdSet().size() > 0) {
            sql.append(" and aa.COMPANYID in (" + BirtUtils.idListToInClause((Collection)this.param.getCompanyIdSet()) + ") ");
        }
        if (this.param.getBankIdSet() != null && this.param.getBankIdSet().size() > 0) {
            sql.append(" and aa.bankId in (" + BirtUtils.idListToInClause((Collection)this.param.getBankIdSet()) + ") ");
        }
        if (this.param.getChangeType() != null) {
            if (1 == this.param.getChangeType().getValue()) {
                sql.append(" and aa.changeType<>3 ");
            } else {
                sql.append(" and aa.changeType=" + this.param.getChangeType().getValue() + " ");
            }
        }
        if (!this.cbIncledeUsed) {
            sql.append(" and aa.shareType <> 2 ");
        }
        sql.append("order by aa.company,aa.modifyCount,aa.OPENDATE,aa.CLOSEDATE ");
        try {
            rowset = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return rowset;
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        while (rs.next()) {
            String tmpID = rs.getString("id");
            boolean isModify = rs.getBoolean("modifyCount");
            if (isModify) {
                this.addNewRow(rs, tmpID, this.getResString("type_modify"), false);
                continue;
            }
            boolean isClosed = rs.getBoolean("isClosed");
            if (isClosed) {
                Date endDate;
                Date opDate = rs.getDate("openDate");
                if ((opDate.after(this.param.getDateFrom()) && opDate.before(this.param.getDateTo()) || opDate.equals(this.param.getDateFrom()) || opDate.equals(this.param.getDateTo())) && (this.param.getChangeType() == null || this.param.getChangeType().getValue() != 2)) {
                    this.addNewRow(rs, tmpID, this.getResString("type_open"), false);
                }
                if ((!(endDate = rs.getDate("closeDate")).after(this.param.getDateFrom()) || !endDate.before(this.param.getDateTo())) && !endDate.equals(this.param.getDateFrom()) && !endDate.equals(this.param.getDateTo()) || this.param.getChangeType() != null && this.param.getChangeType().getValue() != 2) continue;
                this.addNewRow(rs, tmpID, this.getResString("type_close"), true);
                continue;
            }
            this.addNewRow(rs, tmpID, this.getResString("type_open"), false);
        }
    }

    private void addNewRow(IRowSet rs, String tmpID, String type, boolean isClose) throws SQLException {
        for (int i = this.kdt.getRowCount(); i >= 0; --i) {
            if (i == 0) {
                IRow row1 = this.kdt.addRow();
                this.setRowValue(rs, row1, isClose);
                row1.setUserObject((Object)tmpID);
                break;
            }
            IRow kdRow = this.kdt.getRow(i - 1);
            if (!kdRow.getCell("isClosed").getValue().toString().equals(type) || !kdRow.getCell("companyId").getValue().toString().equals(rs.getString("companyid")) || kdRow.getCell("property.name").getValue() == null || !kdRow.getCell("property.name").getValue().toString().equals(rs.getString("propertyName"))) continue;
            IRow row1 = this.kdt.addRow(i);
            this.setRowValue(rs, row1, isClose);
            row1.setUserObject((Object)tmpID);
            break;
        }
    }

    @Override
    public void setTableStateRow() {
        if (this.isBankProperty) {
            this.setTableStateRow2();
        } else {
            this.setTableStateRow1();
        }
    }

    private void setTableStateRow1() {
        this.kdt.getSelectManager().setSelectMode(2);
        this.kdt.getColumn("isClosed").setStat(true);
        this.kdt.setUserCellDisplayParser((IUserCellDisplayParser)new FilterZeroParser());
        IRow row = this.kdt.getGroupManager().getStatRowTemplate(1);
        row.getCell("openCount").setExpressions("SUM");
        row.getCell("changeDate").setExpressions("=cell(ROW_INDEX,7).getValue()");
        row.getCell("changeDate").getStyleAttributes().setBackground(new Color(16119270));
        this.initDecimalCell(row.getCell("changeDate"));
        row.getCell("closeCount").setExpressions("SUM");
        row.getCell("changeDate").setExpressions("=cell(ROW_INDEX,8).getValue()");
        row.getCell("changeDate").getStyleAttributes().setBackground(new Color(16119270));
        this.initDecimalCell(row.getCell("changeDate"));
        row.getCell("modifyCount").setExpressions("SUM");
        row.getCell("changeDate").setExpressions("=cell(ROW_INDEX,9).getValue()");
        row.getCell("changeDate").getStyleAttributes().setBackground(new Color(16119270));
        this.initDecimalCell(row.getCell("changeDate"));
        row.getStyleAttributes().setBackground(new Color(16119270));
        row.getCell("isClosed").setExpressions("=cell(ROW_INDEX-1,2).getValue()+\"" + this.getResString("andCount") + "\"");
        this.kdt.getGroupManager().setTotalize(true);
        IRow totalRow = this.kdt.getGroupManager().getStatRowTemplate(-1);
        totalRow.getCell("openCount").setExpressions("SUM");
        totalRow.getCell("closeCount").setExpressions("SUM");
        totalRow.getCell("modifyCount").setExpressions("SUM");
        totalRow.getCell("changeDate").setExpressions("=cell(ROW_INDEX,9).getValue()+cell(ROW_INDEX,7).getValue()+cell(ROW_INDEX,8).getValue()");
        totalRow.getCell("changeDate").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        this.initDecimalCell(totalRow.getCell("changeDate"));
        totalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        totalRow.getCell(0).setValue((Object)this.getResString("andCount"));
    }

    private void setTableStateRow2() {
        this.kdt.setUserCellDisplayParser((IUserCellDisplayParser)new FilterZeroParser());
        this.kdt.getColumn("isClosed").setStat(true);
        this.kdt.getColumn("property.name").setStat(true);
        IRow row = this.kdt.getGroupManager().getStatRowTemplate(1);
        row.getCell("openCount").setExpressions("SUM");
        row.getCell("changeDate").setExpressions("=cell(ROW_INDEX,7).getValue()");
        row.getCell("changeDate").getStyleAttributes().setBackground(new Color(16119270));
        this.initDecimalCell(row.getCell("changeDate"));
        row.getCell("closeCount").setExpressions("SUM");
        row.getCell("changeDate").setExpressions("=cell(ROW_INDEX,8).getValue()");
        row.getCell("changeDate").getStyleAttributes().setBackground(new Color(16119270));
        this.initDecimalCell(row.getCell("changeDate"));
        row.getCell("modifyCount").setExpressions("SUM");
        row.getCell("changeDate").setExpressions("=cell(ROW_INDEX,9).getValue()");
        row.getCell("changeDate").getStyleAttributes().setBackground(new Color(16119270));
        this.initDecimalCell(row.getCell("changeDate"));
        row.getStyleAttributes().setBackground(new Color(16119270));
        row.getCell("isClosed").setExpressions("=cell(ROW_INDEX-1,2).getValue()+\"" + this.getResString("andCount") + "\"");
        IRow propertyRow = this.kdt.getGroupManager().getStatRowTemplate(2);
        propertyRow.getCell("openCount").setExpressions("SUM");
        propertyRow.getCell("changeDate").setExpressions("=cell(ROW_INDEX,7).getValue()");
        propertyRow.getCell("changeDate").getStyleAttributes().setBackground(new Color(16119270));
        this.initDecimalCell(propertyRow.getCell("changeDate"));
        propertyRow.getCell("closeCount").setExpressions("SUM");
        propertyRow.getCell("changeDate").setExpressions("=cell(ROW_INDEX,8).getValue()");
        propertyRow.getCell("changeDate").getStyleAttributes().setBackground(new Color(16119270));
        this.initDecimalCell(propertyRow.getCell("changeDate"));
        propertyRow.getCell("modifyCount").setExpressions("SUM");
        propertyRow.getCell("changeDate").setExpressions("=cell(ROW_INDEX,9).getValue()");
        propertyRow.getCell("changeDate").getStyleAttributes().setBackground(new Color(16119270));
        this.initDecimalCell(propertyRow.getCell("changeDate"));
        propertyRow.getStyleAttributes().setBackground(new Color(16119270));
        propertyRow.getCell("property.name").setExpressions("=cell(ROW_INDEX-1,3).getValue()+cell(ROW_INDEX-1,2).getValue()+\"" + this.getResString("count") + "\"");
        propertyRow.getCell("id").setExpressions("=cell(ROW_INDEX-1,3).getValue()");
    }

    @Override
    public void endDataFill() {
        super.endDataFill();
        this.templateTotal();
    }

    private void addTotalRow(String totalTitle, int open, int close, int modify) {
        IRow totalRow = this.kdt.addRow();
        totalRow.getCell("changeDate").setValue((Object)new Integer(open + close + modify));
        totalRow.getCell("changeDate").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        this.initDecimalCell(totalRow.getCell("changeDate"));
        totalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        totalRow.getCell(0).setValue((Object)totalTitle);
        this.kdt.getMergeManager().mergeBlock(totalRow.getRowIndex(), 0, totalRow.getRowIndex(), 4);
    }

    private void templateTotal() {
        int openTotal = 0;
        int closeTotal = 0;
        int modifyTotal = 0;
        LinkedHashMap<String, Integer> openMap = new LinkedHashMap<String, Integer>();
        HashMap<String, Integer> closeMap = new HashMap<String, Integer>();
        HashMap<String, Integer> modifyMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.kdt.getRowCount(); ++i) {
            IRow row = this.kdt.getRow(i);
            ICell cell = row.getCell("property.name");
            if (cell.getValue() != null && !StringUtil.isEmpty((String)cell.getValue().toString()) && cell.getValue().toString().indexOf(this.getResString("count")) != -1) {
                String useing;
                int open = this.getCellIntValue("openCount", row);
                int close = this.getCellIntValue("closeCount", row);
                int modify = this.getCellIntValue("modifyCount", row);
                if (open != 0) {
                    row.getCell("changeDate").setValue((Object)new Integer(open));
                }
                if (close != 0) {
                    row.getCell("changeDate").setValue((Object)new Integer(close));
                }
                if (modify != 0) {
                    row.getCell("changeDate").setValue((Object)new Integer(modify));
                }
                openTotal += open;
                closeTotal += close;
                modifyTotal += modify;
                String string = useing = row.getCell("id").getValue() == null ? "" : row.getCell("id").getValue().toString();
                if (!StringUtil.isEmpty((String)useing)) {
                    Integer count;
                    if (closeMap.containsKey(useing)) {
                        count = (Integer)closeMap.get(useing);
                        closeMap.put(useing, new Integer(count + close));
                    } else {
                        closeMap.put(useing, new Integer(close));
                    }
                    if (openMap.containsKey(useing)) {
                        count = (Integer)openMap.get(useing);
                        openMap.put(useing, new Integer(count + open));
                    } else {
                        openMap.put(useing, new Integer(open));
                    }
                    if (modifyMap.containsKey(useing)) {
                        count = (Integer)modifyMap.get(useing);
                        modifyMap.put(useing, new Integer(count + modify));
                    } else {
                        modifyMap.put(useing, new Integer(modify));
                    }
                }
                this.kdt.getMergeManager().mergeBlock(i, 2, i, 4);
                row.getCell(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                continue;
            }
            cell = row.getCell("isClosed");
            if (cell.getValue() == null || StringUtil.isEmpty((String)cell.getValue().toString()) || cell.getValue().toString().indexOf(this.getResString("andCount")) == -1) continue;
            if ((BigDecimal)row.getCell("openCount").getValue() != BigDecimal.ZERO) {
                row.getCell("changeDate").setValue(row.getCell("openCount").getValue());
            }
            if ((BigDecimal)row.getCell("closeCount").getValue() != BigDecimal.ZERO) {
                row.getCell("changeDate").setValue(row.getCell("closeCount").getValue());
            }
            if ((BigDecimal)row.getCell("modifyCount").getValue() != BigDecimal.ZERO) {
                row.getCell("changeDate").setValue(row.getCell("modifyCount").getValue());
            }
            this.kdt.getMergeManager().mergeBlock(i, 1, i, 4);
            row.getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        }
        if (this.isBankProperty && this.kdt.getRowCount() > 0) {
            this.addTotalRow(this.getResString("andCount"), openTotal, closeTotal, modifyTotal);
            for (String key : openMap.keySet()) {
                String totalTitle = key + this.getResString("andCount");
                int openCount = (Integer)openMap.get(key);
                int closeCount = 0;
                int modifyCount = 0;
                if (closeMap.containsKey(key)) {
                    closeCount = (Integer)closeMap.get(key);
                }
                if (modifyMap.containsKey(key)) {
                    modifyCount = (Integer)modifyMap.get(key);
                }
                this.addTotalRow(totalTitle, openCount, closeCount, modifyCount);
            }
        } else {
            this.kdt.getMergeManager().mergeBlock(this.kdt.getRowCount() - 1, 0, this.kdt.getRowCount() - 1, 4);
        }
    }

    private int getCellIntValue(String cellName, IRow row) {
        if (row.getCell(cellName) != null && row.getCell(cellName).getValue() != null && !StringUtil.isEmpty((String)row.getCell(cellName).getValue().toString())) {
            return Integer.valueOf(row.getCell(cellName).getValue().toString());
        }
        return 0;
    }

    protected void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void setRowValue(IRowSet rs, IRow row, boolean isClosed) throws SQLException {
        row.getCell("company").setValue((Object)rs.getString("company"));
        row.getCell("bank").setValue((Object)rs.getString("bank"));
        row.getCell("property.name").setValue((Object)rs.getString("propertyName"));
        row.getCell("bankAccountNumber").setValue((Object)rs.getString("bankAccountNumber"));
        row.getCell("accountBankName").setValue((Object)rs.getString("accountBankName"));
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        if (rs.getBoolean("modifyCount")) {
            row.getCell("changeDate").setValue((Object)dtformat.format(rs.getDate("openDate")));
            row.getCell("isClosed").setValue((Object)this.getResString("type_modify"));
            row.getCell("openCount").setValue((Object)"0");
            row.getCell("closeCount").setValue((Object)"0");
            row.getCell("modifyCount").setValue((Object)"1");
        } else {
            if (isClosed) {
                row.getCell("changeDate").setValue((Object)dtformat.format(rs.getDate("closeDate")));
                row.getCell("isClosed").setValue((Object)(rs.getBoolean("isClosed") ? this.getResString("type_close") : this.getResString("type_open")));
                row.getCell("openCount").setValue((Object)"0");
                row.getCell("closeCount").setValue((Object)"1");
            } else {
                row.getCell("changeDate").setValue((Object)dtformat.format(rs.getDate("openDate")));
                row.getCell("isClosed").setValue((Object)this.getResString("type_open"));
                row.getCell("openCount").setValue((Object)"1");
                row.getCell("closeCount").setValue((Object)"0");
            }
            row.getCell("modifyCount").setValue((Object)"0");
        }
        row.getCell("id").setValue((Object)rs.getString("id"));
        row.getCell("companyId").setValue((Object)rs.getString("companyId"));
        row.getCell("propertyNumber").setValue((Object)rs.getString("property"));
        row.getCell("acctId").setValue((Object)rs.getString("acctId"));
    }

    private int getTabNext(IRowSet rs) throws SQLException {
        int next = 0;
        if (this.kdt.getRowCount() == 0) {
            return 0;
        }
        for (int i = this.kdt.getRowCount() - 1; i >= 0; --i) {
            String property;
            String propertyRS;
            IRow kdRow = this.kdt.getRow(i);
            if (!kdRow.getCell("isClosed").getValue().toString().equals(this.getResString("type_open")) || (propertyRS = rs.getString("propertyName")).compareTo(property = kdRow.getCell("propertyNumber").getValue().toString()) < 0) continue;
            next = i + 1;
            break;
        }
        return next;
    }
}

