/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.client.AbstractRptAccountBankUsageAnalysisFilterUI;
import com.kingdee.eas.basedata.assistant.client.RptAccountBankUsageAnalysisFilterParam;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class RptAccountBankUsageAnalysisFilterUI
extends AbstractRptAccountBankUsageAnalysisFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(RptAccountBankUsageAnalysisFilterUI.class);
    private static String RESOURCE_PATH_LOCAL = "com.kingdee.eas.basedata.assistant.client.RptAccountBankDetailResource";

    public RptAccountBankUsageAnalysisFilterUI() throws Exception {
        F7SelectorFactory.initBankTree((IUIObject)this, this.prmtBank);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public Object getParam() {
        RptAccountBankUsageAnalysisFilterParam param = new RptAccountBankUsageAnalysisFilterParam();
        param.setCompanyIdSet(this.getIdSetFromF7(this.prmtCompany));
        param.setBankIdSet(this.getIdSetFromF7(this.prmtBank));
        java.util.Date dateFrom = DateTimeUtils.truncateDate((java.util.Date)this.rptLDFDateFrom.getSqlDate());
        param.setDateFrom(new Date(dateFrom.getTime()));
        java.util.Date dateTo = DateTimeUtils.truncateDate((java.util.Date)this.rptLDFDateTo.getSqlDate());
        param.setDateTo(new Date(dateTo.getTime()));
        param.setCurrencySet(this.getIdSetFromF7(this.prmtCurrency));
        if (this.chkShowSumLine.isSelected()) {
            param.setIncludeCount(true);
        } else {
            param.setIncludeCount(false);
        }
        if (this.rbnInOrOut.isSelected()) {
            param.setFolwTo(0);
        } else if (this.rbnIn.isSelected()) {
            param.setFolwTo(1);
        } else if (this.rbnOut.isSelected()) {
            param.setFolwTo(2);
        }
        return param;
    }

    @Override
    public void setParam(Object param) {
        RptAccountBankUsageAnalysisFilterParam loParam = (RptAccountBankUsageAnalysisFilterParam)param;
        try {
            this.setCompanyIdSet(loParam.getCompanyIdSet());
            this.prmtBank.setData((Object)this.getBaseInfoFromIdSet(loParam.getBankIdSet()));
            this.prmtCurrency.setValue((Object)this.getBaseInfoFromIdSet(loParam.getCurrencySet()));
            this.rptLDFDateFrom.setValue((Object)loParam.getDateFrom());
            this.rptLDFDateTo.setValue((Object)loParam.getDateTo());
            this.chkShowSumLine.setSelected(loParam.isIncludeCount());
            if (loParam.folwTo == 0) {
                this.rbnInOrOut.setSelected(true);
                this.rbnIn.setSelected(false);
                this.rbnOut.setSelected(false);
            } else if (loParam.folwTo == 1) {
                this.rbnInOrOut.setSelected(false);
                this.rbnIn.setSelected(true);
                this.rbnOut.setSelected(false);
            } else if (loParam.folwTo == 2) {
                this.rbnInOrOut.setSelected(false);
                this.rbnIn.setSelected(false);
                this.rbnOut.setSelected(true);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void rbnInOrOut_actionPerformed(ActionEvent e) throws Exception {
        super.rbnInOrOut_actionPerformed(e);
        if (this.rbnInOrOut.isSelected()) {
            this.rbnOut.setSelected(false);
            this.rbnIn.setSelected(false);
        }
    }

    @Override
    protected void rbnOut_actionPerformed(ActionEvent e) throws Exception {
        super.rbnOut_actionPerformed(e);
        if (this.rbnOut.isSelected()) {
            this.rbnInOrOut.setSelected(false);
            this.rbnIn.setSelected(false);
        }
    }

    @Override
    protected void rbnIn_actionPerformed(ActionEvent e) throws Exception {
        super.rbnIn_actionPerformed(e);
        if (this.rbnIn.isSelected()) {
            this.rbnInOrOut.setSelected(false);
            this.rbnOut.setSelected(false);
        }
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.doInit();
    }

    @Override
    public void clear() {
        super.clear();
        this.doInit();
    }

    private void doInit() {
        this.initFirstDayOfMonth(this.rptLDFDateFrom);
        this.initLastDayOfMonth(this.rptLDFDateTo);
        this.prmtCompany.setValue((Object)this.currentCompany);
    }

    private void initFirstDayOfMonth(KDDatePicker kdDate) {
        java.util.Date date = new java.util.Date();
        GregorianCalendar firstDay = new GregorianCalendar();
        firstDay.add(5, -(date.getDate() - 1));
        kdDate.setValue((Object)firstDay.getTime());
    }

    private void initLastDayOfMonth(KDDatePicker kdDate) {
        java.util.Date date = new java.util.Date();
        GregorianCalendar lastDay = new GregorianCalendar();
        lastDay.add(2, 1);
        lastDay.add(5, -date.getDate());
        kdDate.setValue((Object)lastDay.getTime());
    }

    @Override
    public boolean verify() {
        Date kdDateFrom = this.rptLDFDateFrom.getSqlDate();
        Date kdDateTo = this.rptLDFDateTo.getSqlDate();
        if (kdDateFrom == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH_LOCAL, (String)"staVerify"));
            SysUtil.abort();
        }
        if (kdDateTo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH_LOCAL, (String)"endVerify"));
            SysUtil.abort();
        }
        if (kdDateFrom.compareTo(kdDateTo) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH_LOCAL, (String)"verify"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public CompanyOrgUnitInfo getCurrentCompany() {
        if (null == this.currentCompany) {
            this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        return this.currentCompany;
    }

    public boolean isVirtualBody() {
        try {
            return ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.getCurrentCompany());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
    }

    @Override
    protected Class getParamClass() {
        return RptAccountBankUsageAnalysisFilterParam.class;
    }

    @Override
    public void initCompanyState() {
        this.chkIA.setEnabled(false);
        this.btnCompanySelect.setEnabled(false);
        this.btnCompanySelect.setVisible(false);
    }

    @Override
    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    @Override
    public boolean isSupportMultiOrgs() {
        return true;
    }
}

