/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.client.RptAccountBankUsageAnalysisFilterParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class RptAccountBankUsageAnalysisHandler
extends FMDetailRptBaseHandler {
    public static final String RESOURCE_PATH_LOCAL = "com.kingdee.eas.basedata.assistant.client.RptAccountBankUsageAnalysisResource";
    protected RptAccountBankUsageAnalysisFilterParam param;

    public RptAccountBankUsageAnalysisHandler(RptAccountBankUsageAnalysisFilterParam param, KDTable kdt) {
        super(param.getFilter(), param.getSorterItems(), kdt);
        this.sorter = param.getSorterItems();
        this.param = param;
    }

    public static SorterItemCollection getSorter() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("company"));
        return sorter;
    }

    protected String getResString(String key) {
        return EASResource.getString((String)RESOURCE_PATH_LOCAL, (String)key);
    }

    @Override
    protected String getQueryPath() {
        return "com.kingdee.eas.basedata.assistant.app.RptAccountBankDetailQuery";
    }

    @Override
    public void initHeader() {
        super.initHeader();
        this.insertHeadRow();
        this.formatHeadRow();
    }

    protected void insertHeadRow() {
        IColumn colCompany = this.kdt.addColumn();
        colCompany.setKey("companyName");
        colCompany.setMergeable(true);
        colCompany.setGroup(true);
        colCompany.setWidth(250);
        IColumn colBank = this.kdt.addColumn();
        colBank.setKey("bankName");
        colBank.setWidth(200);
        colBank.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        colBank.getStyleAttributes().setHided(false);
        IColumn colNumber = this.kdt.addColumn();
        colNumber.setKey("acctBankNumber");
        colNumber.setWidth(250);
        colNumber.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        colNumber.getStyleAttributes().setHided(false);
        IColumn colBankAccountNumber = this.kdt.addColumn();
        colBankAccountNumber.setKey("acctBankBankAccountNumber");
        colBankAccountNumber.setWidth(300);
        colBankAccountNumber.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        colBankAccountNumber.getStyleAttributes().setHided(false);
        IColumn colAccountBankName = this.kdt.addColumn();
        colAccountBankName.setKey("acctBankName");
        colAccountBankName.setWidth(200);
        colAccountBankName.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        colAccountBankName.getStyleAttributes().setHided(false);
        IColumn colcurrencyName = this.kdt.addColumn();
        colcurrencyName.setKey("currencyName");
        colcurrencyName.setWidth(100);
        colcurrencyName.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        colcurrencyName.getStyleAttributes().setHided(false);
        IColumn colFlowTo = this.kdt.addColumn();
        colFlowTo.setKey("flowTo");
        colFlowTo.setWidth(100);
        colFlowTo.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        colFlowTo.getStyleAttributes().setHided(false);
        IColumn colFlow = this.kdt.addColumn();
        colFlow.setKey("flow");
        colFlow.setWidth(200);
        colFlow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        colFlow.getStyleAttributes().setHided(false);
        IColumn colTransNumber = this.kdt.addColumn();
        colTransNumber.setKey("transNumber");
        colFlow.setWidth(100);
        colFlow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        colTransNumber.getStyleAttributes().setHided(false);
        IColumn colCompanyId = this.kdt.addColumn();
        colCompanyId.setKey("companyId");
        colCompanyId.getStyleAttributes().setHided(true);
        IColumn colCurrencyId = this.kdt.addColumn();
        colFlow.setWidth(100);
        colCurrencyId.setKey("currencyId");
        colCurrencyId.getStyleAttributes().setHided(true);
        IColumn colAcctBankId = this.kdt.addColumn();
        colAcctBankId.setKey("acctBankId");
        colAcctBankId.getStyleAttributes().setHided(true);
        IColumn colDateFrom = this.kdt.addColumn();
        colDateFrom.setKey("dateFrom");
        colDateFrom.getStyleAttributes().setHided(true);
        IColumn colDateTo = this.kdt.addColumn();
        colDateTo.setKey("dateTo");
        colDateTo.getStyleAttributes().setHided(true);
    }

    protected void formatHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("companyName").setValue((Object)this.getResString("companyName"));
        headRow.getCell("bankName").setValue((Object)this.getResString("bankName"));
        headRow.getCell("acctBankNumber").setValue((Object)this.getResString("acctBankNumber"));
        headRow.getCell("acctBankBankAccountNumber").setValue((Object)this.getResString("bankaccountNumber"));
        headRow.getCell("acctBankName").setValue((Object)this.getResString("acctBankName"));
        headRow.getCell("currencyName").setValue((Object)this.getResString("currencyName"));
        headRow.getCell("flowTo").setValue((Object)this.getResString("flowTo"));
        headRow.getCell("flow").setValue((Object)this.getResString("flow"));
        headRow.getCell("transNumber").setValue((Object)this.getResString("transNumber"));
        headRow.getCell("companyId").setValue((Object)this.getResString("companyId"));
        headRow.getCell("acctBankId").setValue((Object)this.getResString("acctBankId"));
        headRow.getCell("currencyId").setValue((Object)this.getResString("currencyId"));
    }

    @Override
    public IRowSet getRowSet() throws BOSException {
        IRowSet rowset = null;
        StringBuffer sql = new StringBuffer();
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        sql.append("SELECT COMPANY.FID AS companyId, CURRENCY.FNAME_L2 AS currencyName , COMPANY.FName_l2 AS companyName,ACCOUNTBANK.FBank AS bankId, BANK.FName_l2 AS bankName,BANK.FNumber AS bankNumber, ");
        sql.append(" ACCOUNTBANK.FNumber AS acctBankNumber, ACCOUNTBANK.FBankAccountNumber AS acctBankBankAccountNumber, ");
        sql.append(" ACCOUNTBANK.FName_l2 AS acctBankName, A .* ");
        sql.append(" FROM (");
        sql.append(" SELECT JOURNAL.FCurrencyID AS currencyId ,JOURNAL.FAccountBankID AS acctBankId, '\u6d41\u51fa' AS flowTo , ");
        sql.append(" sum(JOURNAL.FCreditAmount) AS flow, count(JOURNAL.FDebitAmount) AS transNumber");
        sql.append(" FROM T_CAS_Journal AS JOURNAL");
        sql.append(" INNER JOIN T_BD_AccountBanks AS ACCOUNTBANK ON JOURNAL.FAccountBankID = ACCOUNTBANK.FID ");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANY ON JOURNAL.FCompanyID = COMPANY.FID");
        sql.append(" LEFT OUTER JOIN T_PM_User AS CASHIER ON JOURNAL.FCashierId = CASHIER.FID");
        sql.append(" WHERE JOURNAL.FCreditAmount !=0");
        if (this.param.getCompanyIdSet() != null && this.param.getCompanyIdSet().size() > 0) {
            sql.append(" and JOURNAL.FCompanyID in (" + BirtUtils.idListToInClause((Collection)this.param.getCompanyIdSet()) + ") ");
        }
        if (this.param.getBankIdSet() != null && this.param.getBankIdSet().size() > 0) {
            sql.append(" and ACCOUNTBANK.Fbank in (" + BirtUtils.idListToInClause((Collection)this.param.getBankIdSet()) + ") ");
        }
        if (this.param.getCurrencySet() != null && this.param.getCurrencySet().size() > 0) {
            sql.append(" and JOURNAL.FCurrencyId in (" + BirtUtils.idListToInClause((Collection)this.param.getCurrencySet()) + ") ");
        }
        if (this.param.getDateFrom() != null) {
            sql.append(" and JOURNAL.FCreateDate  >= {ts'" + dtformat.format(this.param.getDateFrom()) + "'}");
        }
        if (this.param.getDateTo() != null) {
            sql.append(" and JOURNAL.FCreateDate <= {ts'" + dtformat.format(this.param.getDateTo()) + "'}");
        }
        sql.append(" GROUP BY JOURNAL.FAccountBankID ,JOURNAL.FCurrencyID");
        sql.append(" UNION ALL");
        sql.append(" SELECT JOURNAL.FCurrencyID AS currencyId ,JOURNAL.FAccountBankID AS acctBankId, '\u6d41\u5165' AS flowTo ,");
        sql.append(" sum(JOURNAL.FDebitAmount) AS flow,count(JOURNAL.FCreditAmount) AS transNumber");
        sql.append(" FROM T_CAS_Journal AS JOURNAL");
        sql.append(" INNER JOIN T_BD_AccountBanks AS ACCOUNTBANK ON JOURNAL.FAccountBankID = ACCOUNTBANK.FID");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANY ON JOURNAL.FCompanyID = COMPANY.FID");
        sql.append(" LEFT OUTER JOIN T_PM_User AS CASHIER ON JOURNAL.FCashierId = CASHIER.FID");
        sql.append(" WHERE JOURNAL.FDebitAmount !=0 ");
        if (this.param.getCompanyIdSet() != null && this.param.getCompanyIdSet().size() > 0) {
            sql.append(" and JOURNAL.FCompanyID in (" + BirtUtils.idListToInClause((Collection)this.param.getCompanyIdSet()) + ") ");
        }
        if (this.param.getBankIdSet() != null && this.param.getBankIdSet().size() > 0) {
            sql.append(" and ACCOUNTBANK.Fbank in (" + BirtUtils.idListToInClause((Collection)this.param.getBankIdSet()) + ") ");
        }
        if (this.param.getCurrencySet() != null && this.param.getCurrencySet().size() > 0) {
            sql.append(" and JOURNAL.FCurrencyId in (" + BirtUtils.idListToInClause((Collection)this.param.getCurrencySet()) + ") ");
        }
        if (this.param.getDateFrom() != null) {
            sql.append(" and JOURNAL.FCreateDate  >= {ts'" + dtformat.format(this.param.getDateFrom()) + "'}");
        }
        if (this.param.getDateTo() != null) {
            sql.append(" and JOURNAL.FCreateDate <= {ts'" + dtformat.format(this.param.getDateTo()) + "'}");
        }
        sql.append(" GROUP BY JOURNAL.FAccountBankID ,JOURNAL.FCurrencyID ");
        sql.append(" ) AS A ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountBanks AS ACCOUNTBANK ON A .acctBankId = ACCOUNTBANK.FID");
        sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANY ON ACCOUNTBANK.FCompanyID = COMPANY.FID");
        sql.append(" LEFT OUTER JOIN T_BD_Bank AS BANK ON ACCOUNTBANK.FBank = BANK.FID");
        sql.append(" INNER JOIN T_BD_Currency AS CURRENCY ON A.currencyId = CURRENCY.FID");
        if (this.param.getFolwTo() == 1) {
            sql.append(" WHERE  A.flowTo = '\u6d41\u5165'");
        } else if (this.param.getFolwTo() == 2) {
            sql.append(" WHERE  A.flowTo = '\u6d41\u51fa'");
        }
        sql.append(" AND 1=1 ORDER BY  companyName ASC ,bankNumber ASC ,acctBankNumber ASC,currencyName ASC, flowTo ASC");
        try {
            rowset = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return rowset;
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            this.setRowValue(rs, row);
            this.initDecimalCell(row.getCell("flow"));
            row.getCell("transNumber").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public void endDataFill() {
        super.endDataFill();
        if (this.param.isIncludeCount()) {
            this.templateTotal();
        }
    }

    private void addTotalRow(int rowIndex, String key, String totalTitle, BigDecimal flow, long transNumber) {
        IRow totalRow = this.kdt.addRow(rowIndex);
        totalRow.getCell("acctBankId").setValue((Object)key);
        totalRow.getCell("flow").setValue((Object)flow);
        totalRow.getCell("flow").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        totalRow.getCell("transNumber").setValue((Object)transNumber);
        totalRow.getCell("transNumber").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        totalRow.getCell("transNumber").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.initDecimalCell(totalRow.getCell("flow"));
        totalRow.getCell("bankName").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        totalRow.getCell("acctBankNumber").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        totalRow.getCell("acctBankBankAccountNumber").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        totalRow.getCell("acctBankName").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        totalRow.getCell("currencyName").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        totalRow.getCell("flowTo").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        totalRow.getCell(1).setValue((Object)totalTitle);
        this.kdt.getMergeManager().mergeBlock(totalRow.getRowIndex(), 2, totalRow.getRowIndex(), 4);
    }

    private void templateTotal() {
        int rowCount = 0;
        HashMap<String, BigDecimal> fowTotalMap = new HashMap<String, BigDecimal>();
        HashMap<String, Long> transNumberMap = new HashMap<String, Long>();
        LinkedHashMap<String, Integer> rowCountMap = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < this.kdt.getRowCount(); ++i) {
            Number flow;
            String acctBankId;
            IRow row = this.kdt.getRow(i);
            String string = acctBankId = row.getCell("acctBankId").getValue() == null ? "" : row.getCell("acctBankId").getValue().toString();
            if (StringUtil.isEmpty((String)acctBankId)) continue;
            if (fowTotalMap.containsKey(acctBankId)) {
                flow = (BigDecimal)fowTotalMap.get(acctBankId);
                fowTotalMap.put(acctBankId, ((BigDecimal)flow).add(new BigDecimal((String)row.getCell("flow").getValue())));
            } else {
                fowTotalMap.put(acctBankId, new BigDecimal((String)row.getCell("flow").getValue()));
            }
            if (transNumberMap.containsKey(acctBankId)) {
                flow = (Long)transNumberMap.get(acctBankId);
                transNumberMap.put(acctBankId, (Long)flow + Long.valueOf((String)row.getCell("transNumber").getValue()));
            } else {
                transNumberMap.put(acctBankId, Long.valueOf((String)row.getCell("transNumber").getValue()));
            }
            if (i + 1 <= this.kdt.getRowCount() - 1) {
                if (row.getCell("acctBankId").getValue().equals(this.kdt.getRow(i + 1).getCell("acctBankId").getValue())) continue;
                rowCountMap.put((String)row.getCell("acctBankId").getValue(), i + 1 + rowCount);
                ++rowCount;
                continue;
            }
            rowCountMap.put((String)row.getCell("acctBankId").getValue(), i + 1 + rowCount);
        }
        if (this.kdt.getRowCount() > 0) {
            for (String key : rowCountMap.keySet()) {
                String totalTitle = this.getResString("count");
                BigDecimal fowTotalTmp = (BigDecimal)fowTotalMap.get(key);
                long transNumberTmp = 0L;
                if (transNumberMap.containsKey(key)) {
                    transNumberTmp = (Long)transNumberMap.get(key);
                }
                this.addTotalRow((Integer)rowCountMap.get(key), key, totalTitle, fowTotalTmp, transNumberTmp);
            }
        } else {
            this.kdt.getMergeManager().mergeBlock(this.kdt.getRowCount() - 1, 2, this.kdt.getRowCount() - 1, 4);
        }
    }

    protected void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat("0.00");
    }

    private void setRowValue(IRowSet rs, IRow row) throws SQLException {
        row.getCell("companyName").setValue((Object)rs.getString("companyName"));
        row.getCell("bankName").setValue((Object)rs.getString("bankName"));
        row.getCell("acctBankNumber").setValue((Object)rs.getString("acctBankNumber"));
        row.getCell("acctBankBankAccountNumber").setValue((Object)rs.getString("acctBankBankAccountNumber"));
        row.getCell("acctBankName").setValue((Object)rs.getString("acctBankName"));
        row.getCell("currencyName").setValue((Object)rs.getString("currencyName"));
        row.getCell("flowTo").setValue((Object)rs.getString("flowTo"));
        row.getCell("flow").setValue((Object)rs.getString("flow"));
        row.getCell("transNumber").setValue((Object)rs.getString("transNumber"));
        row.getCell("companyId").setValue((Object)rs.getString("companyId"));
        row.getCell("acctBankId").setValue((Object)rs.getString("acctBankId"));
        row.getCell("currencyId").setValue((Object)rs.getString("currencyId"));
        row.getCell("dateFrom").setValue((Object)this.param.getDateFrom());
        row.getCell("dateTo").setValue((Object)this.param.getDateTo());
    }

    @Override
    public void setTableStateRow() {
    }
}

