/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.client.AbstractRptAccountBankUsageAnalysisUI;
import com.kingdee.eas.basedata.assistant.client.RptAccountBankUsageAnalysisFilterParam;
import com.kingdee.eas.basedata.assistant.client.RptAccountBankUsageAnalysisFilterUI;
import com.kingdee.eas.basedata.assistant.client.RptAccountBankUsageAnalysisHandler;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.BankJournalFilterParam;
import com.kingdee.eas.fi.cas.client.BankJournalListUI;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptAccountBankUsageAnalysisUI
extends AbstractRptAccountBankUsageAnalysisUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(RptAccountBankUsageAnalysisUI.class);
    public static final String RESOURCE_PATH_GENRAL = "com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource";
    public static final String RESOURCE_PATH_LOCAL = "com.kingdee.eas.basedata.assistant.client.RptAccountBankUsageAnalysisResource";
    private FMFilterBaseUI filterUI = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected KDTable getMainTable() {
        return this.tblMain;
    }

    @Override
    protected void execQuery() throws BOSException {
        RptAccountBankUsageAnalysisHandler handler = null;
        this.tblMain.checkParsed();
        this.tblMain.getMergeManager().setDataMode(0);
        RptAccountBankUsageAnalysisFilterParam param = (RptAccountBankUsageAnalysisFilterParam)this.getFilterParam();
        if (param == null) {
            return;
        }
        handler = new RptAccountBankUsageAnalysisHandler(param, this.getMainTable());
        Date from = param.getDateFrom();
        Date to = param.getDateTo();
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        String txt = MessageFormat.format(EASResource.getString((String)RESOURCE_PATH_GENRAL, (String)"149_RptAccountBankDetailMainUIFromTo"), dtformat.format(from), dtformat.format(to));
        this.lab.setText(txt);
        if (param.getCurrencySet() != null && !param.getCurrencySet().isEmpty()) {
            Object[] currencyIds = param.getCurrencySet().toArray();
            CurrencyInfo currency = null;
            try {
                currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyIds[0].toString()));
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            this.currency.setText(currency.getName());
            this.unit.setText(currency.getBaseUnit());
        } else {
            this.currency.setText(EASResource.getString((String)RESOURCE_PATH_GENRAL, (String)"207_RptAccountBankUsageAnalysisUI"));
            this.unit.setText("");
        }
        handler.initHeader();
        handler.setTableStateRow();
        IRowSet rs = handler.getRowSet();
        try {
            handler.filldata(rs);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        handler.endDataFill();
        this.unit.setVisible(false);
        this.kDLabel3.setVisible(false);
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptAccountBankUsageAnalysisFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            IRow row = this.tblMain.getRow(selectBlock.getTop());
            String count = EASResource.getString((String)RESOURCE_PATH_LOCAL, (String)"count");
            if (row.getCell(1).getValue().equals(count)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH_LOCAL, (String)"totalCountMsg"));
                SysUtil.abort();
            }
            BankJournalFilterParam param = new BankJournalFilterParam();
            param.setCompanyId(row.getCell("companyId").getValue().toString());
            param.setToDate((Date)row.getCell("dateTo").getValue());
            param.setFromDate((Date)row.getCell("dateFrom").getValue());
            if (row.getCell("flowTo").getValue().equals("\u6d41\u5165")) {
                param.setFlow(1);
            } else {
                param.setFlow(2);
            }
            param.setShowCancelAccount(true);
            param.setShowBeginBalance(true);
            param.setShowDayTotal(true);
            param.setShowMonthTotal(true);
            param.setShowYearTotal(true);
            param.setByDay(true);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
            uiContext.put((Object)"acctBankId", (Object)row.getCell("acctBankId").getValue().toString());
            uiContext.put((Object)"currencyId", (Object)row.getCell("currencyId").getValue().toString());
            uiContext.put((Object)"filterParam", (Object)param);
            uiContext.put((Object)"Owner", (Object)this);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(BankJournalListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH_LOCAL, (String)"noSelectedRow"));
            SysUtil.abort();
        }
    }
}

