/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

public class CheckUtils {
    public static boolean isEmpty(Object val) {
        if (val == null) {
            return true;
        }
        if (val instanceof String) {
            return StringUtils.isEmpty((String)((String)val));
        }
        if (val instanceof Integer) {
            return (Integer)val == 0;
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).intValue() == 0;
        }
        if (val instanceof Collection) {
            return ((Collection)val).size() == 0;
        }
        if (val instanceof Boolean) {
            return (Boolean)val != true;
        }
        if (val instanceof Object[]) {
            return ((Object[])val).length == 0;
        }
        if (val instanceof IObjectCollection) {
            return ((IObjectCollection)val).size() == 0;
        }
        if (CheckUtils.isArray(val) || val.getClass() == int[].class || val.getClass() == double[].class || val.getClass() == boolean[].class || val.getClass() == char[].class || val.getClass() == short[].class || val.getClass() == long[].class || val.getClass() == float[].class) {
            return Array.getLength(val) == 0;
        }
        return val == null;
    }

    public static boolean exist(Object val) {
        return !CheckUtils.isEmpty(val);
    }

    public static boolean hasWord(String str, String word) {
        if (str == null) {
            return false;
        }
        return str.indexOf(word) > -1;
    }

    public static boolean hasEmpty(Object ... arr) {
        boolean ret = false;
        for (Object val : arr) {
            ret = CheckUtils.isEmpty(val);
            if (!ret) continue;
            return true;
        }
        return ret;
    }

    public static boolean existAll(Object ... arr) {
        boolean ret = true;
        for (Object val : arr) {
            ret = CheckUtils.exist(val);
            if (ret) continue;
            return false;
        }
        return ret;
    }

    public static boolean existOne(Object ... arr) {
        boolean ret = false;
        for (Object val : arr) {
            ret = CheckUtils.exist(val);
            if (!ret) continue;
            return true;
        }
        return ret;
    }

    public static int existAt(Object ... arr) {
        boolean ret = false;
        int index = -1;
        for (Object val : arr) {
            ++index;
            ret = CheckUtils.exist(val);
            if (!ret) continue;
            return index;
        }
        return index;
    }

    public static boolean isArray(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof Object[] || obj instanceof String[] || obj instanceof int[] || obj instanceof double[] || obj instanceof boolean[] || obj instanceof char[] || obj instanceof short[] || obj instanceof long[] || obj instanceof float[] || obj.getClass() == int[].class || obj.getClass() == double[].class || obj.getClass() == boolean[].class || obj.getClass() == char[].class || obj.getClass() == short[].class || obj.getClass() == long[].class || obj.getClass() == float[].class;
    }

    public static boolean same(Object a, Object b) {
        Object value;
        if (CheckUtils.isEmpty(a) && CheckUtils.isEmpty(b)) {
            return true;
        }
        if (a instanceof IObjectValue || a instanceof IObjectPK) {
            a = ConvertUtils.IDSTR(a);
        } else if (a instanceof Map) {
            a = ConvertUtils.PBOOL("isenum", a) ? ((value = ConvertUtils.PROP("value", a)) instanceof Double ? Integer.valueOf(ConvertUtils.INT(value)) : ConvertUtils.STR(value)) : ConvertUtils.IDSTR(a);
        } else if (a instanceof IntEnum) {
            a = ((IntEnum)a).getValue();
        } else if (a instanceof StringEnum) {
            a = ((StringEnum)a).getValue();
        }
        if (b instanceof IObjectValue || b instanceof IObjectPK) {
            b = ConvertUtils.IDSTR(b);
        } else if (b instanceof Map) {
            b = ConvertUtils.PBOOL("isenum", b) ? ((value = ConvertUtils.PROP("value", b)) instanceof Double ? Integer.valueOf(ConvertUtils.INT(value)) : ConvertUtils.STR(value)) : ConvertUtils.IDSTR(a);
        } else if (b instanceof IntEnum) {
            b = ((IntEnum)b).getValue();
        } else if (b instanceof StringEnum) {
            b = ((StringEnum)b).getValue();
        }
        if (a == null || b == null) {
            return a != null ? a.equals(b) : b.equals(a);
        }
        return a != null ? a.toString().equals(b.toString()) : b.toString().equals(a.toString());
    }

    public static boolean sameIn(Object a, Object ... arr) {
        for (Object o : arr = ConvertUtils.JSArgument(arr)) {
            if (!CheckUtils.same(a, o)) continue;
            return true;
        }
        return false;
    }

    public static <T> T find(Object col, Object key) {
        if (key == null) {
            return null;
        }
        if (col instanceof Map) {
            return (T)((Map)col).get(key);
        }
        if (col instanceof Object[]) {
            for (Object obj : (Object[])col) {
                if (!CheckUtils.same(obj, key)) continue;
                return (T)obj;
            }
        }
        if (col instanceof Collection) {
            for (Object obj : (Collection)col) {
                if (!CheckUtils.same(obj, key)) continue;
                return (T)obj;
            }
        }
        if (col instanceof IObjectCollection) {
            int size = ((IObjectCollection)col).size();
            for (int i = 0; i < size; ++i) {
                IObjectValue obj = ((IObjectCollection)col).getObject(i);
                if (!CheckUtils.same(obj, key)) continue;
                return (T)obj;
            }
        }
        return null;
    }
}

