/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.Each;
import com.kingdee.eas.fm.common.Oql;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.UuidException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.LinkedMap;

public class ConvertUtils {
    static SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    static SimpleDateFormat sdf3 = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z");
    public static Map BosTypeLib = new LinkedMap();

    public static boolean BOOL(Object val) {
        if (val instanceof Integer) {
            return (Integer)val == 1;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            if ("\u662f".equals(val) || "\u5426".equals(val)) {
                return "\u662f".equals(val);
            }
            return Boolean.parseBoolean((String)val);
        }
        return false;
    }

    public static int INT(Object val) {
        if (val instanceof Double) {
            return ((Double)val).intValue();
        }
        if (val instanceof Float) {
            return ((Float)val).intValue();
        }
        return Integer.parseInt(val == null ? "0" : val.toString());
    }

    public static String IDSTR(Object val) {
        IObjectPK pk = ConvertUtils.PK(val);
        return pk == null ? null : pk.toString();
    }

    public static IObjectPK PK(Object val) {
        if (val instanceof String) {
            return new ObjectStringPK(val.toString());
        }
        if (val instanceof BOSUuid) {
            return new ObjectUuidPK(val.toString());
        }
        if (val instanceof IObjectValue) {
            String id = ((IObjectValue)val).getString("id");
            return id == null ? null : new ObjectStringPK(id);
        }
        if (val instanceof Map) {
            String id = (String)((Map)val).get("id");
            return id == null ? null : new ObjectStringPK(id);
        }
        if (val instanceof IObjectPK) {
            return (IObjectPK)val;
        }
        return null;
    }

    public static String STR(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static String STR(Object obj, int trimLength) {
        String s = ConvertUtils.STR(obj);
        if (s == null) {
            return null;
        }
        if (s.length() < trimLength) {
            return s;
        }
        return s.substring(0, trimLength);
    }

    public static MetaDataPK MDPK(Object ... arr) {
        if ((arr = ConvertUtils.JSArgument(arr)).length == 1) {
            return new MetaDataPK(arr[0].toString());
        }
        if (arr.length > 1) {
            return new MetaDataPK(arr[0].toString(), arr[1].toString());
        }
        return new MetaDataPK();
    }

    public static BOSUuid UID(Object val) {
        if (val instanceof IObjectValue) {
            String id = ((IObjectValue)val).getString("id");
            return id == null ? null : BOSUuid.read((String)id);
        }
        return TypeConversionUtils.objToBOSUuid((Object)val);
    }

    public static Date DATE(Object ... val) {
        if (val == null) {
            return null;
        }
        if ((val = ConvertUtils.JSArgument(val))[0] instanceof String) {
            if (val.length == 1 || val[1] == null) {
                return ConvertUtils._2Date(val[0]);
            }
            return DateUtil.strToDate((String)val[0].toString(), (String)val[1].toString());
        }
        if (val[0] instanceof Long) {
            return new Date((Long)val[0]);
        }
        if (val[0] instanceof Date) {
            return (Date)val[0];
        }
        return null;
    }

    static Date _2Date(Object d) {
        try {
            return sdf1.parse(d.toString());
        }
        catch (ParseException parseException) {
            try {
                return sdf2.parse(d.toString());
            }
            catch (ParseException parseException2) {
                try {
                    return sdf3.parse(d.toString());
                }
                catch (ParseException parseException3) {
                    try {
                        return new Date(d.toString());
                    }
                    catch (Exception exception) {
                        try {
                            return new Date(Long.valueOf(d.toString()));
                        }
                        catch (Exception exception2) {
                            return null;
                        }
                    }
                }
            }
        }
    }

    public static EntityViewInfo newEV(Object ... arr) throws BOSException {
        if ((arr = ConvertUtils.JSArgument(arr)).length == 0) {
            return new EntityViewInfo();
        }
        if (arr.length == 1) {
            if (arr[0] instanceof String || arr[0] instanceof Oql) {
                try {
                    return new EntityViewInfo(arr[0].toString());
                }
                catch (ParserException e) {
                    e.printStackTrace();
                    throw ConvertUtils.newBOSException((Exception)((Object)e));
                }
            }
            if (arr[0] instanceof SelectorItemCollection) {
                EntityViewInfo r = new EntityViewInfo();
                r.setSelector((SelectorItemCollection)arr[0]);
                return r;
            }
            if (arr[0] instanceof FilterInfo) {
                EntityViewInfo r = new EntityViewInfo();
                r.setFilter((FilterInfo)arr[0]);
                return r;
            }
            if (arr[0] instanceof FilterItemInfo) {
                EntityViewInfo r = new EntityViewInfo();
                r.setFilter(ConvertUtils.FILTER((FilterItemInfo)arr[0]));
                return r;
            }
        }
        if (arr.length > 1) {
            EntityViewInfo ret = new EntityViewInfo();
            String selector = null;
            String filterstr = null;
            SelectorItemCollection sic = null;
            FilterInfo filter = null;
            List fitems = ConvertUtils.JSLIST(new Object[0]);
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] instanceof String) {
                    if (i == 0) {
                        selector = (String)arr[i];
                    }
                    if (i != 1) continue;
                    filterstr = (String)arr[i];
                    continue;
                }
                if (arr[i] instanceof SelectorItemCollection) {
                    sic = (SelectorItemCollection)arr[i];
                    continue;
                }
                if (arr[i] instanceof FilterInfo) {
                    filter = (FilterInfo)arr[i];
                    continue;
                }
                if (!(arr[i] instanceof FilterItemInfo)) continue;
                if (filter == null) {
                    filter = new FilterInfo();
                }
                filter.getFilterItems().add((FilterItemInfo)arr[i]);
            }
            if (CheckUtils.existOne(selector, filterstr)) {
                ret.setSelector(ConvertUtils.SIC(selector));
                ret.setFilter(ConvertUtils.FILTER(filterstr));
                return ret;
            }
            if (sic != null) {
                ret.setSelector(sic);
            }
            if (filter != null) {
                ret.setFilter(filter);
            }
            return ret;
        }
        return new EntityViewInfo();
    }

    public static <T> T TYPETO(Object val, Class<T> clazz) {
        if (clazz == String.class) {
            return (T)String.valueOf(val);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)Integer.valueOf(val.toString());
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)Boolean.valueOf(val.toString());
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)Double.valueOf(val.toString());
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)Long.valueOf(val.toString());
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)Float.valueOf(val.toString());
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)Short.valueOf(val.toString());
        }
        if (clazz == IObjectPK.class) {
            return (T)new ObjectStringPK(val.toString());
        }
        return clazz.cast(val);
    }

    public static <T> T[] ARRAY(Object col, Class<T> clazz) {
        int length = 0;
        if (col == null || clazz == null) {
            return null;
        }
        if (col instanceof Collection) {
            length = ((Collection)col).size();
        } else if (col instanceof IObjectCollection) {
            length = ((IObjectCollection)col).size();
        } else if (col instanceof Object[]) {
            length = ((Object[])col).length;
        } else if (col instanceof Map) {
            length = ((Map)col).size();
        } else if (col.getClass() == int[].class || col.getClass() == double[].class || col.getClass() == boolean[].class || col.getClass() == char[].class || col.getClass() == short[].class || col.getClass() == long[].class || col.getClass() == float[].class) {
            length = Array.getLength(col);
        }
        if (length == 0) {
            return null;
        }
        Object rs = Array.newInstance(clazz, length);
        new Each(new Object[]{col, clazz, rs}){

            public void one(int index, Object elem) {
                Class clazz = (Class)this.args[1];
                Object rs = this.args[2];
                Array.set(rs, index, ConvertUtils.TYPETO(elem, clazz));
            }
        };
        return (Object[])rs;
    }

    public static BOSObjectType BOSTYPE(Object val) {
        if (val instanceof IObjectValue) {
            return ((IObjectValue)val).getBOSType();
        }
        if (val instanceof String) {
            if (val.toString().length() == 8) {
                return BOSObjectType.create((String)val.toString());
            }
            try {
                return BOSUuid.read((String)val.toString()).getType();
            }
            catch (UuidException uuidException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (val instanceof BOSUuid) {
            return ConvertUtils.BOSTYPE(val.toString());
        }
        if (val instanceof IObjectPK) {
            return ConvertUtils.BOSTYPE(val.toString());
        }
        if (val instanceof Map) {
            if (((Map)val).containsKey("bosType")) {
                return ConvertUtils.BOSTYPE(((Map)val).get("bosType"));
            }
            if (((Map)val).containsKey("id")) {
                Object id = ((Map)val).get("id");
                return ConvertUtils.BOSTYPE(id);
            }
        }
        if (val instanceof Class) {
            Class clazz = (Class)val;
            if (IBOSObject.class.isAssignableFrom(clazz) && !clazz.isInterface()) {
                try {
                    IBOSObject obj = (IBOSObject)((Class)val).newInstance();
                    return obj.getType();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("cannot get BOSObjectType from Class:" + val.toString());
                }
            }
            if (IObjectValue.class.isAssignableFrom(clazz)) {
                try {
                    IObjectValue obj = (IObjectValue)((Class)val).newInstance();
                    return obj.getBOSType();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("cannot get BOSObjectType from Class:" + val.toString());
                }
            }
            if (BosTypeLib.containsKey(clazz)) {
                return BOSObjectType.create((String)BosTypeLib.get(clazz).toString());
            }
            if (IBizCtrl.class.isAssignableFrom(clazz)) {
                String intfName = clazz.getName();
                String className = intfName.substring(0, intfName.lastIndexOf(".") + 1) + intfName.substring(intfName.lastIndexOf(".") + 2);
                try {
                    BOSObjectType bostype = ConvertUtils.BOSTYPE(Class.forName(className));
                    BosTypeLib.put(val, bostype);
                    return bostype;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("can't get BOSObjectType from Class:" + className + " that is generated by interface:" + intfName);
                }
            }
        }
        return null;
    }

    public static Map MAP(Object map) {
        return (Map)map;
    }

    public static SelectorItemCollection SIC(Object ... arr) {
        if (CheckUtils.isEmpty(arr)) {
            return null;
        }
        String sics = "";
        SelectorItemCollection sic = null;
        for (Object val : arr) {
            if (val instanceof String) {
                sics = (String)val;
                continue;
            }
            if (!(val instanceof SelectorItemCollection)) continue;
            sic = (SelectorItemCollection)val;
        }
        SelectorItemCollection selectorItemCollection = sic = sic == null ? new SelectorItemCollection() : sic;
        if (CheckUtils.exist(sics)) {
            String[] pp = sics.split(",");
            for (int i = 0; i < pp.length; ++i) {
                sic.add(pp[i]);
            }
        }
        return sic;
    }

    public static Set SET(Object ... arr) {
        arr = ConvertUtils.JSArgument(arr);
        Set set = ConvertUtils.SET(new HashSet(), arr);
        return set;
    }

    public static List LIST(Object obj) {
        if (obj instanceof Map) {
            return ConvertUtils.Map2List((Map)obj);
        }
        if (obj instanceof Collection) {
            return ConvertUtils.JSLIST(((Collection)obj).toArray());
        }
        if (obj instanceof IObjectCollection) {
            return ConvertUtils.JSLIST(((IObjectCollection)obj).toArray());
        }
        if (obj instanceof Object[]) {
            return ConvertUtils.JSLIST((Object[])obj);
        }
        return ConvertUtils.JSLIST(obj);
    }

    public static Object ELEM2TYPE(Collection col, String type) {
        if (col == null) {
            return col;
        }
        Object[] os = col.toArray();
        col.clear();
        for (Object o : os) {
            if ("string".equalsIgnoreCase(type)) {
                col.add(ConvertUtils.STR(o));
                continue;
            }
            if ("int".equalsIgnoreCase(type)) {
                col.add(ConvertUtils.INT(o));
                continue;
            }
            if ("bigdecimal".equalsIgnoreCase(type)) {
                col.add(ConvertUtils.BDEC(o));
                continue;
            }
            if (!"boolean".equalsIgnoreCase(type)) continue;
            col.add(ConvertUtils.BOOL(o));
        }
        return col;
    }

    public static <T> T sortCollection(Object coll, String ... strArray) {
        return ConvertUtils.sortCollection(coll, strArray, true);
    }

    public static <T> T sortCollection(Object coll, final String[] strArray, final boolean isASC) {
        Object[] infoArray = null;
        if (coll instanceof Collection) {
            infoArray = ((Collection)coll).toArray();
        } else if (coll instanceof Object[]) {
            infoArray = (Object[])coll;
        }
        Arrays.sort(infoArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                return isASC ? this.compareVO(o1, o2) : this.compareVO(o2, o1);
            }

            private int compareVO(Object o1, Object o2) {
                for (int i = 0; i < strArray.length; ++i) {
                    Object val1 = null;
                    Object val2 = null;
                    if (o1 instanceof Map) {
                        val1 = ((Map)o1).get(strArray[i]);
                    }
                    if (o2 instanceof Map) {
                        val2 = ((Map)o2).get(strArray[i]);
                    }
                    if (val1 == null) {
                        if (val2 == null) continue;
                        return 1;
                    }
                    if (val2 == null) {
                        return -1;
                    }
                    if (val1 instanceof Comparable) {
                        Comparable new_name = (Comparable)val1;
                        if (new_name.compareTo(val2) == 0) continue;
                        return new_name.compareTo(val2);
                    }
                    if (val1.toString().compareTo(val2.toString()) == 0) continue;
                    return val1.toString().compareTo(val2.toString());
                }
                return 0;
            }
        });
        if (coll instanceof Collection) {
            ((Collection)coll).clear();
            if (infoArray != null) {
                for (int i = 0; i < infoArray.length; ++i) {
                    ((Collection)coll).add(infoArray[i]);
                }
            }
            return (T)coll;
        }
        if (coll instanceof Object[]) {
            return (T)infoArray;
        }
        return null;
    }

    public static List PROPS2LIST(String property, Object colOrObj) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (colOrObj instanceof Collection) {
            for (Object o : (Collection)colOrObj) {
                ret.add(ConvertUtils.PROP(property, o));
            }
        } else if (colOrObj instanceof IObjectCollection) {
            IObjectCollection col = (IObjectCollection)colOrObj;
            for (int i = 0; i < col.size(); ++i) {
                IObjectValue o = col.getObject(i);
                ret.add(ConvertUtils.PROP(property, o));
            }
        } else if (colOrObj instanceof Object[]) {
            for (Object o : (Object[])colOrObj) {
                ret.add(ConvertUtils.PROP(property, o));
            }
        } else if (colOrObj instanceof Map) {
            Object value = ConvertUtils.PROP(property, colOrObj);
            if (value instanceof Collection) {
                ret.addAll((Collection)value);
            } else {
                ret.add(value);
            }
        }
        return ret;
    }

    public static Object PROP(Object obj, String property) {
        return ConvertUtils.PROP(property, obj);
    }

    public static String PSTR(String property, Object obj) {
        return ConvertUtils.STR(ConvertUtils.PROP(property, obj));
    }

    public static String PSTR(Object obj, String property) {
        return ConvertUtils.PSTR(property, obj);
    }

    public static boolean PBOOL(String property, Object obj) {
        return ConvertUtils.BOOL(ConvertUtils.PROP(property, obj));
    }

    public static boolean PBOOL(Object obj, String property) {
        return ConvertUtils.PBOOL(property, obj);
    }

    public static int PINT(String property, Object obj) {
        return ConvertUtils.INT(ConvertUtils.PROP(property, obj));
    }

    public static int PINT(Object obj, String property) {
        return ConvertUtils.PINT(property, obj);
    }

    public static Date PDATE(String property, Object obj) {
        return ConvertUtils.DATE(ConvertUtils.PROP(property, obj));
    }

    public static Date PDATE(Object obj, String property) {
        return ConvertUtils.PDATE(property, obj);
    }

    public static BigDecimal PBDEC(String property, Object obj) {
        return ConvertUtils.BDEC(ConvertUtils.PROP(property, obj));
    }

    public static BigDecimal PBDEC(Object obj, String property) {
        return ConvertUtils.PBDEC(property, obj);
    }

    public static Object PROP(String property, Object obj) {
        String cur;
        boolean hasNext = property.indexOf(".") > -1;
        String next = null;
        if (hasNext) {
            cur = property.substring(0, property.indexOf("."));
            next = property.substring(property.indexOf(".") + 1);
        } else {
            cur = property;
        }
        if (obj instanceof Map) {
            Map m = (Map)obj;
            if (hasNext) {
                return ConvertUtils.PROP(next, m.get(cur));
            }
            return m.get(cur);
        }
        if (obj instanceof IObjectValue) {
            IObjectValue m = (IObjectValue)obj;
            if (hasNext) {
                return ConvertUtils.PROP(next, m.get(cur));
            }
            return m.get(cur);
        }
        return null;
    }

    public static Object PUT(Object obj, String property, Object value) {
        String cur;
        boolean hasNext = property.indexOf(".") > -1;
        String next = null;
        if (hasNext) {
            cur = property.substring(0, property.indexOf("."));
            next = property.substring(property.indexOf(".") + 1);
        } else {
            cur = property;
        }
        if (obj instanceof Map) {
            Map m = (Map)obj;
            if (hasNext) {
                if (m.get(cur) == null) {
                    m.put(cur, new LinkedMap());
                }
                return ConvertUtils.PUT(m.get(cur), next, value);
            }
            return m.put(cur, value);
        }
        return null;
    }

    public static String EVALLINE(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString().toString().replace("\"", "\\\"").replace("\n", "<br>");
    }

    public static Object LOC(Object obj) {
        String l;
        if (obj instanceof Map && ((Map)obj).containsKey(l = new Context().getLocale().getLanguage())) {
            return ((Map)obj).get(l);
        }
        return obj;
    }

    public static Object PROPL(String property, Object obj) {
        return ConvertUtils.LOC(ConvertUtils.PROP(property, obj));
    }

    public static Set PROPS2SET(String property, Object colOrObj) {
        return ConvertUtils.SET(ConvertUtils.PROPS2LIST(property, colOrObj));
    }

    public static String Join(String sperator, Object arr) {
        if (CheckUtils.isEmpty(arr)) {
            return null;
        }
        List l = ConvertUtils.LIST(arr);
        if (CheckUtils.isEmpty(l)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : l) {
            if (o == null) continue;
            sb.append(sperator).append(o.toString());
        }
        return sb.toString().substring(1);
    }

    public static Set SET(Set dest, Object ... arr) {
        for (Object a : arr = ConvertUtils.JSArgument(arr)) {
            if (a instanceof Collection) {
                dest.addAll((Collection)a);
                continue;
            }
            if (a instanceof IObjectCollection) {
                for (Object o : ((IObjectCollection)a).toArray()) {
                    dest.add(o);
                }
                continue;
            }
            if (a instanceof Object[]) {
                for (Object o : (Object[])a) {
                    dest.add(o);
                }
                continue;
            }
            dest.add(a);
        }
        return dest;
    }

    public static Map JSMAP(Object ... arr) {
        arr = ConvertUtils.JSArgument(arr);
        Map map = ConvertUtils.JSMAP(new LinkedHashMap(), arr);
        return map;
    }

    public static SorterItemCollection SORTER(String oql) {
        try {
            return new SorterItemCollection(oql);
        }
        catch (ParserException e) {
            throw new RuntimeException("cannot parse oql to SorterItemCollection :" + oql);
        }
    }

    public static FilterItemInfo FITEM(Object ... arr) {
        if ((arr = ConvertUtils.JSArgument(arr)).length == 0) {
            return null;
        }
        if (arr.length == 1) {
            return new FilterItemInfo(arr[0].toString());
        }
        if (arr.length == 2) {
            return new FilterItemInfo(arr[0].toString(), arr[1]);
        }
        if (arr.length == 3) {
            if (arr[2] instanceof Boolean) {
                return new FilterItemInfo(arr[0].toString(), arr[1], ConvertUtils.BOOL(arr[2]));
            }
            if (arr[2] instanceof CompareType) {
                return new FilterItemInfo(arr[0].toString(), arr[1], (CompareType)arr[2]);
            }
        }
        return null;
    }

    public static FilterItemInfo include(String field, Object cols) {
        Set values = ConvertUtils.SET(new Object[0]);
        if (cols instanceof Collection) {
            for (Object val : (Collection)cols) {
                if (val == null) continue;
                if (val instanceof IObjectValue) {
                    values.add(((IObjectValue)val).getString("id"));
                    continue;
                }
                if (val instanceof Map) {
                    values.add((String)((Map)val).get("id"));
                    continue;
                }
                if (val instanceof IObjectPK) {
                    values.add(val.toString());
                    continue;
                }
                values.add(val.toString());
            }
        } else if (cols instanceof Object[]) {
            for (Object val : (Object[])cols) {
                if (val == null) continue;
                if (val instanceof IObjectValue) {
                    values.add(((IObjectValue)val).getString("id"));
                    continue;
                }
                if (val instanceof Map) {
                    values.add((String)((Map)val).get("id"));
                    continue;
                }
                if (val instanceof IObjectPK) {
                    values.add(val.toString());
                    continue;
                }
                values.add(val.toString());
            }
        } else if (cols instanceof IObjectCollection) {
            int size = ((IObjectCollection)cols).size();
            for (int i = 0; i < size; ++i) {
                IObjectValue val = ((IObjectCollection)cols).getObject(i);
                if (val == null) continue;
                values.add(val.getString("id"));
            }
        } else if (cols.getClass() == int[].class || cols.getClass() == double[].class || cols.getClass() == boolean[].class || cols.getClass() == char[].class || cols.getClass() == short[].class || cols.getClass() == long[].class || cols.getClass() == float[].class) {
            int index = -1;
            int len = Array.getLength(cols);
            for (int i = 0; i < len; ++i) {
                Object val = Array.get(cols, i);
                if (val == null) continue;
                if (val instanceof IObjectValue) {
                    values.add(((IObjectValue)val).getString("id"));
                    continue;
                }
                if (val instanceof Map) {
                    values.add((String)((Map)val).get("id"));
                    continue;
                }
                if (val instanceof IObjectPK) {
                    values.add(val.toString());
                    continue;
                }
                values.add(val.toString());
            }
        } else if (cols instanceof IObjectValue) {
            values.add(((IObjectValue)cols).getString("id"));
        } else if (cols instanceof Map) {
            values.add((String)((Map)cols).get("id"));
        } else {
            values.add(cols.toString());
        }
        return new FilterItemInfo(field, (Object)values, CompareType.INCLUDE);
    }

    public static FilterInfo FILTER(FilterItemInfo ... arr) {
        FilterInfo filter = new FilterInfo();
        return ConvertUtils.FitemAdd(filter, arr);
    }

    public static FilterInfo FILTER(FilterInfo filter, FilterItemInfo ... arr) {
        return ConvertUtils.FitemAdd(filter, arr);
    }

    public static FilterInfo FILTER(String oql) throws BOSException {
        if (oql == null) {
            return new FilterInfo();
        }
        String soql = oql.toString();
        if (!soql.toLowerCase(Locale.ENGLISH).startsWith("where")) {
            soql = "WHERE " + soql;
        }
        EntityViewInfo ev = ConvertUtils.newEV(soql);
        return ev.getFilter();
    }

    public static FilterInfo FitemAdd(FilterInfo filter, FilterItemInfo ... arr) {
        if (filter == null) {
            return filter;
        }
        for (FilterItemInfo fitem : arr = (FilterItemInfo[])ConvertUtils.JSArgument(arr)) {
            filter.getFilterItems().add(fitem);
        }
        return filter;
    }

    public static EntityViewInfo FitemAdd(EntityViewInfo evi, FilterItemInfo ... arr) {
        if (evi == null) {
            return evi;
        }
        arr = (FilterItemInfo[])ConvertUtils.JSArgument(arr);
        if (evi.getFilter() == null) {
            evi.setFilter(new FilterInfo());
        }
        ConvertUtils.FitemAdd(evi.getFilter(), arr);
        return evi;
    }

    public static BigDecimal BDEC(Object val) {
        if (val instanceof Double) {
            return new BigDecimal((Double)val);
        }
        if (val instanceof Integer) {
            return new BigDecimal((Integer)val);
        }
        if (val instanceof BigInteger) {
            return new BigDecimal((BigInteger)val);
        }
        if (val instanceof Long) {
            return new BigDecimal((Long)val);
        }
        if (val instanceof String) {
            return new BigDecimal((String)val);
        }
        return null;
    }

    public static Map JSMAP(Map dest, Object ... arr) {
        arr = ConvertUtils.JSArgument(arr);
        Object key = null;
        for (Object a : arr) {
            if (key == null) {
                key = a;
                continue;
            }
            dest.put(key, a);
            key = null;
        }
        return dest;
    }

    public static Map JSOBJ(Object ... arr) {
        return ConvertUtils.JSMAP(arr);
    }

    public static Map JSOBJ(Map dest, Object ... arr) {
        return ConvertUtils.JSMAP(dest, arr);
    }

    public static List JSLIST(Object ... arr) {
        arr = ConvertUtils.JSArgument(arr);
        List ls = ConvertUtils.JSLIST(new ArrayList(), arr);
        return ls;
    }

    public static List Map2List(Map map) {
        int size = map.values().size();
        ArrayList l = new ArrayList();
        l.addAll(map.values());
        return l;
    }

    public static List JSLIST(List dest, Object ... arr) {
        for (Object a : arr = ConvertUtils.JSArgument(arr)) {
            dest.add(a);
        }
        return dest;
    }

    public static Object[] JSArgument(Object ... arr) {
        if (arr == null) {
            return new Object[]{null};
        }
        return arr;
    }

    public static Oql OQL(String oql) {
        return new Oql(oql);
    }

    public static BOSException newBOSException(Exception e) {
        BOSException ne = null;
        if (e instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)e).getTargetException();
            ne = new BOSException(target.toString(), target);
            ne.setStackTrace(target.getStackTrace());
        } else if (e.getCause() != null) {
            ne = new BOSException(e.getCause().toString(), e.getCause());
            ne.setStackTrace(e.getCause().getStackTrace());
        } else {
            ne = new BOSException(e.toString(), (Throwable)e);
            ne.setStackTrace(e.getStackTrace());
        }
        return ne;
    }

    public static EASBizException newEASException(String msg, Throwable ... e) {
        Object[] es = ConvertUtils.JSArgument(e);
        if (es.length == 0) {
            return new EASBizException(new NumericExceptionSubItem(null, msg));
        }
        Throwable e1 = (Throwable)es[0];
        if (e1 instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)e1).getTargetException();
            NumericExceptionSubItem ne = null;
            if (msg == null) {
                while (target.getCause() != null) {
                    target = target.getCause();
                }
                ne = new NumericExceptionSubItem(null, target.getMessage());
            } else {
                ne = new NumericExceptionSubItem(null, msg);
            }
            EASBizException ease = new EASBizException(ne, target);
            ease.setStackTrace(target.getStackTrace());
            return ease;
        }
        if (e1.getCause() != null) {
            NumericExceptionSubItem ne = new NumericExceptionSubItem(null, msg != null ? msg : e1.getCause().getMessage());
            EASBizException ease = new EASBizException(ne, e1.getCause());
            ease.setStackTrace(e1.getCause().getStackTrace());
            return ease;
        }
        NumericExceptionSubItem ne = new NumericExceptionSubItem(null, msg != null ? msg : e1.toString());
        EASBizException ease = new EASBizException(ne, e1);
        ease.setStackTrace(e1.getStackTrace());
        return ease;
    }

    public static <T> T NullAssign(Object val, Object assginObj) {
        return (T)(val == null ? assginObj : val);
    }

    public static void main(String[] args) {
    }
}

