/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeSysEnum;
import com.kingdee.eas.basedata.master.cssp.AbstractDataMergeImpl;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.DataMergeInfo;
import com.kingdee.eas.basedata.master.cssp.DataMergeTypeEnum;
import com.kingdee.eas.basedata.master.cssp.HeadDetailException;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;

public class FMCustomerMergeImpl
extends AbstractDataMergeImpl {
    protected String[] getMergeTables() {
        return new String[]{"T_FIN_Repayment", "T_FT_FundTransferBill", "T_CL_ConsignmentLoanBill", "T_NT_ReceivableBill", "T_NT_ReceivableBill", "T_NT_ReceivableBill", "T_NT_ReceivableBill", "T_NT_PayableBill", "T_NT_EndorsementBill", "T_NT_EndorsementBill", "T_NT_DiscountBill", "T_NT_PayableTransferBill", "T_CL_ConsignLoanIntBill", "T_CL_ConsingnRepaymentBill", "T_FT_FundTransferRepayBill", "T_FT_FundTransferInterestBill", "T_CTL_AssureBill", "T_CTL_BankFactorContractEntry", "T_NT_PayableApplyBill", "T_NT_DiscountBill", "T_CL_ConsignLoanExtBill", "T_CL_CLRateAdjustmentBill", "T_FT_FundTransferExtBill"};
    }

    protected String[] getMergeFields() {
        return new String[]{"FPayeeCust", "FCustomerID", "FCustomerID", "FPayeeID", "FDrawerID", "FDeliverID", "FAcceptanceCustID", "FPayee1", "FDeliverId", "FEndorsedCustomerID", "FDeliverID", "FApplyCustomerID", "FCustomerID", "FCustomerID", "FCustomerID", "FCustomerID", "FAssureCustomerID", "FClientID", "FReceiverCpID", "FDeliverID", "FCustomerID", "FCustomerID", "FCustomerID"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String merge(Context ctx, DataMergeInfo mergeInfo) throws Exception {
        int i;
        this.mergeCheck(ctx, mergeInfo);
        AsstActTypeInfo customer = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActType(AsstActTypeSysEnum.CUSTOMER);
        String destId = mergeInfo.getDestId();
        String destNumber = mergeInfo.getDestNumber();
        String destName = mergeInfo.getDestName();
        Object[] srcIds = mergeInfo.getSrcIds();
        String[] mergeTables = new String[]{"T_CAS_PaymentBill", "T_CAS_ReceivingBill", "T_CAS_TemplatePaymentBill", "T_CAS_TemplateReceivingBill"};
        String[] mergeFields = new String[]{"FPayeeID", "FPayeeNumber", "FPayeeName"};
        StringBuffer msg = new StringBuffer();
        if (customer != null) {
            String payerTypeID = customer.getId().toString();
            String pSql = "update T_CAS_PaymentBill set FPayeeID=? ,FPayeeNumber=? ,FPayeeName=? ,FPayeeName_l2=?  where FPayeeTypeID =? and " + FMHelper.buildIn("FPayeeID", mergeInfo.getSrcIds());
            String rSql = "update T_CAS_ReceivingBill set FPayerID=? ,FPayerNumber=? ,FPayerName=?,FPayerName_l2=?  where FPayerTypeID =? and " + FMHelper.buildIn("FPayerID", mergeInfo.getSrcIds());
            DbUtil.execute((Context)ctx, (String)pSql, (Object[])new Object[]{destId, destNumber, destName, destName, payerTypeID});
            DbUtil.execute((Context)ctx, (String)rSql, (Object[])new Object[]{destId, destNumber, destName, destName, payerTypeID});
            pSql = "update T_CAS_TemplatePaymentBill set FPayeeID=? ,FPayeeNumber=? ,FPayeeName=?  where FPayeeTypeID =? and " + FMHelper.buildIn("FPayeeID", mergeInfo.getSrcIds());
            rSql = "update T_CAS_TemplateReceivingBill set FPayerID=? ,FPayerNumber=? ,FPayerName=?  where FPayerTypeID =? and " + FMHelper.buildIn("FPayerID", mergeInfo.getSrcIds());
            DbUtil.execute((Context)ctx, (String)pSql, (Object[])new Object[]{destId, destNumber, destName, payerTypeID});
            DbUtil.execute((Context)ctx, (String)rSql, (Object[])new Object[]{destId, destNumber, destName, payerTypeID});
            for (int i2 = 0; i2 < mergeTables.length; ++i2) {
                for (int j = 0; j < mergeFields.length; ++j) {
                    msg.append(mergeTables[i2]).append("/").append(mergeFields[j]).append(",");
                }
            }
            msg.setCharAt(msg.length() - 1, '.');
        }
        String[] mergeTable = new String[]{"T_NT_ReceivableBill", "T_NT_ReceivableBill", "T_NT_ReceivableBill", "T_NT_PayableBill", "T_NT_PayableTransferBill", "T_NT_EndorsementBill", "T_NT_PayableTransferBill", "T_NT_ReceivableBill", "T_NT_PayableApplyBill"};
        String[] mergeField = new String[]{"FPayeeName", "FDrawerName", "FDeliverName", "FPayeeName", "FApplyName", "FEndorsee", "FApplyName", "FAcceptanceBankName", "FReceiverName"};
        String[] idField = new String[]{"FPayeeID", "FDrawerID", "FDeliverID", "FPayee1", "FApplyCustomerID", "FEndorsedCustomerID", "FApplyCustomerID", "FAcceptanceCustID", "FReceiverCpID"};
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.createStatement();
            destName = destName.replaceAll("'", "''");
            for (i = 0; i < mergeTable.length; ++i) {
                StringBuffer sb = new StringBuffer();
                sb.append(" update ").append(mergeTable[i]);
                sb.append(" set ").append(mergeField[i]).append("='").append(destName).append("' ");
                sb.append(" where ").append(idField[i]).append(" in ").append(StringUtil.getIdsSql((Object[])srcIds));
                ps.addBatch(sb.toString());
            }
            ps.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(ps, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        for (i = 0; i < mergeTables.length; ++i) {
            msg.append(mergeTable[i]).append("/").append(mergeField[i]).append(",");
        }
        msg.setCharAt(msg.length() - 1, '.');
        String superMsg = super.merge(ctx, mergeInfo);
        return ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"77_FMCustomerMergeImpl", (Locale)ctx.getOriginLocale()) + ":\n" + superMsg + "\n" + msg.toString();
    }

    public void mergeCheck(Context ctx, DataMergeInfo mergeInfo) throws Exception {
        CustomerSupplierException customerSupplierException;
        int i;
        CompanyOrgUnitCollection companyOrgCollection = this.getNoCustomerCompanyOrg(ctx, mergeInfo);
        SaleOrgUnitCollection saleOrgCollection = this.getNoCustomerSaleOrg(ctx, mergeInfo);
        String msgDetail = "";
        for (i = 0; i < companyOrgCollection.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnit = companyOrgCollection.get(i);
            customerSupplierException = new CustomerSupplierException(CustomerSupplierException.MERGEMISSINGYORGASSTDATA, (Object[])new String[]{" [" + companyOrgUnit.getNumber() + "-" + companyOrgUnit.getName() + "] ", ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"financeAttribute", (Locale)ctx.getOriginLocale())});
            msgDetail = msgDetail + customerSupplierException.getMessage() + "\n";
        }
        for (i = 0; i < saleOrgCollection.size(); ++i) {
            SaleOrgUnitInfo saleOrgUnit = saleOrgCollection.get(i);
            customerSupplierException = new CustomerSupplierException(CustomerSupplierException.MERGEMISSINGYORGASSTDATA, (Object[])new String[]{" [" + saleOrgUnit.getNumber() + "-" + saleOrgUnit.getName() + "] ", ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"saleAttribute", (Locale)ctx.getOriginLocale())});
            msgDetail = msgDetail + customerSupplierException.getMessage() + "\n";
        }
        if (msgDetail != null && msgDetail.length() > 0) {
            CustomerSupplierException headException = new CustomerSupplierException(CustomerSupplierException.MERGEMISSINGASSTDATACOLL, new Object[]{DataMergeTypeEnum.customer.getAlias()});
            throw new HeadDetailException(headException.getMessage(), msgDetail);
        }
    }

    private CompanyOrgUnitCollection getNoCustomerCompanyOrg(Context ctx, DataMergeInfo dataMergeInfo) throws Exception {
        int i;
        CompanyOrgUnitCollection result = new CompanyOrgUnitCollection();
        HashSet<String> ids = new HashSet<String>();
        ids.add(dataMergeInfo.getDestId());
        for (int i2 = 0; i2 < dataMergeInfo.getSrcIds().length; ++i2) {
            ids.add(dataMergeInfo.getSrcIds()[i2]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("customer.id", ids, CompareType.INCLUDE));
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("companyOrgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("companyOrgUnit.name"));
        viewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        CustomerCompanyInfoCollection destAsstDataCollection = new CustomerCompanyInfoCollection();
        CustomerCompanyInfoCollection srcAsstDataCollection = new CustomerCompanyInfoCollection();
        int size = collection.size();
        for (i = 0; i < size; ++i) {
            CustomerCompanyInfoInfo info = (CustomerCompanyInfoInfo)collection.get(i);
            if (info.getCustomer().getId().toString().equals(dataMergeInfo.getDestId())) {
                destAsstDataCollection.add(info);
                continue;
            }
            srcAsstDataCollection.add(info);
        }
        size = srcAsstDataCollection.size();
        for (i = 0; i < size; ++i) {
            CompanyOrgUnitInfo companyOrgUnit = srcAsstDataCollection.get(i).getCompanyOrgUnit();
            if (this.isInCollection(companyOrgUnit, destAsstDataCollection)) continue;
            result.add(companyOrgUnit);
        }
        return result;
    }

    private SaleOrgUnitCollection getNoCustomerSaleOrg(Context ctx, DataMergeInfo dataMergeInfo) throws Exception {
        int i;
        SaleOrgUnitCollection result = new SaleOrgUnitCollection();
        HashSet<String> ids = new HashSet<String>();
        ids.add(dataMergeInfo.getDestId());
        for (int i2 = 0; i2 < dataMergeInfo.getSrcIds().length; ++i2) {
            ids.add(dataMergeInfo.getSrcIds()[i2]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("customer.id", ids, CompareType.INCLUDE));
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("saleOrgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("saleOrgUnit.name"));
        viewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = CustomerSaleInfoFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        CustomerSaleInfoCollection destAsstDataCollection = new CustomerSaleInfoCollection();
        CustomerSaleInfoCollection srcAsstDataCollection = new CustomerSaleInfoCollection();
        int size = collection.size();
        for (i = 0; i < size; ++i) {
            CustomerSaleInfoInfo info = (CustomerSaleInfoInfo)collection.get(i);
            if (info.getCustomer().getId().toString().equals(dataMergeInfo.getDestId())) {
                destAsstDataCollection.add(info);
                continue;
            }
            srcAsstDataCollection.add(info);
        }
        size = srcAsstDataCollection.size();
        for (i = 0; i < size; ++i) {
            SaleOrgUnitInfo saleOrgUnit = srcAsstDataCollection.get(i).getSaleOrgUnit();
            if (this.isInCollection(saleOrgUnit, destAsstDataCollection)) continue;
            result.add(saleOrgUnit);
        }
        return result;
    }

    private boolean isInCollection(CompanyOrgUnitInfo companyOrgUnit, CustomerCompanyInfoCollection collection) {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            CustomerCompanyInfoInfo customerCompanyInfo = collection.get(i);
            if (!companyOrgUnit.getId().equals((Object)customerCompanyInfo.getCompanyOrgUnit().getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isInCollection(SaleOrgUnitInfo saleOrgUnit, CustomerSaleInfoCollection collection) {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            CustomerSaleInfoInfo customerSaleInfo = collection.get(i);
            if (!saleOrgUnit.getId().equals((Object)customerSaleInfo.getSaleOrgUnit().getId())) continue;
            return true;
        }
        return false;
    }
}

