/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FmSysStatusCtrlUtils {
    private static final Logger logger = CoreUIObject.getLogger(FmSysStatusCtrlUtils.class);

    public static Map isStart(Context ctx, int system, Set companyIdSet) throws BOSException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        Iterator iter = companyIdSet.iterator();
        while (iter.hasNext()) {
            map.put((String)iter.next(), Boolean.FALSE);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select sysStaCtr.FCompanyID companyId \n");
        sql.append(" from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta \n");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID \n");
        sql.append(" and sysStaCtr.FCompanyID IN \n");
        sql.append(FMHelper.setTran2String(companyIdSet));
        sql.append(" and sysSta.FName=");
        sql.append(system);
        sql.append(" and sysStaCtr.FIsStart=1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                map.put(rs.getString("companyId"), Boolean.TRUE);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private static Map getPeriod(Context ctx, int system, Set companyIdSet, int type) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iter = companyIdSet.iterator();
        while (iter.hasNext()) {
            map.put((String)iter.next(), null);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select sysStaCtr.FCompanyID companyId, FStartPeriodID, FCurrentPeriodID \n");
        sql.append(" from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta \n");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID \n");
        sql.append(" and sysStaCtr.FCompanyID IN ");
        sql.append(FMHelper.setTran2String(companyIdSet));
        sql.append(" and sysSta.FName=");
        sql.append(system);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String periodId = null;
        HashSet<String> periodIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                if (type == 1) {
                    periodId = rs.getString("FStartPeriodID");
                } else if (type == 2) {
                    periodId = rs.getString("FCurrentPeriodID");
                }
                if (FMHelper.isEmpty(periodId)) continue;
                periodIdSet.add(periodId);
                map.put(rs.getString("companyId"), periodId);
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", periodIdSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        PeriodCollection periodColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        PeriodInfo periodInfo = null;
        int size = periodColl.size();
        for (int i = 0; i < size; ++i) {
            periodInfo = periodColl.get(i);
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getValue() instanceof String) || !periodInfo.getId().toString().equals((String)entry.getValue())) continue;
                map.put((String)entry.getKey(), (String)periodInfo);
            }
        }
        return map;
    }

    public static Map getStartPeriod(Context ctx, int system, Set companyIdSet) throws BOSException, EASBizException {
        return FmSysStatusCtrlUtils.getPeriod(ctx, system, companyIdSet, 1);
    }

    public static Map getCurrentPeriod(Context ctx, int system, Set companyIdSet) throws BOSException, EASBizException {
        return FmSysStatusCtrlUtils.getPeriod(ctx, system, companyIdSet, 2);
    }
}

