/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.Uuid;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class GenObject {
    private static final Logger logger = CoreUIObject.getLogger(GenObject.class);
    private static final String JAVA_MATH_BIGINTEGER = "java.math.BigInteger";
    private static final String JAVA_LANG_FLOAT = "java.lang.Float";
    private static final String JAVA_LANG_DOUBLE = "java.lang.Double";
    private static final String JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final String JAVA_SQL_DATE = "java.sql.Date";
    private static final String JAVA_UTIL_DATE = "java.util.Date";
    private static final String JAVA_LANG_BOOLEAN = "java.lang.Boolean";
    private static final String COM_KINGDEE_BOS_UTIL_UUID = "com.kingdee.bos.util.Uuid";
    private static final String COM_KINGDEE_BOS_UTIL_BOSUUID = "com.kingdee.bos.util.BOSUuid";
    private static final String JAVA_MATH_BIGDECIMAL = "java.math.BigDecimal";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_LANG_INTEGER = "java.lang.Integer";
    public static final String PROPERTY = "property";
    public static final String INDEX = "index";
    public static final String LIST = "list";
    public static final String NAME = "name";
    public static final String OBJECT = "object";
    public static final String VALUE = "value";
    public static final String CLASS = "class";

    public static GenObject getInstant() {
        return new GenObject();
    }

    public Object getObject(Element elem) {
        String cls = elem.getAttribute(CLASS).getValue();
        Object on = this.newIntance(cls, null);
        this.parseXmlToObject(on, elem);
        return on;
    }

    public void parseXmlToObject(Object o, Element elem) {
        if (elem == null) {
            return;
        }
        List child = elem.getChildren();
        for (int i = 0; i < child.size(); ++i) {
            Element ch = (Element)child.get(i);
            String cls = ch.getAttribute(CLASS).getValue();
            String value = ch.getAttributeValue(VALUE);
            String name = elem.getName();
            String property = null;
            Object on = this.newIntance(cls, value);
            if (name.equals(OBJECT)) {
                property = ch.getAttribute(NAME).getValue();
                this.buildProperty(o, property, on);
            } else if (name.equals(LIST)) {
                int index = Integer.parseInt(ch.getAttributeValue(INDEX));
                this.buildProperty(o, index, on);
            }
            this.parseXmlToObject(on, ch);
        }
    }

    private void buildProperty(Object o, String property, Object on) {
        if (o == null) {
            return;
        }
        if (o instanceof IObjectValue) {
            IObjectValue vo = (IObjectValue)o;
            vo.put(property, on);
            return;
        }
        try {
            Method m = o.getClass().getMethod(property, on.getClass());
            m.invoke(o, on);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void buildProperty(Object o, int index, Object on) {
        if (o == null) {
            return;
        }
        if (o instanceof IObjectCollection && on instanceof IObjectValue) {
            IObjectCollection vo = (IObjectCollection)o;
            vo.addObject(index, (IObjectValue)on);
            return;
        }
        logger.error((Object)"err");
    }

    public Object newIntance(String clsName, String value) {
        if (clsName == null) {
            return null;
        }
        if (clsName.equals(JAVA_LANG_INTEGER)) {
            return new Integer(value);
        }
        if (clsName.equals(JAVA_LANG_STRING)) {
            return value;
        }
        if (clsName.equals(JAVA_MATH_BIGDECIMAL)) {
            return new BigDecimal(value);
        }
        if (clsName.equals(COM_KINGDEE_BOS_UTIL_BOSUUID)) {
            return BOSUuid.read((String)value);
        }
        if (clsName.equals(COM_KINGDEE_BOS_UTIL_UUID)) {
            return Uuid.read((String)value);
        }
        if (clsName.equals(JAVA_LANG_BOOLEAN)) {
            return Boolean.valueOf(value);
        }
        if (clsName.equals(JAVA_UTIL_DATE)) {
            try {
                return DateFormat.getInstance().parse(value);
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        if (clsName.equals(JAVA_SQL_DATE)) {
            return Date.valueOf(value);
        }
        if (clsName.equals(JAVA_SQL_TIMESTAMP)) {
            return Timestamp.valueOf(value);
        }
        if (clsName.equals(JAVA_LANG_DOUBLE)) {
            return Double.valueOf(value);
        }
        if (clsName.equals(JAVA_LANG_FLOAT)) {
            return Float.valueOf(value);
        }
        if (clsName.equals(JAVA_MATH_BIGINTEGER)) {
            return new BigInteger(value);
        }
        try {
            return Class.forName(clsName).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

