/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.common.IvtModuleResourceReader;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.IntRateModifyType;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillCollection;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillFactory;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillInfo;
import com.kingdee.eas.fm.ivt.PenAccrualTypeEnum;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IvtModualUtils {
    public static final Integer VALUE_360 = Integer.valueOf("360");
    public static final Integer VALUE_30 = Integer.valueOf("30");
    public static final Integer VALUE_1 = Integer.valueOf("1");
    public static final Integer VALUE_0 = Integer.valueOf("0");
    public static final Integer SAVE = new Integer(1);
    public static final Integer AUDIT = new Integer(3);
    public static final Integer SUBMIT = new Integer(2);
    public static final Integer BOOK = new Integer(4);
    public static final Integer REPAY_INT = new Integer(2);
    public static final IvtModuleResourceReader RESOURCE_READER = new IvtModuleResourceReader();
    private static final Logger logger = CoreUIObject.getLogger(IvtModualUtils.class);
    protected static final String ACCORD_INTRATE_ID = "lJlpCQEQEADgAAc+wKgSjiR9knQ=";
    protected static final String ACCORD_GUDING_ID = "QYYAAAAKQTYkfZJ0";

    public static void comboPenAccrualTypeItemStateChanged(KDComboBox comboPenAccrualType, KDLabelContainer contPenaRateAfterAdj) {
        Object obj = comboPenAccrualType.getSelectedItem();
        if (obj instanceof com.kingdee.eas.fm.im.PenAccrualTypeEnum) {
            com.kingdee.eas.fm.im.PenAccrualTypeEnum penAccrualType = (com.kingdee.eas.fm.im.PenAccrualTypeEnum)comboPenAccrualType.getSelectedItem();
            if (penAccrualType == com.kingdee.eas.fm.im.PenAccrualTypeEnum.ADD_ACCRUAL) {
                contPenaRateAfterAdj.setBoundLabelText(IvtModuleResourceReader.getMsg("penarateafteradjust_thousand"));
            } else if (penAccrualType == com.kingdee.eas.fm.im.PenAccrualTypeEnum.ADD_PERCENT) {
                contPenaRateAfterAdj.setBoundLabelText(IvtModuleResourceReader.getMsg("penarateafteradjust_per"));
            }
        }
    }

    public static void comboRateExpressionItemStateChanged(KDComboBox comboRateExpression, KDFormattedTextField txtYearDays, KDLabelContainer contRateAfterAdjt) {
        Object selectRateex = comboRateExpression.getSelectedItem();
        if (selectRateex instanceof IntRateTypeExpressionEnum) {
            IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)((Object)comboRateExpression.getSelectedItem());
            if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
                txtYearDays.setValue((Object)VALUE_360);
                contRateAfterAdjt.setBoundLabelText(IvtModuleResourceReader.getMsg("rateafteradjust_per"));
            } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
                txtYearDays.setValue((Object)VALUE_30);
                contRateAfterAdjt.setBoundLabelText(IvtModuleResourceReader.getMsg("rateafteradj_thousand"));
            } else {
                txtYearDays.setValue((Object)VALUE_1);
                contRateAfterAdjt.setBoundLabelText(IvtModuleResourceReader.getMsg("rateafteradj_thousand"));
            }
        } else if (selectRateex instanceof com.kingdee.eas.fm.im.IntRateTypeExpressionEnum) {
            com.kingdee.eas.fm.im.IntRateTypeExpressionEnum intRateTypeExpressionEnum = (com.kingdee.eas.fm.im.IntRateTypeExpressionEnum)comboRateExpression.getSelectedItem();
            if (intRateTypeExpressionEnum == com.kingdee.eas.fm.im.IntRateTypeExpressionEnum.YEAR) {
                txtYearDays.setValue((Object)VALUE_360);
                contRateAfterAdjt.setBoundLabelText(IvtModuleResourceReader.getMsg("rateafteradjust_per"));
            } else if (intRateTypeExpressionEnum == com.kingdee.eas.fm.im.IntRateTypeExpressionEnum.MONTH) {
                txtYearDays.setValue((Object)VALUE_30);
                contRateAfterAdjt.setBoundLabelText(IvtModuleResourceReader.getMsg("rateafteradj_thousand"));
            } else {
                txtYearDays.setValue((Object)VALUE_1);
                contRateAfterAdjt.setBoundLabelText(IvtModuleResourceReader.getMsg("rateafteradj_thousand"));
            }
        }
    }

    public static void cboRelationsItemStateChanged(KDComboBox cboRelations, KDLabelContainer contCustomer, KDBizPromptBox prmtCustomer, KDLabelContainer contLoanCompany, KDBizPromptBox prmtLoanCompany) {
        Object rswc = cboRelations.getSelectedItem();
        if (rswc instanceof RelationshipWithLoanCompanyEnum) {
            if (rswc == RelationshipWithLoanCompanyEnum.EXTERIOR) {
                prmtLoanCompany.setValue(null);
                prmtCustomer.setEnabled(true);
                contLoanCompany.setVisible(false);
                contCustomer.setVisible(true);
            } else {
                prmtCustomer.setValue(null);
                prmtLoanCompany.setEnabled(true);
                contCustomer.setVisible(false);
                contLoanCompany.setVisible(true);
            }
        } else {
            prmtCustomer.setValue(null);
            prmtLoanCompany.setValue(null);
            contCustomer.setVisible(false);
            contLoanCompany.setVisible(false);
        }
    }

    public static void fillCboCurrency(KDComboBox cboCurrency) {
        CashHelper.initCombCurrency((KDComboBox)cboCurrency, (boolean)false);
        cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public static com.kingdee.eas.fm.im.IntRateTypeExpressionEnum convertEnumRateEx2Common(com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum rateExcpresion) {
        return com.kingdee.eas.fm.im.IntRateTypeExpressionEnum.getEnum((String)rateExcpresion.getValue());
    }

    public static com.kingdee.eas.fm.im.PenAccrualTypeEnum convertEnumPenaType2Common(PenAccrualTypeEnum penaType) {
        return com.kingdee.eas.fm.im.PenAccrualTypeEnum.getEnum((String)penaType.getValue());
    }

    public static com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum convertEnumRateEx2Ivt(com.kingdee.eas.fm.im.IntRateTypeExpressionEnum rateExcpresion) {
        return com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum.getEnum((String)rateExcpresion.getValue());
    }

    public static PenAccrualTypeEnum convertEnumPenaType2Ivt(com.kingdee.eas.fm.im.PenAccrualTypeEnum penaType) {
        return PenAccrualTypeEnum.getEnum((String)penaType.getValue());
    }

    public static void reverseSaveVoucherInfo(Context ctx, IObjectValue billInfo, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        if (new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                IvtModualUtils.setVoucherFlag(billInfo, Boolean.FALSE);
                IvtModualUtils.setVoucherInfo(ctx, billInfo, null);
            } else {
                IvtModualUtils.setVoucherFlag(billInfo, Boolean.TRUE);
                IvtModualUtils.setVoucherInfo(ctx, billInfo, botRelation.getDestObjectID());
            }
        }
    }

    private static void setVoucherInfo(Context ctx, IObjectValue billInfo, String voucherID) throws EASBizException, BOSException {
        try {
            Method setVoucher = billInfo.getClass().getMethod("setVoucher", VoucherInfo.class);
            Method setVoucherType = billInfo.getClass().getMethod("setVoucherType", VoucherTypeInfo.class);
            if (voucherID == null) {
                setVoucher.invoke((Object)billInfo, (Object[])new Class[]{null});
                setVoucherType.invoke((Object)billInfo, (Object[])new Class[]{null});
            } else {
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                setVoucher.invoke((Object)billInfo, (Object[])new VoucherInfo[]{voucherInfo});
                setVoucherType.invoke((Object)billInfo, (Object[])new VoucherTypeInfo[]{voucherInfo.getVoucherType()});
            }
        }
        catch (SecurityException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void setVoucherFlag(IObjectValue billInfo, Boolean flag) throws EASBizException, BOSException {
        try {
            Method setFiVouchered = billInfo.getClass().getMethod("setFivouchered", Boolean.class);
            setFiVouchered.invoke((Object)billInfo, (Object[])new Boolean[]{flag});
        }
        catch (SecurityException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean getSysParam(Context ctx, String paramName) {
        boolean val = false;
        if (ctx != null) {
            CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam(paramName, (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        } else {
            CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            val = ContextHelperFactory.getRemoteInstance().getBooleanParam(paramName, (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        }
        return val;
    }

    public static boolean getSysParamByCompany(Context ctx, String paramName, CompanyOrgUnitInfo company) {
        boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam(paramName, (IObjectPK)new ObjectUuidPK(company.getId()));
        return val;
    }

    public static void appendRow(KDTable tblMain, String[] fieldsArray, Object filterParam) {
        IvtModualUtils.appendRow(tblMain, fieldsArray, null);
    }

    private static String getCurrencyID(Object filterParam) {
        String retCurrency = null;
        Class<?> cls = filterParam.getClass();
        Method getCurrency = null;
        try {
            getCurrency = cls.getMethod("getCurrencyId", null);
            retCurrency = (String)getCurrency.invoke(filterParam, null);
        }
        catch (Exception e) {
            try {
                getCurrency = cls.getMethod("getCurrencyIdSet", null);
                Set idSet = (Set)getCurrency.invoke(filterParam, null);
                if (idSet != null && idSet.size() == 1) {
                    retCurrency = (String)idSet.toArray()[0];
                }
            }
            catch (Exception e1) {
                try {
                    getCurrency = cls.getMethod("getCurrency", null);
                    Object vvalue = getCurrency.invoke(filterParam, null);
                    if (vvalue != null) {
                        retCurrency = vvalue instanceof CurrencyInfo ? AccessHelper.getId(vvalue) : vvalue.toString();
                    }
                }
                catch (Exception e2) {
                    try {
                        getCurrency = cls.getMethod("getCurrencyInfo", null);
                        CurrencyInfo info = (CurrencyInfo)getCurrency.invoke(filterParam, null);
                        if (info != null) {
                            retCurrency = info.getId().toString();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return retCurrency;
    }

    public static void appendRow(KDTable tblMain, String[] fieldsArray, String currencyID) {
        if (currencyID == null) {
            currencyID = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getBaseCurrency().getId().toString();
        }
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (int j = 0; j < fieldsArray.length; ++j) {
            BigDecimal dbSum = new BigDecimal("0");
            for (int i = 0; i <= tblMain.getRowCount() - 1; ++i) {
                ICell cell = tblMain.getRow(i).getCell(fieldsArray[j]);
                if (cell == null) continue;
                String cellValue = tblMain.getCellDisplayText(cell);
                if (cellValue != null) {
                    cellValue = cellValue.toString().replaceAll(",", "");
                }
                if (!StringUtility.isNumber((String)cellValue)) {
                    Object cellObj = cell.getValue();
                    if (cellObj != null) {
                        cellValue = cellObj.toString();
                    }
                    if (!StringUtility.isNumber((String)cellValue)) continue;
                }
                BigDecimal bigdem = new BigDecimal(String.valueOf(cellValue).trim());
                if (cell.getMergeBlock() == null) {
                    dbSum = dbSum.add(bigdem);
                    continue;
                }
                int top = cell.getMergeBlock().getTop();
                if (i != top) continue;
                dbSum = dbSum.add(bigdem);
            }
            String strSum = dbSum.toString();
            columnMap.put(fieldsArray[j], strSum);
        }
        IRow footRow = null;
        KDTFootManager footRowManager = tblMain.getFootManager();
        if (footRowManager == null) {
            footRowManager = new KDTFootManager(tblMain);
            footRowManager.addFootView();
            tblMain.setFootManager(footRowManager);
        }
        if ((footRow = footRowManager.getFootRow(0)) == null) {
            String colFormat = "%{0.##########}f";
            String colName = "";
            footRow = footRowManager.addFootRow(0);
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            tblMain.getIndexColumn().setWidthAdjustMode((short)1);
            tblMain.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            for (Map.Entry colEntry : columnMap.entrySet()) {
                if (colEntry.getKey() == null) continue;
                String[] colArray = String.valueOf(colEntry.getKey()).split("@");
                colName = colArray[0];
                if (colArray.length > 1) {
                    colFormat = colArray[1];
                }
                if (footRow.getCell(colName) == null) continue;
                FMClientHelper.setNumberFormat(footRow, colName, currencyID);
                footRow.getCell(colName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                footRow.getCell(colName).getStyleAttributes().setFontColor(Color.BLACK);
            }
        }
        for (Map.Entry colEntry : columnMap.entrySet()) {
            if (colEntry.getKey() == null) continue;
            String colName = String.valueOf(colEntry.getKey());
            String colValue = (String)colEntry.getValue();
            if (footRow.getCell(colName) == null) continue;
            footRow.getCell(colName).setValue((Object)colValue);
        }
    }

    public static BigDecimal getExpendedRate(String ChLoanId) throws EASBizException, BOSException, UuidException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("rateType.*"));
        ChLoanInfo loan = ChLoanFactory.getRemoteInstance().getChLoanInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ChLoanId)), sic);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)ChLoanId));
        evi.setFilter(filter);
        SelectorItemCollection adjSic = new SelectorItemCollection();
        adjSic.add(new SelectorItemInfo("*"));
        adjSic.add(new SelectorItemInfo("IntRateType.*"));
        evi.setSelector(adjSic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("adjustDate");
        sorter.setSortType(SortType.DESCEND);
        sorterColl.add(sorter);
        evi.setSorter(sorterColl);
        ChLoanRateAdjustBillCollection adjColl = ChLoanRateAdjustBillFactory.getRemoteInstance().getChLoanRateAdjustBillCollection(evi);
        Date endDate = loan.getEndDate();
        String currencyID = loan.getCurrency().getId().toString();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)adjColl)) {
            ChLoanRateAdjustBillInfo adjustInfo = adjColl.get(0);
            if (IntRateModifyType.Agreement.equals((Object)adjustInfo.getModifyRateType())) {
                return adjustInfo.getRateAfterAdjt();
            }
            Date firstAdjustDay = adjustInfo.getFirstRateAdjustDate();
            int adjustPeriod = adjustInfo.getRateAdjustPeriod();
            IntRateTypeInfo rateType = adjustInfo.getIntRateType();
            FloatActionEnum floatAction = adjustInfo.getFloatAction();
            BigDecimal basePoint = adjustInfo.getBasePoints();
            String rateExpr = adjustInfo.getRateExpression().getName();
            return IvtModualUtils.getRate(firstAdjustDay, adjustPeriod, rateType, floatAction, basePoint, rateExpr, endDate, currencyID);
        }
        IntRateTypeInfo rateType = loan.getIntRateType();
        if (ACCORD_INTRATE_ID.equals(rateType.getId().toString()) || ACCORD_GUDING_ID.equals(rateType.getId().toString())) {
            return loan.getYearRate();
        }
        Date firstAdjustDay = loan.getFirstRateAdjustDate();
        int adjustPeriod = loan.getRateAdjustPeriod();
        FloatActionEnum floatAction = loan.getFloatAction();
        BigDecimal basePoint = loan.getFloatPoint();
        String rateExpr = loan.getIntRateTypeExpression().getName();
        return IvtModualUtils.getRate(firstAdjustDay, adjustPeriod, rateType, floatAction, basePoint, rateExpr, endDate, currencyID);
    }

    public static BigDecimal getRate(Date firstAdjustDay, int adjustPeriod, IntRateTypeInfo rateType, FloatActionEnum floatAction, BigDecimal basePoint, String rateExpr, Date endDate, String currencyID) throws EASBizException, BOSException {
        Date rateDate;
        if (adjustPeriod > 0) {
            Date nextPeriodDate;
            Date tempDate = nextPeriodDate = IvtModualUtils.getNextPeriodDate(firstAdjustDay, firstAdjustDay, adjustPeriod);
            while (endDate.compareTo(nextPeriodDate) >= 0) {
                tempDate = nextPeriodDate;
                nextPeriodDate = IvtModualUtils.getNextPeriodDate(firstAdjustDay, nextPeriodDate, adjustPeriod);
            }
            rateDate = tempDate;
        } else {
            rateDate = endDate;
        }
        IntRateBaseInfo intRateBase = IntRateBaseFactory.getRemoteInstance().getCurRateByCond(rateType.getId().toString(), currencyID, rateDate);
        BigDecimal bdBaseRate = intRateBase != null ? intRateBase.getYearRate() : Constants.ZERO;
        BigDecimal dividend = "YEAR".equalsIgnoreCase(rateExpr) ? Constants.ONE_HUNDRED : Constants.ONE_THOUSAND;
        BigDecimal bdYieldRate = Constants.ZERO;
        bdYieldRate = floatAction.equals((Object)FloatActionEnum.BASEINTRATE_FLOAT) ? bdBaseRate.multiply(new BigDecimal(String.valueOf(1)).add(basePoint.divide(dividend, 10, 4))) : bdBaseRate.add(basePoint);
        return bdYieldRate;
    }

    public static Date getNextPeriodDate(Date firstAdjustDay, Date prePeriod, int rateAdjustPeriod) {
        Calendar firstCalendar = Calendar.getInstance();
        firstCalendar.setTime(prePeriod);
        int flashDay = firstCalendar.get(5);
        firstCalendar.add(2, rateAdjustPeriod);
        if (flashDay >= 28) {
            int days = DateTimeUtils.daysOfMonth((int)firstCalendar.get(1), (int)(firstCalendar.get(2) + 1));
            if (IvtModualUtils.isLastDayOfMonth(firstAdjustDay)) {
                firstCalendar.set(5, days);
            } else {
                int firstRateAdjustDateDay = IvtModualUtils.getFirstRateAdjustDateDay(firstAdjustDay);
                if (days < firstRateAdjustDateDay) {
                    firstCalendar.set(5, days);
                } else {
                    firstCalendar.set(5, firstRateAdjustDateDay);
                }
            }
        }
        return firstCalendar.getTime();
    }

    public static boolean isLastDayOfMonth(Date firstRateAdjustDate) {
        if (firstRateAdjustDate == null) {
            return false;
        }
        Calendar firstCalendar = Calendar.getInstance();
        firstCalendar.setTime(firstRateAdjustDate);
        int dayOfMonth = firstCalendar.get(5);
        int lastDayOfMonth = DateTimeUtils.daysOfMonth((int)firstCalendar.get(1), (int)(firstCalendar.get(2) + 1));
        return dayOfMonth == lastDayOfMonth;
    }

    public static int getFirstRateAdjustDateDay(Date firstRateAdjustDate) {
        if (firstRateAdjustDate == null) {
            return 0;
        }
        Calendar firstCalendar = Calendar.getInstance();
        firstCalendar.setTime(firstRateAdjustDate);
        int dayOfMonth = firstCalendar.get(5);
        return dayOfMonth;
    }
}

