/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.fm.common.RSPredicate;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.sql.SQLException;
import javax.sql.RowSet;

public class OneRSPredicate
implements RSPredicate {
    private Object value;
    private String columnName;
    private int columnIndex;
    private boolean byName;
    private RowSet rs;

    public void setRs(RowSet rs) {
        this.rs = rs;
    }

    public RowSet getRs() {
        return this.rs;
    }

    @Override
    public boolean evaluate(RowSet rs) {
        try {
            this.rs = rs;
            if (this.byName) {
                return this.evaluate(this.value, this.columnName);
            }
            return this.evaluate(this.value, this.columnIndex);
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    public OneRSPredicate(Object value, String columnName) {
        this.value = value;
        this.columnName = columnName;
        this.byName = true;
    }

    public OneRSPredicate(Object value, int columnIndex) {
        this.value = value;
        this.columnIndex = columnIndex;
        this.byName = false;
    }

    @Override
    public boolean evaluate(Object value, String columnName) throws SQLException {
        if (value instanceof Integer) {
            Integer newValue = (Integer)value;
            return this.rs.getInt(columnName) == newValue.intValue();
        }
        return EqualsUtil.equals((Object)this.rs.getObject(columnName), (Object)value);
    }

    @Override
    public boolean evaluate(Object value, int column) throws SQLException {
        if (value instanceof Integer) {
            Integer newValue = (Integer)value;
            return this.rs.getInt(column) == newValue.intValue();
        }
        return EqualsUtil.equals((Object)this.rs.getObject(column), (Object)value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

