/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.ui.face.CoreUIObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResXmlParser {
    private static final Logger logger = CoreUIObject.getLogger(ResXmlParser.class);
    private static ResXmlParser _instance = new ResXmlParser();
    private Map result = new HashMap();
    private String packagePath = null;
    private String className = null;

    public static void main(String[] args) {
    }

    private ResXmlParser() {
    }

    public static ResXmlParser getInstance() {
        return _instance;
    }

    public void parse(File file) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            this.packagePath = doc.getElementsByTagName("package").item(0).getFirstChild().getNodeValue();
            this.className = doc.getElementsByTagName("name").item(0).getFirstChild().getNodeValue();
            String regex = "i18nResource\\[([^\\]]+)\\].resourceItems.resourceItem\\[([^\\]]+)\\].value";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = null;
            String resKey = null;
            String resValue = null;
            NodeList nodeList = doc.getElementsByTagName("rs");
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap attrMap = node.getAttributes();
                Node attrNode = attrMap.getNamedItem("key");
                String attrValue = attrNode.getNodeValue();
                matcher = pattern.matcher(attrValue);
                if (!matcher.matches()) continue;
                resKey = matcher.group(2);
                NodeList childNodeList = node.getChildNodes();
                int len1 = childNodeList.getLength();
                for (int j = 0; j < len1; ++j) {
                    Node langNode = childNodeList.item(j);
                    if (langNode.getNodeType() != 1 || !langNode.getNodeName().equals("lang") || !langNode.getAttributes().getNamedItem("locale").getNodeValue().equals("zh_CN")) continue;
                    resValue = langNode.getAttributes().getNamedItem("value").getNodeValue();
                    this.result.put(resKey, resValue);
                    logger.info((Object)(resKey + "=" + resValue));
                }
            }
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Map getResult() {
        return this.result;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String getClassName() {
        return this.className;
    }

    public String getTitle(File file) {
        String title = "";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = factory.newDocumentBuilder();
            try {
                doc = builder.parse(file);
            }
            catch (IOException e) {
                return null;
            }
            String regex2 = "uiObject\\[([^\\]]+)\\].title";
            String regex3 = "entityObject\\[([^\\]]+)\\].alias";
            Pattern pattern = Pattern.compile(regex2);
            Pattern pattern3 = Pattern.compile(regex3);
            Matcher matcher = null;
            Matcher matcher3 = null;
            String resValue = null;
            NodeList nodeList = doc.getElementsByTagName("rs");
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap attrMap = node.getAttributes();
                Node attrNode = attrMap.getNamedItem("key");
                String attrValue = attrNode.getNodeValue();
                matcher = pattern.matcher(attrValue);
                matcher3 = pattern3.matcher(attrValue);
                if (!matcher.matches() && !matcher3.matches()) continue;
                NodeList childNodeList = node.getChildNodes();
                int len1 = childNodeList.getLength();
                for (int j = 0; j < len1; ++j) {
                    Node langNode = childNodeList.item(j);
                    if (langNode.getNodeType() != 1 || !langNode.getNodeName().equals("lang") || !langNode.getAttributes().getNamedItem("locale").getNodeValue().equals("zh_CN")) continue;
                    resValue = langNode.getAttributes().getNamedItem("value").getNodeValue();
                    return resValue;
                }
            }
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return title;
    }
}

