/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.eas.util.client.ExceptionHandler;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.apache.log4j.Logger;

public final class SerialHelper {
    private static Logger logger = Logger.getLogger(SerialHelper.class);

    public static Object objectRead(String key) {
        Object obj = null;
        try {
            logger.info((Object)("read object " + key));
            FileInputStream objfile = new FileInputStream(key);
            ObjectInputStream p = new ObjectInputStream(objfile);
            obj = p.readObject();
            objfile.close();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return obj;
    }

    public static void objectWrite(Object obj, String key) {
        try {
            logger.debug((Object)("write object " + key));
            FileOutputStream objfile = new FileOutputStream(key);
            ObjectOutputStream p = new ObjectOutputStream(objfile);
            p.writeObject(obj);
            p.flush();
            objfile.close();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void showClassUrl(Class cl) {
        String className = cl.getName();
        logger.info((Object)className);
        String name = className.replace('.', '/') + ".class";
        ClassLoader classLoader = cl.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader != null) {
            logger.info((Object)classLoader.getResource(name));
        }
    }

    public static void showSerialVer(Class cl) {
        ObjectStreamClass osc = ObjectStreamClass.lookup(cl);
        logger.info((Object)("className: " + cl.getName()));
        logger.info((Object)("private static final long serialVersionUID = " + osc.getSerialVersionUID() + "L"));
    }
}

