/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TxtReader {
    private static Logger logger = Logger.getLogger(TxtReader.class);
    private static final String keyValueSeparators = "\uff0c,";
    private static final String quationMarkSeparators = "\"";

    public static KDSBook parse(InputStream stream) throws BOSException, IOException {
        KDSBook book = new KDSBook("test");
        KDSSheet kdssheet = new KDSSheet(book, "test");
        try {
            book.addSheet(null, kdssheet);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(stream, "GBK");
        BufferedReader in = new BufferedReader(inputStreamReader);
        String line = null;
        StringBuffer buf = new StringBuffer();
        ArrayList<String> strList = new ArrayList<String>();
        boolean i = false;
        int row = 0;
        int col = 0;
        while ((line = in.readLine()) != null) {
            if (TxtReader.verifyStringEmpty(line) || line.length() <= 0) continue;
            int len = line.length();
            i = false;
            strList.clear();
            for (int keyStart = 0; keyStart < len; ++keyStart) {
                if (quationMarkSeparators.indexOf(line.charAt(keyStart)) != -1) {
                    if (quationMarkSeparators.indexOf(line.charAt(keyStart + 1)) != -1) {
                        buf.append(line.charAt(keyStart + 1));
                        ++keyStart;
                        continue;
                    }
                    keyStart = TxtReader.parseCSV(keyStart++, line, buf);
                    continue;
                }
                if (keyValueSeparators.indexOf(line.charAt(keyStart)) == -1) {
                    buf.append(line.charAt(keyStart));
                    continue;
                }
                if (!TxtReader.verifyStringEmpty(buf.toString())) {
                    strList.add(buf.toString());
                } else {
                    strList.add("");
                }
                buf.delete(0, buf.length());
            }
            strList.add(buf.toString());
            buf.delete(0, buf.length());
            kdssheet.getRow(row, true);
            int size = strList.size();
            for (col = 0; col < size; ++col) {
                kdssheet.getColumn(col, true);
                logger.info((Object)("str" + col + ";" + strList.get(col)));
                kdssheet.getCell(row, col, true).setValue(strList.get(col));
            }
            ++row;
        }
        return book;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KDSBook parse(String file) throws BOSException {
        KDSBook book = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            book = TxtReader.parse(stream);
        }
        catch (IOException e) {
            try {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"81_TxtReader"));
                SysUtil.abort((Throwable)e);
            }
            catch (Throwable throwable) {
                TxtReader.closeStream(stream);
                throw throwable;
            }
            TxtReader.closeStream(stream);
        }
        TxtReader.closeStream(stream);
        return book;
    }

    private static boolean verifyStringEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static void closeStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private static int parseCSV(int start, String line, StringBuffer buf) {
        int keyStart = start;
        String str = line.substring(start);
        for (int i = 1; i < str.length(); ++i) {
            ++keyStart;
            if (quationMarkSeparators.indexOf(str.charAt(i)) == -1) {
                buf.append(str.charAt(i));
                continue;
            }
            if (quationMarkSeparators.indexOf(str.charAt(i + 1)) == -1) break;
            buf.append(str.charAt(i));
            ++i;
            ++keyStart;
        }
        return keyStart;
    }
}

