/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.application.WfSerializable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class WfSerializableBase
implements WfSerializable {
    public static final String SAX_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private Document doc;

    public WfSerializableBase() {
        Element elem = new Element("root");
        this.doc = new Document(elem);
    }

    public String toSerializeString() {
        XMLOutputter op = new XMLOutputter();
        return op.outputString(this.doc);
    }

    public void setString(String key, String value) {
        this.setObject(key, value);
    }

    public String getString(String key) {
        return this.getObject(key);
    }

    public boolean getBoolean(String key) {
        String value = this.getObject(key);
        return value != null && value.equals("1");
    }

    public void setBoolean(String key, boolean b) {
        this.setObject(key, b ? "1" : "0");
    }

    public BigDecimal getBigDecimal(String key) {
        String r = this.getObject(key);
        return r == null ? null : new BigDecimal(r);
    }

    public void setBigDecimal(String key, BigDecimal value) {
        this.setObject(key, value);
    }

    public int getInt(String key) {
        String r = this.getObject(key);
        return r == null ? 0 : Integer.parseInt(r);
    }

    public void setInt(String key, int value) {
        this.setObject(key, new Integer(value));
    }

    public void setBOSUuid(String key, BOSUuid value) {
        this.setObject(key, value);
    }

    public BOSUuid getBOSUuid(String key) {
        String r = this.getObject(key);
        return r == null ? null : BOSUuid.read((String)r);
    }

    public String getObject(String key) {
        Element child = this.doc.getRootElement().getChild(key);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public void setObject(String key, Object value) {
        if (value == null) {
            this.doc.getRootElement().removeChild(key);
            return;
        }
        Element element = null;
        element = this.doc.getRootElement().getChild(key);
        if (element == null) {
            element = new Element(key);
            this.doc.getRootElement().addContent((Content)element);
        }
        element.setText(value.toString());
    }

    public boolean readSerializeString(String arg0) {
        SAXBuilder builder = new SAXBuilder(SAX_PARSER_NAME, false);
        try {
            builder.build((InputStream)new ByteArrayInputStream(arg0.getBytes()));
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public String classVersion() {
        return "4.1";
    }
}

