/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;

class ActionSpHandler {
    KDComboBox cboCurrency;
    KDFormattedTextField txtAmt;
    KDFormattedTextField txtRate;
    KDFormattedTextField txtBaseAmt;
    CurrencyInfo baseCurrency;
    KDDatePicker bizDate;
    CompanyOrgUnitInfo currentCompany;

    public ActionSpHandler(KDComboBox cboCurrency, KDFormattedTextField txtAmt, KDFormattedTextField txtRate, KDFormattedTextField txtBaseAmt, CurrencyInfo baseCurrency, KDDatePicker bizDate, CompanyOrgUnitInfo currentCompany) {
        this.cboCurrency = cboCurrency;
        this.txtAmt = txtAmt;
        this.txtRate = txtRate;
        this.txtBaseAmt = txtBaseAmt;
        this.baseCurrency = baseCurrency;
        this.bizDate = bizDate;
        this.currentCompany = currentCompany;
        this.initAll();
    }

    void initAll() {
        if (this.cboCurrency == null || this.txtAmt == null) {
            return;
        }
        this.cboCurrency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ActionSpHandler.this.cboCurrency_acitonPerformed();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Component)ActionSpHandler.this.cboCurrency, (Throwable)e1);
                    SysUtil.abort();
                }
            }
        });
        this.txtAmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ActionSpHandler.this.txtAmt_dataChanged();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Component)ActionSpHandler.this.cboCurrency, (Throwable)e1);
                    SysUtil.abort();
                }
            }
        });
        this.txtAmt.setDataType(1);
        if (this.txtRate == null || this.txtBaseAmt == null) {
            return;
        }
        this.txtRate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ActionSpHandler.this.txtRate_dataChanged();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Component)ActionSpHandler.this.cboCurrency, (Throwable)e1);
                    SysUtil.abort();
                }
            }
        });
        this.txtRate.setDataType(1);
        if (this.baseCurrency == null) {
            return;
        }
        int precision = FMHelper.getPrecOfCurrency(null, this.baseCurrency.getId().toString());
        this.txtBaseAmt.setDataType(1);
        this.txtBaseAmt.setPrecision(precision);
    }

    private void cboCurrency_acitonPerformed() throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        int precision = FMHelper.getPrecOfCurrency(null, currency.getId().toString());
        this.txtAmt.setPrecision(precision);
        if (this.txtAmt.getBigDecimalValue() != null) {
            FMClientHelper.setCutValue(this.txtAmt, this.txtAmt.getBigDecimalValue());
        }
        if (this.txtRate == null || this.baseCurrency == null || this.currentCompany == null) {
            return;
        }
        this.txtRate.setRemoveingZeroInDispaly(false);
        if (currency.equalsPK((IObjectValue)this.baseCurrency)) {
            this.txtRate.setEnabled(false);
            this.txtRate.setEditable(false);
            this.txtRate.setValue((Object)Constants.ONE);
            this.txtRate.setRemoveingZeroInDispaly(true);
            return;
        }
        this.txtRate.setEnabled(true);
        this.txtRate.setEditable(true);
        this.txtRate.setRemoveingZeroInDispaly(false);
        Date date = (Date)(this.bizDate == null ? DateTimeUtils.truncateDate((Date)new Date()) : this.bizDate.getValue());
        ExchangeRateInfo exRate = FMHelper.getExRateInfo(currency, this.baseCurrency, this.currentCompany, date);
        if (exRate == null) {
            this.txtRate.setEnabled(true);
            this.txtRate.setEditable(true);
            this.txtRate.setValue((Object)Constants.ZERO);
        } else {
            int exRatePrecision = exRate.getPrecision() == -1 ? 3 : exRate.getPrecision();
            this.txtRate.setPrecision(exRatePrecision);
            FMClientHelper.setCutValue(this.txtRate, exRate.getConvertRate());
        }
    }

    private void txtAmt_dataChanged() throws Exception {
        if (this.txtBaseAmt == null) {
            return;
        }
        if (this.txtAmt.getBigDecimalValue() == null || this.txtRate.getBigDecimalValue() == null) {
            this.txtBaseAmt.setValue((Object)Constants.ZERO);
        } else {
            FMClientHelper.setCutValue(this.txtBaseAmt, this.txtAmt.getBigDecimalValue().multiply(this.txtRate.getBigDecimalValue()));
        }
    }

    private void txtRate_dataChanged() throws Exception {
        if (this.txtBaseAmt == null) {
            return;
        }
        if (this.txtAmt.getBigDecimalValue() == null || this.txtRate.getBigDecimalValue() == null) {
            this.txtBaseAmt.setValue((Object)Constants.ZERO);
        } else {
            FMClientHelper.setCutValue(this.txtBaseAmt, this.txtAmt.getBigDecimalValue().multiply(this.txtRate.getBigDecimalValue()));
        }
    }
}

