/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.fm.common.client.AbstractBankTreeSelectUI;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BankTreeSelectUI
extends AbstractBankTreeSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(BankTreeSelectUI.class);
    public static final String resourcePath = "com.kingdee.eas.fm.common.FMResource";
    private JDialog dialog = null;
    private TreeModel bakSelectedTreeModel = null;

    private void bakTreeSelected() {
        if (this.treeSelected.getModel().getRoot() != null) {
            KDTreeNode root2 = new KDTreeNode((Object)"");
            this.cloneTree((DefaultKingdeeTreeNode)root2, (DefaultKingdeeTreeNode)((KDTreeNode)this.treeSelected.getModel().getRoot()));
            this.bakSelectedTreeModel = new KingdeeTreeModel((TreeNode)root2);
        }
    }

    private void restoreTreeSelected() {
        if (this.bakSelectedTreeModel != null) {
            KDTreeNode root2 = new KDTreeNode((Object)"");
            this.cloneTree((DefaultKingdeeTreeNode)root2, (DefaultKingdeeTreeNode)((KDTreeNode)this.bakSelectedTreeModel.getRoot()));
            this.treeSelected.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root2));
            this.treeSelected.expandAllNodes(true, (TreeNode)this.treeSelected.getModel().getRoot());
        } else {
            KDTreeNode root = new KDTreeNode((Object)"");
            ((KingdeeTreeModel)this.treeSelected.getModel()).setRoot((TreeNode)root);
        }
    }

    private void cloneTree(DefaultKingdeeTreeNode root, DefaultKingdeeTreeNode oriRoot) {
        for (int i = 0; i < oriRoot.getChildCount(); ++i) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)oriRoot.getChildAt(i);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            root.add((MutableTreeNode)child);
            this.cloneTree(child, oriChild);
        }
    }

    public BankTreeSelectUI() throws Exception {
        this(new DefaultTreeModel((TreeNode)RptFmClientUtil.buildTreeByBankCollection(RptFmClientUtil.getBankCollection())));
    }

    public BankTreeSelectUI(TreeModel bankTreeModel) throws Exception {
        this.initUIContentLayout();
        if (bankTreeModel == null) {
            return;
        }
        this.treeBank.setModel(bankTreeModel);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeBank.getModel().getRoot();
        this.treeBank.expandAllNodes(true, (TreeNode)root);
        KingdeeTreeModel treeModel = (KingdeeTreeModel)this.treeSelected.getModel();
        if (treeModel.getRoot() != null) {
            KDTreeNode root2 = new KDTreeNode((Object)"");
            treeModel.setRoot((TreeNode)root2);
            this.treeSelected.setRootVisible(false);
            this.treeSelected.setShowsRootHandles(true);
        }
    }

    private void addTo(DefaultKingdeeTreeNode toNode, TreePath tp, int from) {
        DefaultKingdeeTreeNode root = null;
        while (from < tp.getPathCount()) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)tp.getPathComponent(from);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            if (from == tp.getPathCount() - 1) {
                this.cloneTree(child, oriChild);
            }
            if (toNode == null) {
                root = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot();
                ((KingdeeTreeModel)this.treeSelected.getModel()).insertNodeInto((MutableTreeNode)child, (MutableTreeNode)root, 0);
            } else {
                DefaultKingdeeTreeNode sibling = oriChild;
                DefaultKingdeeTreeNode found = null;
                while ((sibling = (DefaultKingdeeTreeNode)sibling.getNextSibling()) != null && (found = this.findNode(sibling, toNode)) == null) {
                }
                if (found != null) {
                    toNode.insert((MutableTreeNode)child, toNode.getIndex((TreeNode)found));
                } else {
                    toNode.add((MutableTreeNode)child);
                }
                ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)toNode);
            }
            toNode = child;
            ++from;
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        TreePath[] tps = this.treeBank.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            TreePath tp = tps[i];
            this.addPath(tp);
        }
        KDTreeNode root = (KDTreeNode)this.treeSelected.getModel().getRoot();
        this.treeSelected.expandAllNodes(true, (TreeNode)root);
        super.actionAdd_actionPerformed(e);
    }

    private void addPath(TreePath tp) {
        KDTreeNode rightRoot;
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        DefaultKingdeeTreeNode findNode = this.findNode(selectedNode, (DefaultKingdeeTreeNode)(rightRoot = (KDTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot()));
        if (findNode != null) {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)findNode.getParent();
            findNode.removeFromParent();
            ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)parent);
        }
        DefaultKingdeeTreeNode toNode = null;
        for (int j = 0; j < tp.getPathCount(); ++j) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getPathComponent(j);
            DefaultKingdeeTreeNode temp = null;
            temp = this.findNode(node, (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot());
            if (temp == null) {
                this.addTo(toNode, tp, j);
                continue;
            }
            toNode = temp;
        }
    }

    private DefaultKingdeeTreeNode findNode(DefaultKingdeeTreeNode source, DefaultKingdeeTreeNode dest) {
        if (source == null || dest == null) {
            return null;
        }
        if (source.getUserObject() != null && dest.getUserObject() != null && source.getUserObject().equals(dest.getUserObject())) {
            return dest;
        }
        for (int i = 0; i < dest.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)dest.getChildAt(i);
            if ((child = this.findNode(source, child)) == null) continue;
            return child;
        }
        return null;
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        TreePath[] tps = this.treeSelected.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            TreePath tp = tps[i];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            while (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                tp = tp.getParentPath();
                node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            }
            if (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                node = (DefaultKingdeeTreeNode)node.getParent();
            }
            ((KingdeeTreeModel)this.treeSelected.getModel()).removeNodeFromParent((MutableTreeNode)node);
        }
        super.actionDelete_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        KingdeeTreeModel tree = (KingdeeTreeModel)this.treeSelected.getModel();
        KDTreeNode root = (KDTreeNode)tree.getRoot();
        if (root.getChildCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"noBank"));
            return;
        }
        ArrayList list = new ArrayList();
        this.popNode(list, (DefaultKingdeeTreeNode)root);
        this.firePropertyChange("bankChanged", null, root);
        this.dialog.setVisible(false);
        super.actionConfirm_actionPerformed(e);
        this.bakTreeSelected();
    }

    private void popNode(List list, DefaultKingdeeTreeNode root) {
        Enumeration c = root.children();
        while (c.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)c.nextElement();
            BankInfo bankInfo = (BankInfo)node.getUserObject();
            if (bankInfo != null) {
                list.add(bankInfo);
            }
            this.popNode(list, node);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.restoreTreeSelected();
        this.dialog.setVisible(false);
        super.actionCancel_actionPerformed(e);
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public void setValue(TreeModel model) {
        this.treeSelected.setModel(model);
    }
}

