/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.fm.common.client.AbstractCompanyTreeSelectUI;
import com.kingdee.eas.fm.common.client.LayerTreeHelper;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CompanyTreeSelectUI
extends AbstractCompanyTreeSelectUI {
    public static final String resourcePath = "com.kingdee.eas.fm.common.FMResource";
    private JDialog dialog = null;
    private TreeModel bakSelectedTreeModel = null;
    private LayerTreeHelper layerTreeHelper = null;

    public CompanyTreeSelectUI(TreeModel cuTreeModel) throws Exception {
        this.initUIContentLayout();
        if (cuTreeModel == null) {
            return;
        }
        this.treeOrigin.setModel(cuTreeModel);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrigin.getModel().getRoot();
        this.treeOrigin.expandAllNodes(true, (TreeNode)root);
        KingdeeTreeModel treeModel = (KingdeeTreeModel)this.treeSelected.getModel();
        if (treeModel.getRoot() != null) {
            KDTreeNode root2 = new KDTreeNode((Object)"");
            treeModel.setRoot((TreeNode)root2);
            this.treeSelected.setRootVisible(false);
            this.treeSelected.setShowsRootHandles(true);
        }
    }

    public CompanyTreeSelectUI(TreeModel cuTreeModel, String[] companyIds) throws Exception {
        this.initUIContentLayout();
        if (cuTreeModel == null) {
            return;
        }
        this.treeOrigin.setModel(cuTreeModel);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrigin.getModel().getRoot();
        this.treeOrigin.expandAllNodes(true, (TreeNode)root);
        KingdeeTreeModel treeModel = (KingdeeTreeModel)this.treeSelected.getModel();
        if (treeModel.getRoot() != null) {
            KDTreeNode root2 = new KDTreeNode((Object)"");
            treeModel.setRoot((TreeNode)root2);
            this.treeSelected.setRootVisible(false);
            this.treeSelected.setShowsRootHandles(true);
        }
        if (companyIds == null) {
            return;
        }
        for (int i = 0; i < companyIds.length; ++i) {
            DefaultKingdeeTreeNode node = this.findNodeByCompany((DefaultKingdeeTreeNode)this.treeOrigin.getModel().getRoot(), companyIds[i]);
            if (node == null || node.getChildCount() > 0) continue;
            TreePath treePath = new TreePath(node.getPath());
            this.addPath(treePath);
        }
        this.treeSelected.expandAllNodes(true, (TreeNode)((KDTreeNode)this.treeSelected.getModel().getRoot()));
        this.bakTreeSelected();
    }

    public CompanyTreeSelectUI(String[] companyIds, IMetaDataPK metaDataPK, IMetaDataPK actionPK) throws Exception {
        this.initUIContentLayout();
        this.layerTreeHelper = new LayerTreeHelper(this.treeOrigin, this.treeSelected, companyIds, metaDataPK, actionPK);
        this.layerTreeHelper.init();
        this.bakTreeSelected();
    }

    public void expandSelectedNodes(String[] companyIds) {
        if (this.treeSelected == null || this.treeSelected.getModel() == null || companyIds == null) {
            return;
        }
        this.treeSelected.removeAllChildrenFromParent((MutableTreeNode)this.treeSelected.getModel().getRoot());
        for (int i = 0; i < companyIds.length; ++i) {
            DefaultKingdeeTreeNode node = this.findNodeByCompany((DefaultKingdeeTreeNode)this.treeOrigin.getModel().getRoot(), companyIds[i]);
            if (node == null || node.getChildCount() > 0) continue;
            TreePath treePath = new TreePath(node.getPath());
            this.addPath(treePath);
        }
        this.treeSelected.expandAllNodes(true, (TreeNode)((KDTreeNode)this.treeSelected.getModel().getRoot()));
        this.bakTreeSelected();
    }

    private void addTo(DefaultKingdeeTreeNode toNode, TreePath tp, int from) {
        DefaultKingdeeTreeNode root = null;
        while (from < tp.getPathCount()) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)tp.getPathComponent(from);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            if (from == tp.getPathCount() - 1) {
                this.cloneTree(child, oriChild);
            }
            if (toNode == null) {
                root = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot();
                ((KingdeeTreeModel)this.treeSelected.getModel()).insertNodeInto((MutableTreeNode)child, (MutableTreeNode)root, 0);
            } else {
                DefaultKingdeeTreeNode sibling = oriChild;
                DefaultKingdeeTreeNode found = null;
                while ((sibling = (DefaultKingdeeTreeNode)sibling.getNextSibling()) != null && (found = this.findNode(sibling, toNode)) == null) {
                }
                if (found != null) {
                    toNode.insert((MutableTreeNode)child, toNode.getIndex((TreeNode)found));
                } else {
                    toNode.add((MutableTreeNode)child);
                }
                ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)toNode);
            }
            toNode = child;
            ++from;
        }
    }

    private void cloneTree(DefaultKingdeeTreeNode root, DefaultKingdeeTreeNode oriRoot) {
        for (int i = 0; i < oriRoot.getChildCount(); ++i) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)oriRoot.getChildAt(i);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            root.add((MutableTreeNode)child);
            this.cloneTree(child, oriChild);
        }
    }

    private DefaultKingdeeTreeNode findNodeByCompany(DefaultKingdeeTreeNode des, String companyId) {
        if (des == null || companyId == null) {
            return null;
        }
        OrgStructureInfo org = (OrgStructureInfo)des.getUserObject();
        if (org != null && org.getUnit().getId().toString().equals(companyId)) {
            return des;
        }
        for (int i = 0; i < des.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)des.getChildAt(i);
            if ((child = this.findNodeByCompany(child, companyId)) == null) continue;
            return child;
        }
        return null;
    }

    private DefaultKingdeeTreeNode findNode(DefaultKingdeeTreeNode findNode, DefaultKingdeeTreeNode rootNode) {
        if (findNode == null || rootNode == null) {
            return null;
        }
        if (findNode.getUserObject() != null && rootNode.getUserObject() != null && findNode.getUserObject().equals(rootNode.getUserObject())) {
            return rootNode;
        }
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
            if ((child = this.findNode(findNode, child)) == null) continue;
            return child;
        }
        return null;
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        TreePath[] tps = this.treeOrigin.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            TreePath tp = tps[i];
            this.addPath(tp);
        }
        KDTreeNode root = (KDTreeNode)this.treeSelected.getModel().getRoot();
        this.treeSelected.expandAllNodes(true, (TreeNode)root);
        super.actionAdd_actionPerformed(e);
    }

    private void addPath(TreePath selectedTreePath) {
        KDTreeNode rightRoot;
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)selectedTreePath.getLastPathComponent();
        DefaultKingdeeTreeNode findNode = this.findNode(selectedNode, (DefaultKingdeeTreeNode)(rightRoot = (KDTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot()));
        if (findNode != null) {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)findNode.getParent();
            findNode.removeFromParent();
            ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)parent);
        }
        DefaultKingdeeTreeNode toNode = null;
        for (int j = 0; j < selectedTreePath.getPathCount(); ++j) {
            DefaultKingdeeTreeNode selectedTreePathWithOneNode = (DefaultKingdeeTreeNode)selectedTreePath.getPathComponent(j);
            DefaultKingdeeTreeNode temp = null;
            temp = this.findNode(selectedTreePathWithOneNode, (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot());
            if (temp == null) {
                this.addTo(toNode, selectedTreePath, j);
                continue;
            }
            toNode = temp;
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.restoreTreeSelected();
        this.dialog.setVisible(false);
        super.actionCancel_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        KingdeeTreeModel tree = (KingdeeTreeModel)this.treeSelected.getModel();
        KDTreeNode root = (KDTreeNode)tree.getRoot();
        if (root.getChildCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"noCompany"));
            return;
        }
        ArrayList list = new ArrayList();
        this.popNode(list, (DefaultKingdeeTreeNode)root);
        this.firePropertyChange("companyChanged", null, list.toArray());
        this.dialog.setVisible(false);
        super.actionConfirm_actionPerformed(e);
        this.bakTreeSelected();
    }

    private void popNode(List list, DefaultKingdeeTreeNode root) {
        Enumeration c = root.children();
        while (c.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)c.nextElement();
            OrgStructureInfo org = (OrgStructureInfo)node.getUserObject();
            if (org != null) {
                list.add(org.getUnit());
            }
            this.popNode(list, node);
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        TreePath[] tps = this.treeSelected.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            TreePath tp = tps[i];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            while (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                tp = tp.getParentPath();
                node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            }
            if (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                node = (DefaultKingdeeTreeNode)node.getParent();
            }
            ((KingdeeTreeModel)this.treeSelected.getModel()).removeNodeFromParent((MutableTreeNode)node);
        }
        super.actionDelete_actionPerformed(e);
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public void setValue(TreeModel model) {
        this.treeSelected.setModel(model);
    }

    private void bakTreeSelected() {
        if (this.treeSelected.getModel().getRoot() != null) {
            KDTreeNode root2 = new KDTreeNode((Object)"");
            this.cloneTree((DefaultKingdeeTreeNode)root2, (DefaultKingdeeTreeNode)((KDTreeNode)this.treeSelected.getModel().getRoot()));
            this.bakSelectedTreeModel = new KingdeeTreeModel((TreeNode)root2);
        }
    }

    private void restoreTreeSelected() {
        if (this.bakSelectedTreeModel != null) {
            KDTreeNode root2 = new KDTreeNode((Object)"");
            this.cloneTree((DefaultKingdeeTreeNode)root2, (DefaultKingdeeTreeNode)((KDTreeNode)this.bakSelectedTreeModel.getRoot()));
            this.treeSelected.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root2));
            this.treeSelected.expandAllNodes(true, (TreeNode)this.treeSelected.getModel().getRoot());
        } else {
            KDTreeNode root = new KDTreeNode((Object)"");
            ((KingdeeTreeModel)this.treeSelected.getModel()).setRoot((TreeNode)root);
        }
    }
}

