/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.ITablePrecisionProvider;
import com.kingdee.eas.util.client.EASResource;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DefaultExRatePrecProvider
implements ITablePrecisionProvider {
    private String companyColName;
    private String origCurrColName;
    private String dateColName;
    private Map map;

    public DefaultExRatePrecProvider(String companyColName, String currColName, String dateColName) {
        this.companyColName = companyColName;
        this.origCurrColName = currColName;
        this.dateColName = dateColName;
        this.map = new HashMap();
    }

    public DefaultExRatePrecProvider(String[] columnKeys) {
        if (columnKeys == null || columnKeys.length == 0) {
            throw new IllegalArgumentException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"11_DefaultExRatePrecProvider"));
        }
        this.companyColName = columnKeys[0];
        this.origCurrColName = columnKeys[1];
        this.dateColName = columnKeys[2];
        this.map = new HashMap();
    }

    private boolean isNotValid(IRow row, String colName) {
        return row == null || FMHelper.isEmpty(colName) || row.getCell(colName) == null || row.getCell(colName).getValue() == null;
    }

    @Override
    public int getPrecision(IRow row) throws EASBizException, BOSException {
        if (this.isNotValid(row, this.companyColName) || this.isNotValid(row, this.origCurrColName)) {
            return 5;
        }
        String companyId = row.getCell(this.companyColName).getValue().toString();
        String origCurrencyId = row.getCell(this.origCurrColName).getValue().toString();
        Date date = new Date();
        if (row.getCell(this.dateColName) != null) {
            date = (Date)row.getCell(this.dateColName).getValue();
        }
        String destCurrencyId = null;
        if (this.map.containsKey(companyId)) {
            destCurrencyId = (String)this.map.get(companyId);
        } else {
            destCurrencyId = this.getCurrencyId(companyId);
            this.map.put(companyId, destCurrencyId);
        }
        if (destCurrencyId == null) {
            return 5;
        }
        return FMClientHelper.getPrecOfExRate(companyId, origCurrencyId, destCurrencyId, date);
    }

    private String getCurrencyId(String companyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = FMClientHelper.getCompany(companyId);
        return company.getBaseCurrency().getId().toString();
    }
}

