/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import java.util.HashMap;
import java.util.Map;

public class DefaultKDTCurrencyProvider
implements IKDTPrecisionProvider {
    private String curIdColName = null;
    private Map currencyCache = new HashMap();

    public DefaultKDTCurrencyProvider(String curIdColName) {
        this.curIdColName = curIdColName;
    }

    @Override
    public int getPrecision(IRow row, int rowIndex, String colName) throws EASBizException, BOSException {
        Object objCurId = row.getCell(this.curIdColName).getValue();
        if (objCurId == null) {
            return 10;
        }
        String curId = row.getCell(this.curIdColName).getValue().toString();
        return this.queryCurrencyPrecision(curId);
    }

    protected int queryCurrencyPrecision(String curId) throws EASBizException, BOSException {
        if (this.currencyCache.containsKey(curId)) {
            Integer intPrec = (Integer)this.currencyCache.get(curId);
            return intPrec;
        }
        CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(curId));
        Integer intPrec = new Integer(cur.getPrecision());
        this.currencyCache.put(curId, intPrec);
        return intPrec;
    }
}

