/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;

public class DefaultKDTablePrecisionFormater
implements IKDTablePrecisionFormater {
    private KDTable kdt = null;
    private String[] preColNames = null;
    private IKDTPrecisionProvider precProvider = null;

    protected void toRunTimeException(Throwable e) {
        RuntimeException re = new RuntimeException(e);
        re.setStackTrace(e.getStackTrace());
        throw re;
    }

    protected void doAfterDataFill(KDTDataRequestEvent e) throws EASBizException, BOSException {
        int firstRowIndex = e.getFirstRow();
        int lastRowIndex = e.getLastRow();
        for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
            IRow row = this.kdt.getRow(i);
            if (this.precProvider == null) continue;
            int m = this.preColNames.length;
            for (int j = 0; j < m; ++j) {
                int prec = this.precProvider.getPrecision(row, i, this.preColNames[j]);
                row.getCell(this.preColNames[j]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm(prec));
                row.getCell(this.preColNames[j]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }

    public IKDTPrecisionProvider getPrecProvider() {
        return this.precProvider;
    }

    @Override
    public void setPrecProvider(IKDTPrecisionProvider precProvider) {
        this.precProvider = precProvider;
    }

    @Override
    public void init(KDTable kdt, String[] precColNames) {
        this.kdt = kdt;
        this.preColNames = precColNames;
        this.kdt.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    DefaultKDTablePrecisionFormater.this.doAfterDataFill(e);
                }
                catch (EASBizException e1) {
                    DefaultKDTablePrecisionFormater.this.toRunTimeException(e1);
                }
                catch (BOSException e1) {
                    DefaultKDTablePrecisionFormater.this.toRunTimeException(e1);
                }
            }
        });
    }
}

